/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.dock;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.block.IVesselLoader;
import dev.murad.shipping.block.dock.AbstractDockTileEntity;
import dev.murad.shipping.block.dock.AbstractTailDockTileEntity;
import dev.murad.shipping.block.dock.DockingBlockStates;
import dev.murad.shipping.util.InventoryUtils;
import dev.murad.shipping.util.LinkableEntity;
import dev.murad.shipping.util.LinkableEntityHead;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractHeadDockTileEntity<T extends Entity>
extends AbstractDockTileEntity<T> {
    public AbstractHeadDockTileEntity(BlockEntityType<?> t, BlockPos pos, BlockState state) {
        super(t, pos, state);
    }

    protected boolean handleItemHopper(T tugEntity, HopperBlockEntity hopper) {
        if (!(tugEntity instanceof Container)) {
            return false;
        }
        return InventoryUtils.mayMoveIntoInventory((Container)tugEntity, (Container)hopper);
    }

    @Override
    public boolean hold(T tug, Direction direction) {
        if (!(tug instanceof LinkableEntityHead) || this.checkBadDirCondition(tug, direction)) {
            return false;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)DockingBlockStates.POWERED)).booleanValue()) {
            return true;
        }
        for (BlockPos p : this.getTargetBlockPos()) {
            if (!this.getHopper(p).map(hopper -> this.handleItemHopper(tug, (HopperBlockEntity)hopper)).orElse(this.getVesselLoader(p).map(l -> l.hold(tug, IVesselLoader.Mode.EXPORT)).orElse(false)).booleanValue()) continue;
            return true;
        }
        List<Pair<T, AbstractTailDockTileEntity<T>>> barges = this.getTailDockPairs(tug);
        return barges.stream().map(pair -> ((AbstractTailDockTileEntity)((Object)((Object)pair.getSecond()))).hold((Entity)pair.getFirst(), direction)).reduce(false, Boolean::logicalOr) != false;
    }

    protected abstract boolean checkBadDirCondition(T var1, Direction var2);

    protected abstract Direction getRowDirection(Direction var1);

    private List<Pair<T, AbstractTailDockTileEntity<T>>> getTailDockPairs(T tug) {
        List barges = ((LinkableEntity)tug).getTrain().asListOfTugged();
        List docks = this.getTailDocks();
        return IntStream.range(0, Math.min(barges.size(), docks.size())).mapToObj(i -> new Pair((Object)((Entity)barges.get(i)), (Object)((AbstractTailDockTileEntity)((Object)((Object)docks.get(i)))))).collect(Collectors.toList());
    }

    private List<AbstractTailDockTileEntity<T>> getTailDocks() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)DockingBlockStates.FACING);
        Direction rowDirection = this.getRowDirection(facing);
        ArrayList<AbstractTailDockTileEntity<T>> docks = new ArrayList<AbstractTailDockTileEntity<T>>();
        Optional<AbstractTailDockTileEntity<T>> dock = this.getNextBargeDock(rowDirection, this.m_58899_());
        while (dock.isPresent()) {
            docks.add(dock.get());
            dock = this.getNextBargeDock(rowDirection, dock.get().m_58899_());
        }
        return docks;
    }

    private Optional<AbstractTailDockTileEntity<T>> getNextBargeDock(Direction rowDirection, BlockPos pos) {
        BlockPos next = pos.m_121945_(rowDirection);
        return Optional.ofNullable(this.f_58857_.m_7702_(next)).filter(e -> e instanceof AbstractTailDockTileEntity).map(e -> (AbstractTailDockTileEntity)((Object)e));
    }
}

