/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.setup;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Function4;
import dev.murad.shipping.entity.custom.train.AbstractTrainCarEntity;
import dev.murad.shipping.entity.custom.train.locomotive.EnergyLocomotiveEntity;
import dev.murad.shipping.entity.custom.train.locomotive.SteamLocomotiveEntity;
import dev.murad.shipping.entity.custom.train.wagon.ChestCarEntity;
import dev.murad.shipping.entity.custom.train.wagon.FluidTankCarEntity;
import dev.murad.shipping.entity.custom.train.wagon.SeaterCarEntity;
import dev.murad.shipping.entity.custom.vessel.barge.ChestBargeEntity;
import dev.murad.shipping.entity.custom.vessel.barge.FishingBargeEntity;
import dev.murad.shipping.entity.custom.vessel.barge.FluidTankBargeEntity;
import dev.murad.shipping.entity.custom.vessel.barge.SeaterBargeEntity;
import dev.murad.shipping.entity.custom.vessel.barge.VacuumBargeEntity;
import dev.murad.shipping.entity.custom.vessel.tug.EnergyTugEntity;
import dev.murad.shipping.entity.custom.vessel.tug.SteamTugEntity;
import dev.murad.shipping.item.LocoRouteItem;
import dev.murad.shipping.item.SpringItem;
import dev.murad.shipping.item.TrainCarItem;
import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.item.VesselItem;
import dev.murad.shipping.item.WrenchItem;
import dev.murad.shipping.item.creative.CreativeCapacitor;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.Registration;
import dev.murad.shipping.util.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    private static final MultiMap<ResourceKey<CreativeModeTab>, RegistryObject<? extends Item>> PRIVATE_TAB_REGISTRY = new MultiMap();
    public static final ResourceLocation LOCO_ROUTE_ICON = new ResourceLocation("littlelogistics", "item/empty_loco_route");
    public static final ResourceLocation TUG_ROUTE_ICON = new ResourceLocation("littlelogistics", "item/empty_tug_route");
    public static final ResourceLocation EMPTY_ENERGY = new ResourceLocation("littlelogistics", "item/empty_energy");
    public static final RegistryObject<Item> CONDUCTORS_WRENCH = ModItems.register("conductors_wrench", () -> new WrenchItem(new Item.Properties().m_41487_(1)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> SPRING = ModItems.register("spring", () -> new SpringItem(new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> CREATIVE_CAPACITOR = ModItems.register("creative_capacitor", () -> new CreativeCapacitor(new Item.Properties().m_41487_(1)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> CHEST_BARGE = ModItems.register("barge", () -> new VesselItem(new Item.Properties(), (level, x, y, z) -> new ChestBargeEntity((EntityType<? extends ChestBargeEntity>)((EntityType)ModEntityTypes.CHEST_BARGE.get()), level, x, y, z)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> BARREL_BARGE = ModItems.register("barrel_barge", () -> new VesselItem(new Item.Properties(), (level, x, y, z) -> new ChestBargeEntity((EntityType<? extends ChestBargeEntity>)((EntityType)ModEntityTypes.BARREL_BARGE.get()), level, x, y, z)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> FISHING_BARGE = ModItems.register("fishing_barge", () -> new VesselItem(new Item.Properties(), FishingBargeEntity::new), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> FLUID_BARGE = ModItems.register("fluid_barge", () -> new VesselItem(new Item.Properties(), FluidTankBargeEntity::new), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> SEATER_BARGE = ModItems.register("seater_barge", () -> new VesselItem(new Item.Properties(), SeaterBargeEntity::new), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> VACUUM_BARGE = ModItems.register("vacuum_barge", () -> new VesselItem(new Item.Properties(), VacuumBargeEntity::new), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> STEAM_TUG = ModItems.register("tug", () -> new VesselItem(new Item.Properties(), SteamTugEntity::new), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> ENERGY_TUG = ModItems.register("energy_tug", () -> new VesselItem(new Item.Properties(), EnergyTugEntity::new), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> TUG_ROUTE = ModItems.register("tug_route", () -> new TugRouteItem(new Item.Properties().m_41487_(16)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> CHEST_CAR = ModItems.register("chest_car", () -> new TrainCarItem((Function4<Level, Double, Double, Double, AbstractTrainCarEntity>)((Function4)(level, x, y, z) -> new ChestCarEntity((EntityType<ChestCarEntity>)((EntityType)ModEntityTypes.CHEST_CAR.get()), (Level)level, (Double)x, (Double)y, (Double)z)), new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> BARREL_CAR = ModItems.register("barrel_car", () -> new TrainCarItem((Function4<Level, Double, Double, Double, AbstractTrainCarEntity>)((Function4)(level, x, y, z) -> new ChestCarEntity((EntityType<ChestCarEntity>)((EntityType)ModEntityTypes.BARREL_CAR.get()), (Level)level, (Double)x, (Double)y, (Double)z)), new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> FLUID_CAR = ModItems.register("fluid_car", () -> new TrainCarItem((Function4<Level, Double, Double, Double, AbstractTrainCarEntity>)((Function4)FluidTankCarEntity::new), new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> SEATER_CAR = ModItems.register("seater_car", () -> new TrainCarItem((Function4<Level, Double, Double, Double, AbstractTrainCarEntity>)((Function4)SeaterCarEntity::new), new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> STEAM_LOCOMOTIVE = ModItems.register("steam_locomotive", () -> new TrainCarItem((Function4<Level, Double, Double, Double, AbstractTrainCarEntity>)((Function4)SteamLocomotiveEntity::new), new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> ENERGY_LOCOMOTIVE = ModItems.register("energy_locomotive", () -> new TrainCarItem((Function4<Level, Double, Double, Double, AbstractTrainCarEntity>)((Function4)EnergyLocomotiveEntity::new), new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> RECEIVER_COMPONENT = ModItems.register("receiver_component", () -> new Item(new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> TRANSMITTER_COMPONENT = ModItems.register("transmitter_component", () -> new Item(new Item.Properties().m_41487_(64)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));
    public static final RegistryObject<Item> LOCO_ROUTE = ModItems.register("locomotive_route", () -> new LocoRouteItem(new Item.Properties().m_41487_(16)), (List<ResourceKey<CreativeModeTab>>)ImmutableList.of((Object)CreativeModeTabs.f_256869_));

    public static void buildCreativeTab(BuildCreativeModeTabContentsEvent event) {
        ((List)PRIVATE_TAB_REGISTRY.getOrDefault(event.getTabKey(), (RegistryObject<? extends Item>)new ArrayList())).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> itemSupplier, List<ResourceKey<CreativeModeTab>> tabs) {
        RegistryObject res = Registration.ITEMS.register(name, itemSupplier);
        for (ResourceKey<CreativeModeTab> tab : tabs) {
            PRIVATE_TAB_REGISTRY.putInsert(tab, (RegistryObject<? extends Item>)res);
        }
        return res;
    }

    public static void register() {
    }
}

