/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.world.structure;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.blockentity.TreasureChestBlockEntity;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import com.legacy.lost_aether.LostContentMod;
import com.legacy.lost_aether.data.LCLootProv;
import com.legacy.lost_aether.entity.AerwhaleKingEntity;
import com.legacy.lost_aether.registry.LCBlocks;
import com.legacy.lost_aether.registry.LCEntityTypes;
import com.legacy.lost_aether.registry.LCItems;
import com.legacy.lost_aether.registry.LCStructures;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PlatinumDungeonPieces {
    private static final ResourceLocation TOWER = PlatinumDungeonPieces.locatePiece("tower");
    private static final ResourceLocation GROUND = PlatinumDungeonPieces.locatePiece("ground");

    public static void assemble(StructureTemplateManager templateManager, BlockPos pos, Rotation rotation, StructurePiecesBuilder builder, RandomSource random, RandomState randomState) {
        builder.m_142679_((StructurePiece)new Piece(templateManager, GROUND, pos, rotation));
        builder.m_142679_((StructurePiece)new Piece(templateManager, TOWER, pos.m_121955_((Vec3i)new BlockPos(9, 21, 9)), rotation));
    }

    static ResourceLocation locatePiece(String location) {
        return LostContentMod.locate("platinum_dungeon/" + location);
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation name, BlockPos pos, Rotation rotation) {
            super((StructurePieceType)LCStructures.PLATINUM_DUNGEON.getPieceType("main").get(), 0, structureManager, name, Piece.getPlacementSettings(structureManager, name, pos, rotation), pos);
            this.f_73379_ = rotation;
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)LCStructures.PLATINUM_DUNGEON.getPieceType("main").get(), nbt, context.f_226956_(), name -> Piece.getPlacementSettings(context.f_226956_(), name, new BlockPos(nbt.m_128451_("TPX"), nbt.m_128451_("TPY"), nbt.m_128451_("TPZ")), Rotation.valueOf((String)nbt.m_128461_("Rot"))));
        }

        private static StructurePlaceSettings getPlacementSettings(StructureTemplateManager structureManager, ResourceLocation name, BlockPos pos, Rotation rotation) {
            Vec3i sizePos = ((StructureTemplate)structureManager.m_230407_(name).get()).m_163801_();
            BlockPos centerPos = new BlockPos(sizePos.m_123341_() / 2, 0, sizePos.m_123343_() / 2);
            StructurePlaceSettings placementSettings = new StructurePlaceSettings().m_163782_(false).m_74385_(centerPos).m_74379_(rotation).m_74377_(Mirror.NONE);
            placementSettings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
            placementSettings.m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            return placementSettings;
        }

        public BlockState modifyState(ServerLevelAccessor level, RandomSource rand, BlockPos pos, BlockState originalState) {
            if (originalState.m_60734_() == LCBlocks.locked_gale_stone && rand.m_188501_() < 0.05f) {
                return LCBlocks.locked_light_gale_stone.m_49966_();
            }
            if (rand.m_188501_() < 0.005f) {
                if (originalState.m_60734_() == LCBlocks.locked_gale_stone) {
                    return LCBlocks.trapped_gale_stone.m_49966_();
                }
                if (originalState.m_60734_() == LCBlocks.locked_light_gale_stone) {
                    return LCBlocks.trapped_light_gale_stone.m_49966_();
                }
            }
            return originalState;
        }

        public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox bounds, ChunkPos chunkPosIn, BlockPos pos) {
            super.m_213694_(level, structureManager, chunkGeneratorIn, randomIn, bounds, chunkPosIn, pos);
        }

        protected void m_213704_(String function, BlockPos pos, ServerLevelAccessor level, RandomSource rand, BoundingBox sbb) {
            if (function.contains("boss")) {
                AerwhaleKingEntity entity = new AerwhaleKingEntity(LCEntityTypes.AERWHALE_KING, (Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() - 16.0, (double)pos.m_123342_() + 12.0, pos.m_123343_());
                entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                entity.setDungeon((BossRoomTracker<AerwhaleKingEntity>)new BossRoomTracker((Mob)entity, Vec3.m_82539_((Vec3i)pos), new AABB(pos).m_82377_(20.0, 18.0, 20.0).m_82386_(0.0, 17.0, 0.0), new ArrayList()));
                entity.m_5616_(180.0f);
                level.m_7967_((Entity)entity);
            } else if (function.contains("platinum_chest")) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                BlockEntity blockEntity = level.m_7702_(pos.m_7495_());
                if (blockEntity instanceof TreasureChestBlockEntity) {
                    TreasureChestBlockEntity be = (TreasureChestBlockEntity)blockEntity;
                    be.m_59626_(LCLootProv.PLATINUM_TREASURE_LOOT, rand.m_188505_());
                    be.setKind(LCItems.PLATINUM_KEY_TYPE);
                }
            } else if (function.contains("loot_chest")) {
                BlockPos blockpos = pos.m_7495_();
                BlockEntity tile = level.m_7702_(blockpos);
                if (tile instanceof ChestBlockEntity) {
                    ChestBlockEntity chest = (ChestBlockEntity)tile;
                    if (rand.m_188501_() < 0.2f) {
                        if (level.m_8055_(blockpos).m_61138_((Property)ChestBlock.f_51478_)) {
                            level.m_7731_(blockpos, (BlockState)((Block)AetherBlocks.CHEST_MIMIC.get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)((Direction)level.m_8055_(blockpos).m_61143_((Property)ChestBlock.f_51478_))), 3);
                        }
                    } else {
                        chest.m_59626_(LCLootProv.PLATINUM_DUNGEON_LOOT, rand.m_188505_());
                    }
                }
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    public static class StoneFillPiece
    extends StructurePiece {
        protected StoneFillPiece(BlockPos pos, BlockPos size, int componentType) {
            super((StructurePieceType)LCStructures.PLATINUM_DUNGEON.getPieceType("stone_fill").get(), componentType, BoundingBox.m_162375_((Vec3i)pos, (Vec3i)pos.m_121955_((Vec3i)size)));
        }

        public StoneFillPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)LCStructures.PLATINUM_DUNGEON.getPieceType("stone_fill").get(), nbt);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            this.m_73441_(world, bounds, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), ((Block)AetherBlocks.AETHER_DIRT.get()).m_49966_(), ((Block)AetherBlocks.AETHER_DIRT.get()).m_49966_(), false);
        }
    }
}

