/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lostcities.api.LostChunkCharacteristics;
import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.config.ProfileSetup;
import mcjty.lostcities.gui.LostCitySetup;
import mcjty.lostcities.gui.NullDimensionInfo;
import mcjty.lostcities.gui.elements.BooleanElement;
import mcjty.lostcities.gui.elements.ButtonExt;
import mcjty.lostcities.gui.elements.DoubleElement;
import mcjty.lostcities.gui.elements.FloatElement;
import mcjty.lostcities.gui.elements.GuiElement;
import mcjty.lostcities.gui.elements.IntElement;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.City;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Railway;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GuiLCConfig
extends Screen {
    private final Screen parent;
    private Button profileButton;
    private Button worldstyleButton;
    private Button customizeButton;
    private Button modeButton;
    private static final int YOFFSET = 21;
    private String curpage;
    private int y;
    private static final List<String> MODES = Arrays.asList("Cities", "Buildings", "Damage", "Transport", "Various");
    private String mode = MODES.get(0);
    private long seed = 3439249320423L;
    private final Random random = new Random();
    private final List<GuiElement> elements = new ArrayList<GuiElement>();
    private DoubleElement perlinScaleElement;
    private DoubleElement perlinOffsetElement;
    private DoubleElement perlinInnerScaleElement;
    private final LostCitySetup localSetup = new LostCitySetup(this::refreshPreview);

    public GuiLCConfig(Screen parent) {
        super((Component)ComponentFactory.literal("Lost City Configuration"));
        this.parent = parent;
        this.localSetup.copyFrom(LostCitySetup.CLIENT_SETUP);
    }

    private static void selectProfile(String profileName, @Nullable LostCityProfile profile) {
        Config.profileFromClient = profileName;
        ++LostCityFeature.globalDimensionInfoDirtyCounter;
        Config.resetProfileCache();
        if (profile != null) {
            ProfileSetup.STANDARD_PROFILES.get("customized").copyFrom(profile);
            Config.jsonFromClient = profile.toJson(false).toString();
        }
    }

    public LostCitySetup getLocalSetup() {
        return this.localSetup;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public void m_86600_() {
        this.elements.forEach(GuiElement::tick);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.profileButton = (Button)this.m_142416_((GuiEventListener)new ButtonExt(this, 55, 10, 80, 20, (Component)ComponentFactory.literal(this.localSetup.getProfileLabel()), p -> {
            this.localSetup.toggleProfile();
            this.updateValues();
        }).tooltip((Component)ComponentFactory.literal("Select a standard profile for your Lost City worldgen")));
        this.worldstyleButton = (Button)this.m_142416_((GuiEventListener)new ButtonExt(this, 145, 10, 120, 20, (Component)ComponentFactory.literal(this.localSetup.getWorldStyleLabel()), p -> {
            this.localSetup.toggleWorldStyle();
            this.updateValues();
        }).tooltip((Component)ComponentFactory.literal("Select the worldstyle to use for this profile")));
        this.customizeButton = (Button)this.m_142416_((GuiEventListener)new ButtonExt(this, 275, 10, 70, 20, (Component)ComponentFactory.literal("Customize"), p -> {
            this.localSetup.customize();
            this.updateValues();
        }).tooltip((Component)ComponentFactory.literal("Create a customized version of the currently selected profile")));
        this.modeButton = (Button)this.m_142416_((GuiEventListener)new ButtonExt(this, 355, 10, 70, 20, (Component)ComponentFactory.literal(this.mode), p -> this.toggleMode()).tooltip((Component)ComponentFactory.literal("Switch between different configuration pages")));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ComponentFactory.literal("Done"), p -> this.done()).m_252987_(10, this.f_96544_ - 30, 120, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ComponentFactory.literal("Cancel"), p -> this.cancel()).m_252987_(this.f_96543_ - 130, this.f_96544_ - 30, 120, 20).m_253136_());
        this.m_142416_((GuiEventListener)new ButtonExt(this, this.f_96543_ - 35, 35, 30, 20, (Component)ComponentFactory.literal("Rnd"), p -> this.randomizePreview()).tooltip((Component)ComponentFactory.literal("Randomize the seed for the preview (does not affect the generated world)")));
        this.initCities(110);
        this.initBuildings(110);
        this.initDamage(70);
        this.initTransport(110);
        this.initVarious(110);
        this.updateValues();
    }

    private BooleanElement addBool(int left, String attribute) {
        BooleanElement el = new BooleanElement(this, this.curpage, left, this.y, attribute);
        this.add(el);
        return el;
    }

    private DoubleElement addDouble(int left, int w, String attribute) {
        DoubleElement el = new DoubleElement(this, this.curpage, left, this.y, w, attribute);
        this.add(el);
        return el;
    }

    private FloatElement addFloat(int left, String attribute) {
        FloatElement el = new FloatElement(this, this.curpage, left, this.y, attribute);
        this.add(el);
        return el;
    }

    private IntElement addInt(int left, String attribute) {
        IntElement el = new IntElement(this, this.curpage, left, this.y, attribute);
        this.add(el);
        return el;
    }

    private void start(String name) {
        this.curpage = name;
        this.y = 40;
    }

    private void nl() {
        this.y += 21;
    }

    private void initVarious(int left) {
        this.start("Various");
        this.addBool(left, "lostcity.generateSpawners").label("Spawners:");
        this.nl();
        this.addBool(left, "lostcity.generateLighting").label("Lighting:");
        this.nl();
        this.addBool(left, "lostcity.generateLoot").label("Loot:");
        this.nl();
        this.addFloat(left, "lostcity.vineChance").label("Vines:");
        this.nl();
        this.addFloat(left, "lostcity.randomLeafBlockChance").label("Leafs:");
        this.nl();
        this.nl();
        this.addBool(left, "lostcity.generateNether").label("Nether:");
        this.nl();
        this.addBool(left, "lostcity.editMode").label("Edit mode:");
    }

    private void initDamage(int left) {
        this.start("Damage");
        this.addBool(left, "lostcity.rubbleLayer").label("Rubble:");
        this.nl();
        this.addFloat(left, "lostcity.ruinChance").label("Ruins:").prefix("%");
        this.addFloat(left + 80, "lostcity.ruinMinlevelPercent").prefix("-");
        this.addFloat(left + 140, "lostcity.ruinMaxlevelPercent").prefix("+");
        this.nl();
        this.addFloat(left, "explosions.explosionChance").label("Explosion:").prefix("%");
        this.addInt(left + 80, "explosions.explosionMinRadius").prefix("-");
        this.addInt(left + 140, "explosions.explosionMaxRadius").prefix("+");
        this.nl();
        this.addInt(left + 80, "explosions.explosionMinHeight").label("Height:");
        this.addInt(left + 140, "explosions.explosionMaxHeight");
        this.nl();
        this.addFloat(left, "explosions.miniExplosionChance").label("Min/exp:").prefix("%");
        this.addInt(left + 80, "explosions.miniExplosionMinRadius").prefix("-");
        this.addInt(left + 140, "explosions.miniExplosionMaxRadius").prefix("+");
        this.nl();
        this.addInt(left + 80, "explosions.miniExplosionMinHeight").label("Height:");
        this.addInt(left + 140, "explosions.miniExplosionMaxHeight");
        this.nl();
    }

    private void initBuildings(int left) {
        this.start("Buildings");
        this.addFloat(left, "lostcity.buildingChance").label("Buildings:");
        this.nl();
        this.addFloat(left, "lostcity.building2x2Chance").label("Buildings 2x2:");
        this.nl();
        this.nl();
        this.addInt(left, "lostcity.buildingMinFloors").label("Floors:");
        this.addInt(left + 55, "lostcity.buildingMaxFloors");
        this.nl();
        this.addInt(left, "lostcity.buildingMinFloorsChance").label("Floor Chance:");
        this.addInt(left + 55, "lostcity.buildingMaxFloorsChance");
        this.nl();
        this.addInt(left, "lostcity.buildingMinCellars").label("Cellars:");
        this.addInt(left + 55, "lostcity.buildingMaxCellars");
    }

    private void initTransport(int left) {
        this.start("Transport");
        this.addFloat(left, "lostcity.highwayMainPerlinScale").label("1st perlin:");
        this.nl();
        this.addFloat(left, "lostcity.highwaySecondaryPerlinScale").label("2nd perlin:");
        this.nl();
        this.addFloat(left, "lostcity.highwayPerlinFactor").label("Perlin:");
        this.nl();
        this.addInt(left, "lostcity.highwayDistanceMask").label("Distance mask:");
        this.nl();
        this.addBool(left, "lostcity.railwaysEnabled").label("Railways:");
        this.nl();
    }

    private void initCities(int left) {
        this.start("Cities");
        this.addDouble(left, 120, "cities.cityChance").label("Rarity:");
        this.nl();
        this.perlinScaleElement = this.addDouble(left, 45, "cities.cityPerlinScale").label("Scale/Offset:");
        this.perlinOffsetElement = this.addDouble(left + 55, 45, "cities.cityPerlinOffset");
        this.nl();
        this.perlinInnerScaleElement = this.addDouble(left, 45, "cities.cityPerlinInnerScale").label("Inner scale");
        this.nl();
        this.addFloat(left, "cities.cityThreshold").label("Threshold:");
        this.nl();
        this.addInt(left, "cities.cityMinRadius").label("Radius:");
        this.addInt(left + 55, "cities.cityMaxRadius");
        this.nl();
        this.addFloat(left, "lostcity.parkChance").label("Parks:");
        this.nl();
        this.addFloat(left, "lostcity.fountainChance").label("Fountains:");
        this.nl();
    }

    private void toggleMode() {
        int idx = MODES.indexOf(this.mode);
        if (++idx >= MODES.size()) {
            idx = 0;
        }
        this.mode = MODES.get(idx);
        this.modeButton.m_93666_((Component)ComponentFactory.literal(this.mode));
    }

    private GuiElement add(GuiElement el) {
        this.elements.add(el);
        return el;
    }

    public <T extends AbstractWidget> T addWidget(T widget) {
        this.m_142416_((GuiEventListener)widget);
        return widget;
    }

    private void randomizePreview() {
        this.seed = this.random.nextLong();
        this.refreshPreview();
    }

    public void refreshPreview() {
        BuildingInfo.cleanCache();
        Highway.cleanCache();
        Railway.cleanCache();
        City.cleanCache();
        CitySphere.cleanCache();
    }

    private void renderExtra(GuiGraphics graphics) {
        graphics.m_280488_(this.f_96547_, "Profile:", 10, 16, -1);
        this.elements.forEach(el -> el.render(graphics));
        this.localSetup.get().ifPresent(profile -> {
            if ("Cities".equals(this.mode)) {
                this.renderPreviewMap(graphics, (LostCityProfile)profile, false);
            } else if ("Buildings".equals(this.mode)) {
                this.renderPreviewCity(graphics, (LostCityProfile)profile, false);
            } else if ("Damage".equals(this.mode)) {
                this.renderPreviewCity(graphics, (LostCityProfile)profile, true);
            } else if ("Transport".equals(this.mode)) {
                this.renderPreviewTransports(graphics, (LostCityProfile)profile);
            }
        });
    }

    private void renderPreviewTransports(GuiGraphics graphics, LostCityProfile profile) {
        this.renderPreviewMap(graphics, profile, true);
        NullDimensionInfo diminfo = new NullDimensionInfo(profile, this.seed);
        for (int z = 0; z < 58; ++z) {
            for (int x = 0; x < 62; ++x) {
                int sx = x * 3 + this.f_96543_ - 190;
                int sz = z * 3 + 32;
                int color = 0;
                Railway.RailChunkInfo type = Railway.getRailChunkType(x, z, diminfo, profile);
                if (type.getType() != RailChunkType.NONE) {
                    color = -1718017502;
                }
                int levelX = Highway.getXHighwayLevel(x, z, diminfo, profile);
                int levelZ = Highway.getZHighwayLevel(x, z, diminfo, profile);
                if (levelX >= 0 || levelZ >= 0) {
                    color = color == 0 ? -1711276033 : -1720223881;
                }
                if (color == 0) continue;
                graphics.m_280509_(sx, sz, sx + 3, sz + 3, color);
            }
        }
    }

    private void renderPreviewCity(GuiGraphics graphics, LostCityProfile profile, boolean showDamage) {
        int base = 170;
        int leftRender = this.f_96543_ - 157;
        graphics.m_280509_(leftRender, 50, leftRender + 150, base, -16737861);
        graphics.m_280509_(leftRender, base, leftRender + 150, 200, -6724045);
        float radius = 190.0f;
        int dimHor = 10;
        int dimVer = 4;
        Random rand = new Random(this.seed);
        for (int x = 0; x < 14; ++x) {
            int minfloors;
            float factor = 0.0f;
            float sqdist = (x * 16 - 112) * (x * 16 - 112);
            if (sqdist < radius * radius) {
                float dist = (float)Math.sqrt(sqdist);
                factor = (radius - dist) / radius;
            }
            if (!(factor > 0.0f) || x <= 0) continue;
            int maxfloors = profile.BUILDING_MAXFLOORS;
            int randdist = (int)((float)profile.BUILDING_MINFLOORS_CHANCE + (factor + 0.1f) * (float)(profile.BUILDING_MAXFLOORS_CHANCE - profile.BUILDING_MINFLOORS_CHANCE));
            if (randdist < 1) {
                randdist = 1;
            }
            int f = profile.BUILDING_MINFLOORS + rand.nextInt(randdist);
            if (++f > maxfloors + 1) {
                f = maxfloors + 1;
            }
            if (f < (minfloors = profile.BUILDING_MINFLOORS + 1)) {
                f = minfloors;
            }
            for (int i = 0; i < f; ++i) {
                graphics.m_280509_(leftRender + dimHor * x, base - i * dimVer - dimVer, leftRender + dimHor * x + dimHor - 1, base - i * dimVer + dimVer - 1 - dimVer, -1);
            }
            int maxcellars = profile.BUILDING_MAXCELLARS;
            int fb = profile.BUILDING_MINCELLARS + (maxcellars <= 0 ? 0 : rand.nextInt(maxcellars + 1));
            for (int i = 0; i < fb; ++i) {
                graphics.m_280509_(leftRender + dimHor * x, base + i * dimVer, leftRender + dimHor * x + dimHor - 1, base + i * dimVer + dimVer - 1, -13421773);
            }
        }
        if (showDamage) {
            double damage;
            double dist;
            int z;
            float horFactor = 1.0f * (float)dimHor / 16.0f;
            float verFactor = 1.0f * (float)dimVer / 6.0f;
            int cx = leftRender + 75;
            int cz = (int)((float)base - (float)(profile.EXPLOSION_MINHEIGHT - 65) * verFactor);
            Random rnd = new Random(333L);
            int explosionRadius = profile.EXPLOSION_MAXRADIUS;
            int x = (int)((float)cx - (float)explosionRadius * horFactor);
            while ((float)x <= (float)cx + (float)explosionRadius * horFactor) {
                z = (int)((float)cz - (float)explosionRadius * verFactor);
                while ((float)z <= (float)cz + (float)explosionRadius * verFactor) {
                    double sqdist = (float)((cx - x) * (cx - x)) / horFactor / horFactor + (float)((cz - z) * (cz - z)) / verFactor / verFactor;
                    dist = Math.sqrt(sqdist);
                    if (dist < (double)(explosionRadius - 3)) {
                        damage = 3.0 * ((double)explosionRadius - dist) / (double)explosionRadius;
                        if ((double)rnd.nextFloat() < damage) {
                            graphics.m_280509_(x, z, x + 1, z + 1, 0x66FF0000);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            cx = leftRender + 35;
            cz = (int)((float)base - (float)(profile.MINI_EXPLOSION_MINHEIGHT - 65) * verFactor);
            explosionRadius = profile.MINI_EXPLOSION_MAXRADIUS;
            x = (int)((float)cx - (float)explosionRadius * horFactor);
            while ((float)x <= (float)cx + (float)explosionRadius * horFactor) {
                z = (int)((float)cz - (float)explosionRadius * verFactor);
                while ((float)z <= (float)cz + (float)explosionRadius * verFactor) {
                    double sqdist = (float)((cx - x) * (cx - x)) / horFactor / horFactor + (float)((cz - z) * (cz - z)) / verFactor / verFactor;
                    dist = Math.sqrt(sqdist);
                    if (dist < (double)(explosionRadius - 3)) {
                        damage = 3.0 * ((double)explosionRadius - dist) / (double)explosionRadius;
                        if ((double)rnd.nextFloat() < damage) {
                            graphics.m_280509_(x, z, x + 1, z + 1, 0x66FF0000);
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
    }

    private static int soften(int color, boolean soft) {
        if (soft) {
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            return r / 3 << 16 | g / 3 << 8 | b / 3;
        }
        return color;
    }

    private void renderPreviewMap(GuiGraphics graphics, LostCityProfile profile, boolean soft) {
        NullDimensionInfo diminfo = new NullDimensionInfo(profile, this.seed);
        for (int z = 0; z < 58; ++z) {
            for (int x = 0; x < 62; ++x) {
                int sx = x * 3 + this.f_96543_ - 190;
                int sz = z * 3 + 32;
                char b = diminfo.getBiomeChar(x, z);
                int color = switch (b) {
                    case 'p' -> 21760;
                    case '-' -> 102;
                    case '=' -> 102;
                    case '#' -> 0x447744;
                    case '+' -> 0x335533;
                    case '*' -> 0xCCCC55;
                    case 'd' -> 0xCCCC55;
                    default -> 21760;
                };
                graphics.m_280509_(sx, sz, sx + 3, sz + 3, -16777216 + GuiLCConfig.soften(color, soft));
                LostChunkCharacteristics characteristics = BuildingInfo.getChunkCharacteristicsGui(x, z, diminfo);
                if (!characteristics.isCity) continue;
                color = 0x995555;
                if (BuildingInfo.hasBuildingGui(x, z, diminfo, characteristics)) {
                    color = 0xFFFFFF;
                }
                graphics.m_280509_(sx, sz, sx + 2, sz + 2, -16777216 + GuiLCConfig.soften(color, soft));
            }
        }
    }

    private void updateValues() {
        this.elements.forEach(GuiElement::update);
        this.refreshPreview();
    }

    private void refreshButtons() {
        boolean isCustomized;
        this.profileButton.m_93666_((Component)ComponentFactory.literal(this.localSetup.getProfileLabel()));
        this.worldstyleButton.m_93666_((Component)ComponentFactory.literal(this.localSetup.getWorldStyleLabel()));
        this.customizeButton.f_93623_ = this.localSetup.isCustomizable();
        this.worldstyleButton.f_93623_ = isCustomized = "customized".equals(this.localSetup.getProfileLabel());
        this.modeButton.f_93623_ = this.localSetup.isCustomizable() || isCustomized;
        this.elements.forEach(s -> {
            s.setEnabled(isCustomized);
            s.setBasedOnMode(this.mode);
        });
        this.localSetup.get().ifPresent(profile -> {
            boolean perlin = profile.CITY_CHANCE < 0.0;
            this.perlinScaleElement.setEnabled(perlin && isCustomized);
            this.perlinOffsetElement.setEnabled(perlin && isCustomized);
            this.perlinInnerScaleElement.setEnabled(perlin && isCustomized);
        });
    }

    private void cancel() {
        this.refreshPreview();
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private void done() {
        this.refreshPreview();
        LostCitySetup.CLIENT_SETUP.copyFrom(this.localSetup);
        LostCityProfile customizedProfile = this.localSetup.getCustomizedProfile();
        if ("customized".equals(this.localSetup.getProfile()) && customizedProfile != null) {
            ProfileSetup.STANDARD_PROFILES.get("customized").copyFrom(customizedProfile);
            GuiLCConfig.selectProfile(this.localSetup.getProfile(), customizedProfile);
        } else {
            GuiLCConfig.selectProfile(this.localSetup.getProfile(), null);
        }
        Minecraft.m_91087_().m_91152_(this.parent);
        ++LostCityFeature.globalDimensionInfoDirtyCounter;
        Config.resetProfileCache();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        AbstractWidget widget;
        GuiEventListener listener;
        this.m_280273_(graphics);
        this.refreshButtons();
        this.renderExtra(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        Iterator iterator = this.m_6702_().iterator();
        while (!(!iterator.hasNext() || (listener = (GuiEventListener)iterator.next()) instanceof AbstractWidget && (widget = (AbstractWidget)listener).m_5953_((double)mouseX, (double)mouseY) && widget.f_93624_)) {
        }
    }
}

