/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui;

import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import mcjty.lostcities.worldgen.lost.regassets.WorldStyleRE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.LegacyRandomSource;

public class NullDimensionInfo
implements IDimensionInfo {
    public static final int PREVIEW_WIDTH = 62;
    public static final int PREVIEW_HEIGHT = 58;
    private final String[] biomeMap = new String[]{"ddddddddddddddddddddddppppppppppppppp==ppppppppppppppppppppppp", "ddddddddddddddddddddpppppppppppppppp==pppppppppppppppppppppppp", "ddddddddddddddddddddpppppppppppppp===ppppppppppppppppppppppppp", "pddddddddddddddddpppppppppppppppppp==ppppppppppppppppppppppppp", "pppdddddddppppppppppppppppppppppppp==ppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppp==pppppppppp----------pppp", "ppppppppppppppppppppppppppppppppppppp==ppppppp--------------pp", "pppppppppppppppppppppppppppppppppppppp==ppppp-----------------", "pppppppppppppppppppppppppppppppppppppp===pppp-----------------", "ppppppppppppppppppppppppppppppppppppppp===ppppp---------------", "pppppppppppppppppppppppppppppppppppppppp==--pp----------------", "pppppppppppppppppppppppppppppppppppppppp*---------------------", "pppppppppppppppppppppppppppppppppppppp****--------------------", "ppppppppppppppppppppppppppppppppppppp***----------------------", "pppppppppppppppppppppppppppppppppppp**------------------------", "ppppppppppppppppppppppppppppppppppppp**-----------------------", "ppppppppppppppppppppppppppppppppppppppp*----------------------", "pppppppppppppppppppppppppppppppppppppp**----------------------", "ppppp###pppppppppppppppppppppppppppppp**----------------------", "ppppp####ppppppp#####pppppppppppppppppp*----------------------", "pppppp#####pp##+++#####ppppppppppppp*****---------------------", "pppppppp#####++++####pppppppppppppp**------pp----p------------", "ppppppppp##++++++###pppppppppppppppp***---pppp--ppp-----------", "ppppppppp###+++++++#####ppppppppppppp---pppppppppppp---------p", "pppppppp##p##+++++++###ppppppppppppppppppppppppppppp---------p", "pppppppppp#####++++####ppppppppppppppppppppppppppppppppp----pp", "pppppppppppp###+++++###ppppppppppppppppppppppppppppppppppppppp", "ppppppppppppp####++++####ppppppppppppppppppppppppppppppppppppp", "pppppppppppppp####++######pppppppppppppppppppppppppppppppppppp", "ppppppppppppppp#+++####ppppppppppppppppppppppppppppppppppppppp", "ppppppppppppp####pp#####pppppppppppppppppppppppppppppppppppppp", "pppppppppp#####ppppppppppppppppppppppppppppppppppppppppppppppp", "ppppppppppp###pppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp", "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp"};
    private final LostCityProfile profile;
    private final WorldStyle style;
    private final Random random;
    private final long seed;
    private final Registry<Biome> biomeRegistry;
    private final LostCityTerrainFeature feature;

    public NullDimensionInfo(LostCityProfile profile, long seed) {
        this.profile = profile;
        this.style = new WorldStyle(new WorldStyleRE("standard", Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList(), Optional.empty(), Optional.empty()));
        this.seed = seed;
        this.random = new Random(seed);
        LegacyRandomSource randomSource = new LegacyRandomSource(seed);
        this.feature = new LostCityTerrainFeature(this, profile, (RandomSource)randomSource);
        this.feature.setupStates(profile);
        this.biomeRegistry = null;
    }

    @Override
    public void setWorld(WorldGenLevel world) {
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public WorldGenLevel getWorld() {
        return null;
    }

    @Override
    public ResourceKey<Level> getType() {
        return Level.f_46428_;
    }

    @Override
    public LostCityProfile getProfile() {
        return this.profile;
    }

    @Override
    public LostCityProfile getOutsideProfile() {
        return this.profile;
    }

    @Override
    public WorldStyle getWorldStyle() {
        return this.style;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public LostCityTerrainFeature getFeature() {
        return this.feature;
    }

    @Override
    public ChunkHeightmap getHeightmap(int chunkX, int chunkZ) {
        ChunkHeightmap heightmap = new ChunkHeightmap(this.profile.LANDSCAPE_TYPE, this.profile.GROUNDLEVEL);
        char b = this.getBiomeChar(chunkX, chunkZ);
        int y = switch (b) {
            case 'p' -> 65;
            case '-' -> 60;
            case '=' -> 65;
            case '#' -> 95;
            case '+' -> 125;
            case '*' -> 65;
            case 'd' -> 65;
            default -> 65;
        };
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                heightmap.update(x, y, z);
            }
        }
        return heightmap;
    }

    public char getBiomeChar(int chunkX, int chunkZ) {
        if (chunkX >= 0 && chunkX < 62 && chunkZ >= 0 && chunkZ < 58) {
            return this.biomeMap[chunkZ].charAt(chunkX);
        }
        return 'p';
    }

    @Override
    public Holder<Biome> getBiome(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        char b = this.getBiomeChar(cp.f_45578_, cp.f_45579_);
        ResourceKey biome = switch (b) {
            case 'p' -> Biomes.f_48202_;
            case '-' -> Biomes.f_48174_;
            case '=' -> Biomes.f_48208_;
            case '#' -> Biomes.f_186759_;
            case '+' -> Biomes.f_186758_;
            case '*' -> Biomes.f_48217_;
            case 'd' -> Biomes.f_48203_;
            default -> Biomes.f_48202_;
        };
        return this.biomeRegistry.m_246971_(biome);
    }

    @Override
    public ResourceKey<Level> dimension() {
        return null;
    }
}

