/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.commands.ModCommands;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.playerdata.PlayerProperties;
import mcjty.lostcities.playerdata.PlayerSpawnSet;
import mcjty.lostcities.playerdata.PropertiesDispatcher;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.ModSetup;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.varia.CustomTeleporter;
import mcjty.lostcities.varia.WorldTools;
import mcjty.lostcities.worldgen.GlobalTodo;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.City;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Railway;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedCity;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedSphere;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeEventHandlers {
    private final Map<ResourceKey<Level>, BlockPos> spawnPositions = new HashMap<ResourceKey<Level>, BlockPos>();

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerProperties.PLAYER_SPAWN_SET).isPresent()) {
            event.addCapability(new ResourceLocation("lostcities", "spawnset"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerProperties.PLAYER_SPAWN_SET).ifPresent(oldStore -> event.getEntity().getCapability(PlayerProperties.PLAYER_SPAWN_SET).ifPresent(newStore -> newStore.copyFrom((PlayerSpawnSet)oldStore)));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getEntity().getCapability(PlayerProperties.PLAYER_SPAWN_SET).ifPresent(note -> {
            if (!note.isPlayerSpawnSet()) {
                note.setPlayerSpawnSet(true);
                for (Map.Entry<ResourceKey<Level>, BlockPos> entry : this.spawnPositions.entrySet()) {
                    Player patt3848$temp = event.getEntity();
                    if (!(patt3848$temp instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)patt3848$temp;
                    serverPlayer.m_9158_(entry.getKey(), entry.getValue(), 0.0f, true, true);
                    serverPlayer.m_6021_((double)entry.getValue().m_123341_(), (double)entry.getValue().m_123342_(), (double)entry.getValue().m_123343_());
                }
            }
        });
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GlobalTodo.getData((Level)serverLevel).executeAndClearTodo(serverLevel);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        BuildingInfo.cleanCache();
        Highway.cleanCache();
        Railway.cleanCache();
        BiomeInfo.cleanCache();
        City.cleanCache();
        CitySphere.cleanCache();
    }

    @SubscribeEvent
    public void onCreateSpawnPoint(LevelEvent.CreateSpawnPosition event) {
        LevelAccessor world = event.getLevel();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            IDimensionInfo dimensionInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)serverLevel);
            if (dimensionInfo == null) {
                return;
            }
            LostCityProfile profile = dimensionInfo.getProfile();
            Predicate<BlockPos> isSuitable = pos -> true;
            boolean needsCheck = false;
            if (!profile.SPAWN_BIOME.isEmpty()) {
                Biome spawnBiome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(profile.SPAWN_BIOME));
                if (spawnBiome == null) {
                    ModSetup.getLogger().error("Cannot find biome '{}' for the player to spawn in !", (Object)profile.SPAWN_BIOME);
                } else {
                    isSuitable = blockPos -> world.m_204166_(blockPos).m_203334_() == spawnBiome;
                    needsCheck = true;
                }
            } else if (!profile.SPAWN_CITY.isEmpty()) {
                PredefinedCity city = AssetRegistries.PREDEFINED_CITIES.get((CommonLevelAccessor)world, profile.SPAWN_CITY);
                if (city == null) {
                    ModSetup.getLogger().error("Cannot find city '{}' for the player to spawn in !", (Object)profile.SPAWN_CITY);
                } else {
                    float sqradius = this.getSqRadius(city.getRadius(), 0.8f);
                    isSuitable = blockPos -> city.getDimension() == serverLevel.m_46472_() && CitySphere.squaredDistance(city.getChunkX() * 16 + 8, city.getChunkZ() * 16 + 8, blockPos.m_123341_(), blockPos.m_123343_()) < (double)sqradius;
                    needsCheck = true;
                }
            } else if (!profile.SPAWN_SPHERE.isEmpty()) {
                if ("<in>".equals(profile.SPAWN_SPHERE)) {
                    isSuitable = blockPos -> {
                        CitySphere sphere = CitySphere.getCitySphere(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4, dimensionInfo);
                        if (!sphere.isEnabled()) {
                            return false;
                        }
                        float sqradius = this.getSqRadius((int)sphere.getRadius(), 0.8f);
                        return sphere.getCenterPos().m_123331_((Vec3i)blockPos.m_175288_(sphere.getCenterPos().m_123342_())) < (double)sqradius;
                    };
                    needsCheck = true;
                } else if ("<out>".equals(profile.SPAWN_SPHERE)) {
                    isSuitable = blockPos -> {
                        CitySphere sphere = CitySphere.getCitySphere(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4, dimensionInfo);
                        if (!sphere.isEnabled()) {
                            return true;
                        }
                        float sqradius = sphere.getRadius() * sphere.getRadius();
                        return sphere.getCenterPos().m_123331_((Vec3i)blockPos.m_175288_(sphere.getCenterPos().m_123342_())) > (double)sqradius;
                    };
                    needsCheck = true;
                } else {
                    PredefinedSphere sphere = AssetRegistries.PREDEFINED_SPHERES.get((CommonLevelAccessor)world, profile.SPAWN_SPHERE);
                    if (sphere == null) {
                        LostCities.setup.getLogger().error("Cannot find sphere '" + profile.SPAWN_SPHERE + "' for the player to spawn in !");
                    } else {
                        float sqradius = this.getSqRadius(sphere.getRadius(), 0.8f);
                        isSuitable = blockPos -> sphere.getDimension() == serverLevel.m_46472_() && CitySphere.squaredDistance(sphere.getChunkX() * 16 + 8, sphere.getChunkZ() * 16 + 8, blockPos.m_123341_(), blockPos.m_123343_()) < (double)sqradius;
                        needsCheck = true;
                    }
                }
            }
            if (profile.SPAWN_NOT_IN_BUILDING) {
                isSuitable = isSuitable.and(blockPos -> this.isOutsideBuilding(dimensionInfo, (BlockPos)blockPos));
                needsCheck = true;
            } else if (profile.FORCE_SPAWN_IN_BUILDING) {
                isSuitable = isSuitable.and(blockPos -> !this.isOutsideBuilding(dimensionInfo, (BlockPos)blockPos));
                needsCheck = true;
            }
            switch (profile.LANDSCAPE_TYPE) {
                case DEFAULT: 
                case SPHERES: 
                case CAVERN: {
                    if (!needsCheck) break;
                    BlockPos pos2 = this.findSafeSpawnPoint((Level)serverLevel, dimensionInfo, isSuitable, event.getSettings());
                    event.getSettings().m_7250_(pos2, 0.0f);
                    this.spawnPositions.put((ResourceKey<Level>)serverLevel.m_46472_(), pos2);
                    event.setCanceled(true);
                    break;
                }
                case FLOATING: 
                case SPACE: {
                    BlockPos pos2 = this.findSafeSpawnPoint((Level)serverLevel, dimensionInfo, isSuitable, event.getSettings());
                    event.getSettings().m_7250_(pos2, 0.0f);
                    this.spawnPositions.put((ResourceKey<Level>)serverLevel.m_46472_(), pos2);
                    event.setCanceled(true);
                }
            }
        }
    }

    private boolean isOutsideBuilding(IDimensionInfo provider, BlockPos pos) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(pos.m_123341_() >> 4, pos.m_123343_() >> 4, provider);
        return !info.isCity() || !info.hasBuilding;
    }

    private int getSqRadius(int radius, float pct) {
        return (int)((float)radius * pct * ((float)radius * pct));
    }

    private BlockPos findSafeSpawnPoint(Level world, IDimensionInfo provider, @Nonnull Predicate<BlockPos> isSuitable, @Nonnull ServerLevelData serverLevelData) {
        Random rand = new Random(provider.getSeed());
        rand.nextFloat();
        rand.nextFloat();
        int radius = 200;
        int attempts = 0;
        do {
            for (int i = 0; i < 200; ++i) {
                int x = rand.nextInt(radius * 2) - radius;
                int z = rand.nextInt(radius * 2) - radius;
                ++attempts;
                if (!isSuitable.test(new BlockPos(x, 128, z))) continue;
                LostCityProfile profile = BuildingInfo.getProfile(x >> 4, z >> 4, provider);
                for (int y = profile.GROUNDLEVEL - 5; y < 125; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.isValidStandingPosition(world, pos)) continue;
                    return pos.m_7494_();
                }
            }
            radius += 100;
        } while (attempts <= 20000);
        LostCities.setup.getLogger().error("Can't find a valid spawn position!");
        throw new RuntimeException("Can't find a valid spawn position!");
    }

    private boolean isValidStandingPosition(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60815_();
    }

    private boolean isValidSpawnBed(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof BedBlock)) {
            return false;
        }
        Direction direction = Blocks.f_50029_.getBedDirection(state, (LevelReader)world, pos);
        Block b1 = world.m_8055_(pos.m_7495_()).m_60734_();
        Block b2 = world.m_8055_(pos.m_121945_(direction.m_122424_()).m_7495_()).m_60734_();
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)Config.SPECIAL_BED_BLOCK.get()));
        if (b1 != b || b2 != b) {
            return false;
        }
        if (!(world.m_8055_(pos.m_121945_(direction)).m_60734_() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.m_8055_(pos.m_121945_(direction.m_122427_())).m_60734_() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.m_8055_(pos.m_121945_(direction.m_122428_())).m_60734_() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.m_8055_(pos.m_5484_(direction.m_122424_(), 2)).m_60734_() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.m_8055_(pos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122424_().m_122427_())).m_60734_() instanceof AbstractSkullBlock)) {
            return false;
        }
        return world.m_8055_(pos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122424_().m_122428_())).m_60734_() instanceof AbstractSkullBlock;
    }

    private BlockPos findValidTeleportLocation(Level world, BlockPos start) {
        int y;
        int chunkZ;
        int chunkX = start.m_123341_() >> 4;
        BlockPos pos = this.findValidTeleportLocation(world, chunkX, chunkZ = start.m_123343_() >> 4, y = start.m_123342_());
        if (pos != null) {
            return pos;
        }
        for (int r = 1; r < 50; ++r) {
            for (int i = -r; i < r; ++i) {
                pos = this.findValidTeleportLocation(world, chunkX + i, chunkZ - r, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX + r, chunkZ + i, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX + r - i, chunkZ + r, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX - r, chunkZ + r - i, y);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    private BlockPos findValidTeleportLocation(Level world, int chunkX, int chunkZ, int y) {
        BlockPos bestSpot = null;
        for (int dy = 0; dy < 255; ++dy) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos p;
                    if (y + dy < 250) {
                        p = new BlockPos(chunkX * 16 + x, y + dy, chunkZ * 16 + z);
                        if (this.isValidSpawnBed(world, p)) {
                            return p.m_7494_();
                        }
                        if (bestSpot == null && this.isValidStandingPosition(world, p)) {
                            bestSpot = p.m_7494_();
                        }
                    }
                    if (y - dy <= 1) continue;
                    p = new BlockPos(chunkX * 16 + x, y - dy, chunkZ * 16 + z);
                    if (this.isValidSpawnBed(world, p)) {
                        return p.m_7494_();
                    }
                    if (bestSpot != null || !this.isValidStandingPosition(world, p)) continue;
                    bestSpot = p.m_7494_();
                }
            }
        }
        return bestSpot;
    }

    @SubscribeEvent
    public void onPlayerSleepInBedEvent(PlayerSleepInBedEvent event) {
        Level world = event.getEntity().m_20193_();
        if (world.f_46443_) {
            return;
        }
        BlockPos bedLocation = event.getPos();
        if (bedLocation == null || !this.isValidSpawnBed(world, bedLocation)) {
            return;
        }
        if (world.m_46472_() == Registration.DIMENSION) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            ServerLevel destWorld = WorldTools.getOverworld(world);
            BlockPos location = this.findLocation(bedLocation, destWorld);
            CustomTeleporter.teleportToDimension(event.getEntity(), destWorld, location);
        } else {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            ServerLevel destWorld = event.getEntity().m_20193_().m_7654_().m_129880_(Registration.DIMENSION);
            if (destWorld == null) {
                event.getEntity().m_213846_((Component)ComponentFactory.literal("Error finding Lost City dimension: " + Registration.LOSTCITY + "!").m_130940_(ChatFormatting.RED));
            } else {
                BlockPos location = this.findLocation(bedLocation, destWorld);
                CustomTeleporter.teleportToDimension(event.getEntity(), destWorld, location);
            }
        }
    }

    private BlockPos findLocation(BlockPos bedLocation, ServerLevel destWorld) {
        BlockPos top;
        BlockPos location = top = bedLocation.m_6630_(5);
        while (top.m_123342_() > 1 && destWorld.m_8055_(location).m_60795_()) {
            location = location.m_7495_();
        }
        if (destWorld.m_46859_(location.m_7495_())) {
            destWorld.m_46597_(bedLocation, Blocks.f_50652_.m_49966_());
        }
        return location.m_6630_(1);
    }
}

