/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import mcjty.lostcities.config.LandscapeType;

public class ChunkHeightmap {
    private final short[] heightmap = new short[256];
    private final LandscapeType type;
    private final int groundLevel;
    private Integer maxHeight = null;
    private Integer minHeight = null;
    private Integer avgHeight = null;

    public ChunkHeightmap(LandscapeType type, int groundLevel) {
        this.groundLevel = groundLevel;
        this.type = type;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.heightmap[z * 16 + x] = Short.MIN_VALUE;
            }
        }
    }

    public void update(int x, int y, int z) {
        short current = this.heightmap[z * 16 + x];
        if (y <= current) {
            return;
        }
        if (this.type == LandscapeType.CAVERN) {
            int base = Math.max(this.groundLevel - 20, 1);
            if (y > 100 || y < base) {
                return;
            }
            if (y == 100) {
                this.heightmap[z * 16 + x] = 127;
                return;
            }
            this.heightmap[z * 16 + x] = (short)y;
        } else {
            this.heightmap[z * 16 + x] = this.type == LandscapeType.SPACE ? (short)y : (short)y;
        }
    }

    public int getHeight(int x, int z) {
        return this.heightmap[z * 16 + x];
    }

    public void setHeight(int x, int z, int height) {
        this.heightmap[z * 16 + x] = (short)height;
    }

    private void calculateHeightInfo() {
        int max = Short.MIN_VALUE;
        int min = Short.MAX_VALUE;
        int avg = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int h = this.getHeight(x, z);
                if (h > max) {
                    max = h;
                }
                if (h < min) {
                    min = h;
                }
                avg += h;
            }
        }
        this.avgHeight = avg / 256;
        this.minHeight = min;
        this.maxHeight = max;
    }

    public int getAverageHeight() {
        if (this.avgHeight == null) {
            this.calculateHeightInfo();
        }
        return this.avgHeight;
    }

    public int getMinimumHeight() {
        if (this.minHeight == null) {
            this.calculateHeightInfo();
        }
        return this.minHeight;
    }

    public int getMaximumHeight() {
        if (this.maxHeight == null) {
            this.calculateHeightInfo();
        }
        return this.maxHeight;
    }
}

