/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostSphere;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.City;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedCity;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedSphere;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CitySphere
implements ILostSphere {
    private static final Map<ChunkCoord, CitySphere> CITY_SPHERE_CACHE = new HashMap<ChunkCoord, CitySphere>();
    public static final CitySphere EMPTY = new CitySphere(new ChunkCoord((ResourceKey<Level>)Level.f_46428_, 0, 0), 0.0f, new BlockPos(0, 0, 0), false);
    private final ChunkCoord center;
    private final BlockPos centerPos;
    private final float radius;
    private final boolean enabled;
    private boolean monorailNorthCandidate;
    private boolean monorailSouthCandidate;
    private boolean monorailWestCandidate;
    private boolean monorailEastCandidate;
    private BlockState glassBlock = Blocks.f_50016_.m_49966_();
    private BlockState baseBlock = Blocks.f_50016_.m_49966_();
    private BlockState sideBlock = Blocks.f_50016_.m_49966_();

    private CitySphere(ChunkCoord center, float radius, BlockPos centerPos, boolean enabled) {
        this.enabled = enabled;
        this.center = center;
        this.radius = radius;
        this.centerPos = centerPos;
    }

    public static void initSphere(CitySphere sphere, IDimensionInfo provider) {
        if (sphere.getBaseBlock() != Blocks.f_50016_.m_49966_()) {
            return;
        }
        ChunkCoord center = sphere.getCenter();
        BuildingInfo info = BuildingInfo.getBuildingInfo(center.chunkX(), center.chunkZ(), provider);
        CityStyle cs = info.getCityStyle();
        Random rand = new Random(info.provider.getSeed() + (long)center.chunkX() * 837971201L + (long)center.chunkZ() * 961744153L);
        rand.nextFloat();
        rand.nextFloat();
        BlockState glass = info.getCompiledPalette().get(cs.getSphereGlassBlock().charValue(), rand);
        BlockState base = info.getCompiledPalette().get(cs.getSphereBlock().charValue(), rand);
        BlockState side = info.getCompiledPalette().get(cs.getSphereSideBlock().charValue(), rand);
        sphere.setBlocks(glass, base, side);
    }

    public static boolean isInSphere(int chunkX, int chunkZ, BlockPos pos, IDimensionInfo provider) {
        double sqdist;
        CitySphere citySphere;
        boolean sphere = false;
        if ((provider.getProfile().isSpace() || provider.getProfile().isSpheres()) && (citySphere = CitySphere.getCitySphere(chunkX, chunkZ, provider)).isEnabled() && (sqdist = CitySphere.squaredDistance(citySphere.getCenterPos().m_123341_(), citySphere.getCenterPos().m_123343_(), pos.m_123341_(), pos.m_123343_())) <= (double)(citySphere.getRadius() * citySphere.getRadius())) {
            sphere = true;
        }
        return sphere;
    }

    public static float getRelativeDistanceToCityCenter(int chunkX, int chunkZ, IDimensionInfo provider) {
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        BlockPos centerPos = sphere.getCenterPos();
        float radius = sphere.getRadius();
        int cx = chunkX * 16 + 8;
        int cz = chunkZ * 16 + 8;
        int sqdist = (cx - centerPos.m_123341_()) * (cx - centerPos.m_123341_()) + (cz - centerPos.m_123343_()) * (cz - centerPos.m_123343_());
        return (float)(Math.sqrt(sqdist) / (double)radius);
    }

    private static boolean hasNonStationMonoRail(int chunkX, int chunkZ, IDimensionInfo provider) {
        if (!CitySphere.fullyInsideCitySpere(chunkX, chunkZ, provider)) {
            return CitySphere.hasHorizontalMonorail(chunkX, chunkZ, provider) || CitySphere.hasVerticalMonorail(chunkX, chunkZ, provider);
        }
        return false;
    }

    public static boolean hasMonorailStation(int chunkX, int chunkZ, IDimensionInfo provider) {
        if (CitySphere.fullyInsideCitySpere(chunkX, chunkZ, provider)) {
            return CitySphere.hasNonStationMonoRail(chunkX - 1, chunkZ, provider) || CitySphere.hasNonStationMonoRail(chunkX + 1, chunkZ, provider) || CitySphere.hasNonStationMonoRail(chunkX, chunkZ - 1, provider) || CitySphere.hasNonStationMonoRail(chunkX, chunkZ + 1, provider);
        }
        return false;
    }

    @Override
    public ChunkCoord getCenter() {
        return this.center;
    }

    @Override
    public BlockPos getCenterPos() {
        return this.centerPos;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    public void setBlocks(BlockState glassBlock, BlockState baseBlock, BlockState sideBlock) {
        this.glassBlock = glassBlock;
        this.baseBlock = baseBlock;
        this.sideBlock = sideBlock;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public BlockState getGlassBlock() {
        return this.glassBlock;
    }

    public BlockState getBaseBlock() {
        return this.baseBlock;
    }

    public BlockState getSideBlock() {
        return this.sideBlock;
    }

    public static void cleanCache() {
        CITY_SPHERE_CACHE.clear();
    }

    public static boolean hasHorizontalMonorail(int chunkX, int chunkZ, IDimensionInfo provider) {
        if ((chunkZ & 0xF) == 8) {
            CitySphere sphere;
            int cx;
            boolean result = false;
            for (cx = chunkX + 1; cx < chunkX + 64; ++cx) {
                if ((cx & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(cx, chunkZ, provider)).isEnabled()) continue;
                if (!sphere.monorailWestCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
            result = false;
            for (cx = chunkX - 1; cx > chunkX - 64; --cx) {
                if ((cx & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(cx, chunkZ, provider)).isEnabled()) continue;
                if (!sphere.monorailEastCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            return result;
        }
        return false;
    }

    public static boolean hasVerticalMonorail(int chunkX, int chunkZ, IDimensionInfo provider) {
        if ((chunkX & 0xF) == 8) {
            CitySphere sphere;
            int cz;
            boolean result = false;
            for (cz = chunkZ + 1; cz < chunkZ + 64; ++cz) {
                if ((cz & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(chunkX, cz, provider)).isEnabled()) continue;
                if (!sphere.monorailNorthCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
            result = false;
            for (cz = chunkZ - 1; cz > chunkZ - 64; --cz) {
                if ((cz & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(chunkX, cz, provider)).isEnabled()) continue;
                if (!sphere.monorailSouthCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            return result;
        }
        return false;
    }

    private static float getSphereRadius(ChunkCoord center, IDimensionInfo provider, Random rand) {
        PredefinedCity city = City.getPredefinedCity(center.chunkX(), center.chunkZ(), provider.getType());
        LostCityProfile profile = provider.getProfile();
        if (city != null) {
            return (float)city.getRadius() * profile.CITYSPHERE_FACTOR;
        }
        return (float)profile.CITY_MINRADIUS + (float)rand.nextInt(profile.CITY_MAXRADIUS - profile.CITY_MINRADIUS) * profile.CITYSPHERE_FACTOR;
    }

    public static boolean fullyInsideCitySpere(int chunkX, int chunkZ, IDimensionInfo provider) {
        int cz;
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        double sqradiusOffset = (radius - 2.0f) * (radius - 2.0f);
        int cx = cc.m_123341_();
        if (CitySphere.squaredDistance(cx, cz = cc.m_123343_(), chunkX * 16, chunkZ * 16) > sqradiusOffset) {
            return false;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) > sqradiusOffset) {
            return false;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) > sqradiusOffset) {
            return false;
        }
        return !(CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) > sqradiusOffset);
    }

    public static boolean intersectsWithCitySphere(int chunkX, int chunkZ, IDimensionInfo provider) {
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        return CitySphere.intersectChunkWithSphere(chunkX, chunkZ, radius, cc);
    }

    private static boolean intersectChunkWithSphere(int chunkX, int chunkZ, float radius, BlockPos cc) {
        int cz;
        double sqradiusOffset = radius * radius;
        int cx = cc.m_123341_();
        if (CitySphere.squaredDistance(cx, cz = cc.m_123343_(), chunkX * 16, chunkZ * 16) <= sqradiusOffset) {
            return true;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) <= sqradiusOffset) {
            return true;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) <= sqradiusOffset) {
            return true;
        }
        return CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) <= sqradiusOffset;
    }

    public static boolean onCitySphereBorder(int chunkX, int chunkZ, IDimensionInfo provider) {
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        double sqradiusOffset = radius * radius;
        int cx = cc.m_123341_();
        int cz = cc.m_123343_();
        int cnt = 0;
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) <= sqradiusOffset) {
            ++cnt;
        }
        return cnt > 0 && cnt < 4;
    }

    public static double squaredDistance(int cx, int cz, int x, int z) {
        return (cx - x) * (cx - x) + (cz - z) * (cz - z);
    }

    private static CitySphere getSphereAtCenter(ChunkCoord center, IDimensionInfo provider, @Nullable PredefinedSphere predef) {
        int chunkX = center.chunkX();
        int chunkZ = center.chunkZ();
        Random rand = new Random(provider.getSeed() + (long)chunkX * 961744153L + (long)chunkZ * 837971201L);
        rand.nextFloat();
        rand.nextFloat();
        LostCityProfile profile = provider.getProfile();
        boolean enabled = predef != null || rand.nextFloat() < profile.CITYSPHERE_CHANCE;
        float radius = predef != null ? (float)predef.getRadius() : CitySphere.getSphereRadius(center, provider, rand);
        BlockPos centerPosition = predef != null ? new BlockPos(predef.getCenterX(), profile.GROUNDLEVEL, predef.getCenterZ()) : CitySphere.getSphereCenterPosition(center, provider, rand);
        CitySphere citySphere = new CitySphere(center, radius, centerPosition, enabled);
        if (enabled) {
            citySphere.monorailNorthCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
            citySphere.monorailSouthCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
            citySphere.monorailWestCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
            citySphere.monorailEastCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
        }
        return citySphere;
    }

    public static boolean isCitySphereCenter(int chunkX, int chunkZ, IDimensionInfo provider) {
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        return sphere.isEnabled() && sphere.getCenter().chunkX() == chunkX && sphere.getCenter().chunkZ() == chunkZ;
    }

    @Nonnull
    public static CitySphere getCitySphere(int chunkX, int chunkZ, IDimensionInfo provider) {
        ChunkCoord coord = new ChunkCoord(provider.getType(), chunkX, chunkZ);
        if (!CITY_SPHERE_CACHE.containsKey(coord)) {
            CitySphere sphere;
            for (PredefinedSphere predef : AssetRegistries.PREDEFINED_SPHERES.getIterable()) {
                if (predef.getDimension() != provider.getType() || !CitySphere.intersectChunkWithSphere(chunkX, chunkZ, predef.getRadius(), new BlockPos(predef.getCenterX(), 0, predef.getCenterZ()))) continue;
                ChunkCoord center = new ChunkCoord(provider.getType(), predef.getChunkX(), predef.getChunkZ());
                CitySphere sphere2 = CitySphere.getSphereAtCenter(center, provider, predef);
                CitySphere.updateCache(coord, sphere2);
                return sphere2;
            }
            if (provider.getProfile().CITYSPHERE_ONLY_PREDEFINED) {
                sphere = EMPTY;
            } else {
                int cx = (chunkX & 0xFFFFFFF0) + 8;
                int cz = (chunkZ & 0xFFFFFFF0) + 8;
                ChunkCoord center = new ChunkCoord(provider.getType(), cx, cz);
                sphere = CitySphere.getSphereAtCenter(center, provider, null);
            }
            CitySphere.updateCache(coord, sphere);
            return sphere;
        }
        return CITY_SPHERE_CACHE.get(coord);
    }

    private static void updateCache(ChunkCoord coord, CitySphere sphere) {
        CITY_SPHERE_CACHE.put(coord, sphere);
        BlockPos centerPos = sphere.getCenterPos();
        int radius = (int)sphere.getRadius();
        if ((float)radius < 1.0E-4f) {
            CITY_SPHERE_CACHE.put(sphere.center, sphere);
            return;
        }
        for (int cx = centerPos.m_123341_() - radius - 16; cx <= centerPos.m_123341_() + radius + 16; cx += 16) {
            for (int cz = centerPos.m_123343_() - radius - 16; cz <= centerPos.m_123343_() + radius + 16; cz += 16) {
                ChunkCoord cc = new ChunkCoord(sphere.getCenter().dimension(), cx >> 4, cz >> 4);
                if (!CitySphere.intersectChunkWithSphere(cc.chunkX(), cc.chunkZ(), radius, centerPos)) continue;
                CITY_SPHERE_CACHE.put(cc, sphere);
            }
        }
    }

    private static BlockPos getSphereCenterPosition(ChunkCoord center, IDimensionInfo provider, Random rand) {
        int cx = center.chunkX() * 16 + rand.nextInt(16) - 8;
        int cz = center.chunkZ() * 16 + rand.nextInt(16) - 8;
        return new BlockPos(cx, provider.getProfile().GROUNDLEVEL, cz);
    }
}

