/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mcjty.lostcities.worldgen.lost.regassets.data.BiomeMatcher;
import org.jetbrains.annotations.Nullable;

public class ScatteredReference {
    public static final Codec<ScatteredReference> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(l -> l.name), (App)Codec.INT.fieldOf("weight").forGetter(l -> l.weight), (App)BiomeMatcher.CODEC.optionalFieldOf("biomes").forGetter(l -> Optional.ofNullable(l.biomeMatcher)), (App)Codec.INT.optionalFieldOf("maxheightdiff").forGetter(l -> Optional.ofNullable(l.maxheightdiff))).apply((Applicative)instance, ScatteredReference::new));
    private final String name;
    private final int weight;
    private final BiomeMatcher biomeMatcher;
    private final Integer maxheightdiff;

    public ScatteredReference(String name, int weight, Optional<BiomeMatcher> biomeMatcher, Optional<Integer> maxheightdiff) {
        this.name = name;
        this.weight = weight;
        this.biomeMatcher = biomeMatcher.orElse(null);
        this.maxheightdiff = maxheightdiff.orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public BiomeMatcher getBiomeMatcher() {
        return this.biomeMatcher;
    }

    public Integer getMaxheightdiff() {
        return this.maxheightdiff;
    }
}

