/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.lostcities.varia.WorldTools;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraftforge.registries.ForgeRegistries;

public class Tools {
    private static final Set<String> DONE = new HashSet<String>();
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_MAPPER = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            Property<?> property = entry.getKey();
            return property.m_61708_() + "=" + this.getName(property, entry.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> comparable) {
            return property.m_6940_(comparable);
        }
    };

    public static String stateToString(BlockState state) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()));
        if (!state.m_61148_().isEmpty()) {
            stringbuilder.append('[');
            stringbuilder.append(state.m_61148_().entrySet().stream().map(PROPERTY_MAPPER).collect(Collectors.joining(",")));
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    public static BlockState stringToState(String s) {
        if (s.contains("[")) {
            try {
                BlockStateParser.BlockResult parser = BlockStateParser.m_234691_((HolderLookup)WorldTools.getOverworld().m_246945_(Registries.f_256747_), (StringReader)new StringReader(s), (boolean)false);
                return parser.f_234748_();
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        String converted = BlockStateData.m_14950_((String)s);
        Block value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(converted));
        if (value == null) {
            throw new RuntimeException("Cannot find block: '" + s + "'!");
        }
        return value.m_49966_();
    }

    public static <T> T getRandomFromList(RandomSource random, List<T> list, Function<T, Float> weightGetter) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<T> elements = new ArrayList<T>();
        float totalweight = 0.0f;
        for (T pair : list) {
            elements.add(pair);
            totalweight += weightGetter.apply(pair).floatValue();
        }
        float r = random.m_188501_() * totalweight;
        for (Object pair : elements) {
            if (!((r -= weightGetter.apply(pair).floatValue()) <= 0.0f)) continue;
            return (T)pair;
        }
        return (T)elements.get(elements.size() - 1);
    }

    public static <T> T getRandomFromList(Random random, List<T> list, Function<T, Float> weightGetter) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<T> elements = new ArrayList<T>();
        float totalweight = 0.0f;
        for (T pair : list) {
            elements.add(pair);
            totalweight += weightGetter.apply(pair).floatValue();
        }
        float r = random.nextFloat() * totalweight;
        for (Object pair : elements) {
            if (!((r -= weightGetter.apply(pair).floatValue()) <= 0.0f)) continue;
            return (T)pair;
        }
        return null;
    }

    public static Iterable<Holder<Block>> getBlocksForTag(TagKey<Block> rl) {
        DefaultedRegistry registry = BuiltInRegistries.f_256975_;
        return registry.m_206058_(rl);
    }

    public static boolean hasTag(Block block, TagKey<Block> tag) {
        return BuiltInRegistries.f_256975_.m_246971_(block.m_204297_().m_205785_()).m_203656_(tag);
    }

    public static int getSeaLevel(LevelReader level) {
        WorldGenLevel wgLevel;
        ChunkSource chunkSource;
        if (level instanceof WorldGenLevel && (chunkSource = (wgLevel = (WorldGenLevel)level).m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache scc = (ServerChunkCache)chunkSource;
            return scc.m_8481_().m_6337_();
        }
        return level.m_5736_();
    }
}

