/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.Utils;

public class ChronalExchangeMahoujinTileEntity
extends MahoujinTileEntity
implements BlockEntityTicker<ChronalExchangeMahoujinTileEntity> {
    private int tickCounter = 0;
    private long dayCounter = 0L;
    private static final String DAY_COUNTER_TAG = "MAHOUTSUKAI_DAY_COUNTER_TAG";

    public ChronalExchangeMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.chronalExchange.get(), p, bs);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, ChronalExchangeMahoujinTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.tickCounter == MTConfig.CHRONAL_EXCHANGE_BLOCK_CYCLE) {
                this.doManaGenOrLoss();
                this.tickCounter = 0;
            }
            ++this.tickCounter;
            ++this.dayCounter;
            this.dayCounter %= 24000L;
            if (this.dayCounter < 0L) {
                this.dayCounter += 24000L;
            }
        }
    }

    public void setTime(long t) {
        this.dayCounter = t;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128356_(DAY_COUNTER_TAG, this.dayCounter);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.dayCounter = compound.m_128454_(DAY_COUNTER_TAG);
        super.m_142466_(compound);
    }

    public void doManaGenOrLoss() {
        IMahou mahou;
        Player player = this.getCaster();
        if (player != null && this.f_58857_ != null && (mahou = Utils.getPlayerMahou(player)) != null) {
            int restore = this.calculateMana();
            if (restore < 0) {
                PlayerManaManager.drainMana(player, -restore, false, false, false, true);
            } else {
                int storedMana = mahou.getStoredMana();
                mahou.setStoredMana(Math.min(storedMana + restore, mahou.getMaxMana()));
            }
        }
    }

    public int calculateMana() {
        return this.getManaFromTime(this.f_58857_.m_46468_());
    }

    public int getManaFromTime(long t) {
        float distance;
        float smaller = -MTConfig.CHRONAL_EXCHANGE_MANA_GAIN_LOSS;
        float diff = 2 * MTConfig.CHRONAL_EXCHANGE_MANA_GAIN_LOSS;
        long now = t % 24000L;
        if (now < 0L) {
            now += 24000L;
        }
        if ((distance = (float)(this.dayCounter % 24000L)) < 0.0f) {
            distance += 24000.0f;
        }
        float ratio = Math.abs(distance - 12000.0f) / 12000.0f;
        int ret = (int)(smaller + diff * ratio);
        return ret;
    }

    public boolean timeInRange(long x, long y) {
        return x < y + 6000L && x >= y - 6000L;
    }
}

