/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.emrys.StaffEmrys;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class LightningEntity
extends Entity {
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_TARGET = "MAHOUTSUKAI_TARGET";
    private static final String TAG_HAS_BALL = "MAHOUTSUKAI_HAS_BALL";
    private static final String TAG_ZAP = "MAHOUTSUKAI_ZAP";
    public boolean rolled = false;
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CASTER_ID = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_BALL = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ZAP = SynchedEntityData.m_135353_(LightningEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public LivingEntity target;
    public LivingEntity caster;
    public double prev_x;
    public double prev_y;
    public double prev_z;
    public float[] segmentlengths;
    public float[] offshootlengths;
    public float[] pitchs;
    public float[] reallengths;
    public float[] prevpitchs;
    public float[] prevreallengths;
    public int segments = 0;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public static final String entityName = "lightning_entity";

    public LightningEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public LightningEntity(Level world) {
        super((EntityType)ModEntities.LIGHTNING.get(), world);
        this.f_19811_ = true;
    }

    public LightningEntity(Level world, LivingEntity caster, LivingEntity target, float r, float g, float b, float a, float size, boolean zap) {
        this(world);
        this.setColor(r, g, b, a);
        this.sizer(size);
        this.caster = caster;
        this.target = target;
        this.f_19804_.m_135381_(TARGET_ID, (Object)target.m_19879_());
        this.f_19804_.m_135381_(CASTER_ID, (Object)caster.m_19879_());
        this.setZap(zap);
        this.setLookPos(world.f_46443_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CASTER_ID, (Object)-1);
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(HAS_BALL, (Object)false);
        this.f_19804_.m_135372_(ZAP, (Object)false);
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_8119_() {
        if (this.caster != null && this.target != null) {
            Vec3 targeteye = this.target.m_20299_(1.0f).m_82520_(0.0, this.getZap() ? (double)(-this.target.m_20206_() / 2.0f) : 0.0, 0.0);
            Vec3 start = this.setLookPos(this.m_9236_().f_46443_);
            if (!this.m_9236_().f_46443_) {
                if (!this.target.m_6084_() || !this.caster.m_6084_()) {
                    this.m_146870_();
                } else {
                    if (targeteye.m_82546_(start).m_82553_() > (double)(MTConfig.EMRYS_MAX_RANGE * 2) || !this.getZap() && this.caster.m_21211_().m_41720_() != ModItems.emrysStaff.get()) {
                        this.m_146870_();
                    } else if (!this.getZap() && ServerHandler.tickCounter % 20L == 0L) {
                        this.target.m_6469_(this.caster.m_269291_().m_269548_(), (float)MTConfig.EMRYS_DAMAGE_FOCUSED_PER_SECOND);
                        this.target.f_20889_ = 100;
                        if (this.caster instanceof Player) {
                            StaffEmrys.zap(this.target, false, (Player)this.caster);
                        }
                    }
                    if (this.getZap() && this.f_19797_ > 8) {
                        EffectUtil.magicAttack(this.target, (float)MTConfig.EMRYS_DAMAGE_ZAP, this.caster);
                        EffectUtil.buff(this.target, ModEffects.ZAP_COOLDOWN, false, 60);
                        StaffEmrys.zap(this.target, false, null);
                        this.m_146870_();
                    }
                }
            } else {
                this.prev_x = this.m_20185_();
                this.prev_y = this.m_20186_();
                this.prev_z = this.m_20189_();
                Vec3 v2 = targeteye.m_82546_(start);
                Vec3 v = v2.m_82541_();
                this.pitch = 90.0f - EffectUtil.toDegrees((float)Math.asin(-v.f_82480_));
                this.yaw = 180.0f + EffectUtil.toDegrees((float)Math.atan2(v.f_82479_, v.f_82481_));
                float len = (float)v2.m_82553_();
                if (!this.rolled) {
                    this.rerollLightningShape(len);
                }
                if (this.segments > 0) {
                    this.copyPrevSegments();
                    this.randomLightningMovement();
                    this.shrink();
                    this.correct(len);
                    this.calculateLightningAnglesAndLengths();
                }
            }
        } else if (this.m_9236_().f_46443_) {
            Entity t = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ID)).intValue());
            Entity c = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(CASTER_ID)).intValue());
            if (t instanceof LivingEntity) {
                this.target = (LivingEntity)t;
            }
            if (c instanceof LivingEntity) {
                this.caster = (LivingEntity)c;
            }
        }
    }

    public void randomLightningMovement() {
        float sidegrowth = 1.0f / (float)this.segments;
        int i = 0;
        while (i < this.offshootlengths.length - 2) {
            int n = i;
            this.offshootlengths[n] = this.offshootlengths[n] + this.f_19796_.m_188501_() * sidegrowth;
            int n2 = i++;
            this.offshootlengths[n2] = this.offshootlengths[n2] % 0.4f;
        }
        i = 0;
        while (i < this.segmentlengths.length - 1) {
            int n = i++;
            this.segmentlengths[n] = this.segmentlengths[n] + Math.max(0.0f, this.f_19796_.m_188501_() * sidegrowth * 3.0f - sidegrowth / 1.5f);
        }
    }

    public void shrink() {
        if (this.segmentlengths[this.segmentlengths.length - 1] < 0.7f) {
            if (this.offshootlengths[this.offshootlengths.length - 2] < 0.7f) {
                int i;
                for (i = this.segmentlengths.length - 1; i > 0; --i) {
                    this.segmentlengths[i] = this.segmentlengths[i - 1];
                }
                this.segmentlengths[0] = 1.0E-4f;
                for (i = this.offshootlengths.length - 2; i > 0; --i) {
                    this.offshootlengths[i] = this.offshootlengths[i - 1];
                }
                this.offshootlengths[0] = 1.0E-4f;
            } else {
                int n = this.offshootlengths.length - 2;
                this.offshootlengths[n] = this.offshootlengths[n] - (0.1f + this.f_19796_.m_188501_() * 0.1f);
            }
        }
    }

    public void correct(float totallen) {
        float t;
        float z = 0.0f;
        for (int i = 0; i < this.segmentlengths.length; ++i) {
            z += this.segmentlengths[i];
        }
        float overflow = z - totallen;
        for (int i = this.segmentlengths.length - 1; i >= 0 && overflow > 0.0f; overflow -= t, --i) {
            t = this.segmentlengths[i];
            this.segmentlengths[i] = t > overflow ? t - overflow : 0.0f;
        }
    }

    public void copyPrevSegments() {
        int i;
        this.prevpitchs = new float[this.pitchs.length];
        for (i = 0; i < this.prevpitchs.length; ++i) {
            this.prevpitchs[i] = this.pitchs[i];
        }
        this.prevreallengths = new float[this.reallengths.length];
        for (i = 0; i < this.prevreallengths.length; ++i) {
            this.prevreallengths[i] = this.reallengths[i];
        }
    }

    public Vec3 setLookPos(boolean client) {
        Vec3 look = this.caster.m_20252_(1.0f);
        Vec3 oldlook = look.m_82541_();
        look = oldlook.m_82490_((double)1.9f);
        look = look.m_82549_(oldlook.m_82524_(EffectUtil.toRad(-90.0f)).m_82490_((double)0.3f)).m_82549_(oldlook.m_82496_(EffectUtil.toRad(-90.0f)).m_82490_((double)0.3f));
        if (this.getZap()) {
            look = new Vec3(0.0, (double)(-this.caster.m_20206_() / 2.0f), 0.0);
        }
        Vec3 start = look.m_82549_(this.caster.m_20299_(1.0f));
        if (!client) {
            this.m_6034_(start.f_82479_, start.f_82480_, start.f_82481_);
        }
        return start;
    }

    public void rerollLightningShape(float totalLenToTarget) {
        float remaining = totalLenToTarget;
        this.segments = this.f_19796_.m_188503_(4) + 6;
        this.segmentlengths = new float[this.segments];
        this.offshootlengths = new float[this.segments];
        for (int i = 0; i < this.segments; ++i) {
            this.segmentlengths[i] = i == this.segments - 1 ? remaining : this.f_19796_.m_188501_() * remaining * 1.0f / (float)this.segments;
            this.offshootlengths[i] = this.f_19796_.m_188501_() * (this.getZap() ? 0.9f : 1.5f);
            remaining -= this.segmentlengths[i];
        }
        this.offshootlengths[this.segments - 1] = 0.0f;
        this.calculateLightningAnglesAndLengths();
        this.rolled = true;
    }

    public void calculateLightningAnglesAndLengths() {
        this.pitchs = new float[this.segments];
        this.reallengths = new float[this.segments];
        for (int i = 0; i < this.segments; ++i) {
            float c;
            float prevb = i == 0 ? 0.0f : this.offshootlengths[i - 1];
            float a = this.segmentlengths[i];
            float b = this.offshootlengths[i] - prevb;
            this.reallengths[i] = c = (float)Math.sqrt(a * a + b * b);
            this.pitchs[i] = EffectUtil.toDegrees((float)Math.asin(b / c));
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_6123_(Player entityIn) {
    }

    public void setColor(float r, float g, float b, float a) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void m_20101_() {
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setBeamSize(s);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setBeamSize(compound.m_128457_(TAG_BEAM_SIZE));
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A));
        this.setHasBall(compound.m_128471_(TAG_HAS_BALL));
        this.setTargetId(compound.m_128451_(TAG_TARGET));
        this.setCasterId(compound.m_128451_(TAG_CASTER));
        this.setZap(compound.m_128471_(TAG_ZAP));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        compound.m_128379_(TAG_HAS_BALL, ((Boolean)this.f_19804_.m_135370_(HAS_BALL)).booleanValue());
        if (this.caster != null) {
            compound.m_128350_(TAG_CASTER, (float)this.getCasterId());
        }
        if (this.target != null) {
            compound.m_128350_(TAG_TARGET, (float)this.getTargetId());
        }
        compound.m_128379_(TAG_ZAP, this.getZap());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getBeamSize() {
        return ((Float)this.f_19804_.m_135370_(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float s) {
        this.f_19804_.m_135381_(BEAM_SIZE, (Object)Float.valueOf(s));
    }

    public boolean getHasBall() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BALL);
    }

    public void setHasBall(boolean s) {
        this.f_19804_.m_135381_(HAS_BALL, (Object)s);
    }

    public boolean getZap() {
        return (Boolean)this.f_19804_.m_135370_(ZAP);
    }

    public void setZap(boolean s) {
        this.f_19804_.m_135381_(ZAP, (Object)s);
    }

    public int getTargetId() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ID);
    }

    public void setTargetId(int id) {
        this.f_19804_.m_135381_(TARGET_ID, (Object)id);
    }

    public int getCasterId() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ID);
    }

    public void setCasterId(int id) {
        this.f_19804_.m_135381_(CASTER_ID, (Object)id);
    }
}

