/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration;

import io.netty.util.internal.ConcurrentSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.RegisterEvent;
import stepsword.jousting.item.ItemLance;
import stepsword.mahoutsukai.MahouRegistry;
import stepsword.mahoutsukai.capability.lance.ILanceMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.integration.JoustingProxy;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.lance.Rhongomyniad;
import stepsword.mahoutsukai.util.PlayerHelp;
import stepsword.mahoutsukai.util.Utils;

public class JoustingLoadedProxy
extends JoustingProxy {
    @Override
    public void registerItems(RegisterEvent.RegisterHelper<Item> helper) {
        helper.register(MahouRegistry.ITEM_RHONGOMYNIAD, (Object)new Rhongomyniad());
    }

    @Override
    public void addToCreativeTab(BuildCreativeModeTabContentsEvent output) {
        output.m_246326_((ItemLike)ModItems.rhongomyniad.get());
    }

    @Override
    public void powerConsolidation(TickEvent.LevelTickEvent event, ItemEntity item, List<ItemEntity> toDelete, List<WeaponProjectileEntity> toSpawn, int manaCost) {
        if (item.m_32055_().m_41720_() instanceof ItemLance && PowerConsolidationSpellEffect.isItemAllowed(item.m_32055_())) {
            boolean inMurkyWater = Utils.isInMurkyWater((Entity)item);
            boolean isAllowed = PowerConsolidationSpellEffect.isItemAllowed(item.m_32055_());
            boolean isEnchanted = item.m_32055_().m_41793_();
            boolean hasOwner = item.f_31988_ != null && item.m_19749_() instanceof Player;
            double rhongomyniadNerf = MTConfig.RHONGOMYNIAD_NERF_FACTOR;
            if (!hasOwner && inMurkyWater) {
                PlayerHelp.sendHelpMessageNearby(item.m_20183_(), item.m_9236_(), PlayerHelp.Message.RHONGOMYNIAD_NO_OWNER);
            }
            if (hasOwner && inMurkyWater) {
                Player player = (Player)item.m_19749_();
                if (isAllowed) {
                    if (isEnchanted) {
                        ConcurrentSet connected = new ConcurrentSet();
                        boolean lt = PowerConsolidationSpellEffect.lakeThreshhold(item.m_20183_(), (ConcurrentSet<BlockPos>)connected, event.level);
                        if (lt) {
                            if (PlayerManaManager.hasMana(player, manaCost)) {
                                ItemStack stack;
                                ILanceMahou mahou;
                                BlockPos p = PowerConsolidationSpellEffect.findCenter((ConcurrentSet<BlockPos>)connected);
                                if (!Utils.isBlockAir(event.level, p)) {
                                    p = p.m_7495_();
                                }
                                if ((mahou = Utils.getLanceMahou(stack = new ItemStack((ItemLike)ModItems.rhongomyniad.get()))) != null) {
                                    float damage = Rhongomyniad.simulateHit(item.m_32055_(), event.level);
                                    ItemStack stackCopy = item.m_32055_().m_41777_();
                                    ListTag tagList = stackCopy.m_41785_();
                                    tagList.clear();
                                    float damageWithoutEnchant = Rhongomyniad.simulateHit(stackCopy, event.level);
                                    damage = (float)((double)damage - rhongomyniadNerf * (double)(damage - damageWithoutEnchant));
                                    mahou.setAttackDamage(damage -= 1.0f);
                                    mahou.setWeight(mahou.getWeight() - 0.02f);
                                    Rhongomyniad.setattacktonbt(stack, event.level);
                                }
                                Utils.debug("Advancement Time");
                                WeaponProjectileEntity wpe = new WeaponProjectileEntity(event.level, p.m_123341_(), p.m_123342_(), p.m_123343_(), stack);
                                wpe.m_20334_(0.0, -1.0, 0.0);
                                wpe.m_5602_((Entity)player);
                                toSpawn.add(wpe);
                                toDelete.add(item);
                            } else {
                                PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.NOT_ENOUGH_MANA);
                            }
                        } else {
                            PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.CALIBURN_LAKE_TOO_SMALL);
                        }
                    } else {
                        PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.RHONGOMYNIAD_NOT_ENCHANTED);
                    }
                } else {
                    PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.RHONGOMYNIAD_LANCE_BANNED);
                }
            }
        }
    }

    @Override
    public boolean treasuryProjection(Item i) {
        return i instanceof ItemLance;
    }
}

