/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class BakuretsuPacket {
    public double posX;
    public double posY;
    public double posZ;
    public int strength;
    public float motionX;
    public float motionY;
    public float motionZ;

    public BakuretsuPacket() {
    }

    public BakuretsuPacket(double posX, double posY, double posZ, int strength, float motionX, float motionY, float motionZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.strength = strength;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.strength = buf.readInt();
        this.motionX = buf.readFloat();
        this.motionY = buf.readFloat();
        this.motionZ = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.strength);
        buf.writeFloat(this.motionX);
        buf.writeFloat(this.motionY);
        buf.writeFloat(this.motionZ);
    }

    public static void encode(BakuretsuPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static BakuretsuPacket decode(FriendlyByteBuf buf) {
        BakuretsuPacket msg = new BakuretsuPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(BakuretsuPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ClientPacketHandler.handleBakuretsu(message);
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }
}

