/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class EntityPathPacket {
    ArrayList<Integer> entities;
    ArrayList<Path> paths;

    public EntityPathPacket() {
    }

    public EntityPathPacket(ArrayList<Integer> entities, ArrayList<Path> paths) {
        this.entities = entities;
        this.paths = paths;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.entities = new ArrayList();
        this.paths = new ArrayList();
        int n = buf.readInt();
        for (i = 0; i < n; ++i) {
            this.entities.add(buf.readInt());
        }
        n = buf.readInt();
        for (i = 0; i < n; ++i) {
            int points = buf.readInt();
            if (points <= 0) continue;
            Node[] p = new Node[points];
            for (int j = 0; j < points; ++j) {
                p[j] = new Node(buf.readInt(), buf.readInt(), buf.readInt());
            }
            this.paths.add(new Path(Arrays.asList(p), p[p.length - 1].m_77288_(), false));
        }
    }

    public void toBytes(ByteBuf buf) {
        int i;
        buf.writeInt(this.entities.size());
        for (i = 0; i < this.entities.size(); ++i) {
            buf.writeInt(this.entities.get(i).intValue());
        }
        buf.writeInt(this.paths.size());
        for (i = 0; i < this.paths.size(); ++i) {
            int points = this.paths.get(i).m_77398_();
            buf.writeInt(points);
            for (int j = 0; j < points; ++j) {
                Node p = this.paths.get(i).m_77375_(j);
                buf.writeInt(p.f_77271_);
                buf.writeInt(p.f_77272_);
                buf.writeInt(p.f_77273_);
            }
        }
    }

    public static void encode(EntityPathPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static EntityPathPacket decode(FriendlyByteBuf buf) {
        EntityPathPacket msg = new EntityPathPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(EntityPathPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.pathHandler(message);
        context.get().setPacketHandled(true);
    }
}

