/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz.objects;

import com.mcwdoors.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GarageDoor
extends Block {
    public static final EnumProperty<GaragePart> PART = EnumProperty.m_61587_((String)"part", GaragePart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape EAST = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.WEST || facing == Direction.EAST) {
            return NORTH;
        }
        return EAST;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return state.m_61143_((Property)FACING) == Direction.WEST || state.m_61143_((Property)FACING) == Direction.EAST ? NORTH : EAST;
    }

    public GarageDoor(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    protected BlockState GarageState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean below;
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean bl = below = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        if (above && below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.MIDDLE));
        }
        if (!above && below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.m_60713_(state.m_60734_())) {
            this.GarageState(state, (LevelAccessor)level, pos);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.GarageState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122427_());
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.m_7731_(pos, this.m_49966_(), num);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.GarageState(state, level, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING, POWERED, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void openDoor(Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)OPEN) != open) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item == this.m_5456_()) {
            return InteractionResult.PASS;
        }
        this.garageDoor(level, pos, (Boolean)state.m_61143_((Property)OPEN) == false, (Direction)state.m_61143_((Property)FACING));
        level.m_5594_(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 10);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level level, BlockPos currentPos, BlockPos facingPos) {
        return super.m_7417_(stateIn, facing, facingState, (LevelAccessor)level, currentPos, facingPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        Block block = level.m_8055_(pos).m_60734_();
        Block upper = level.m_8055_(pos.m_6630_(1)).m_60734_();
        Block lower = level.m_8055_(pos.m_6625_(1)).m_60734_();
        if (upper == block && lower == block) {
            level.m_46597_(pos.m_6625_(1), (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP)));
        } else if (lower == block) {
            level.m_46597_(pos.m_6625_(1), (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP)));
        }
        level.m_5594_(null, pos, SoundEvents.f_12062_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
        if (!(((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && state.m_61143_(PART) == GaragePart.BOTTOM || state.m_61143_(PART) == GaragePart.MIDDLE)) {
            this.m_142387_(level, player, pos, state);
        }
    }

    private void garageDoor(Level world, BlockPos pos, boolean bool, Direction dir) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this && (Boolean)state.m_61143_((Property)OPEN) != bool && ((Direction)state.m_61143_((Property)FACING)).equals((Object)dir)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(bool)));
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newPos = pos.m_7918_(x, y, z);
                        this.garageDoor(world, newPos, bool, dir);
                    }
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        if (!level.f_46443_) {
            boolean powered;
            boolean bl = powered = level.m_276867_(pos) || level.m_276867_(pos.m_7494_());
            if ((Boolean)state.m_61143_((Property)POWERED) != powered) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if ((Boolean)state.m_61143_((Property)OPEN) != powered) {
                    this.garageDoor(level, pos, (Boolean)state.m_61143_((Property)OPEN) == false, (Direction)state.m_61143_((Property)FACING));
                    level.m_5594_(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
                }
            }
        }
    }

    public static enum GaragePart implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

