/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.forge;

import appeng.api.orientation.BlockOrientation;
import appeng.block.storage.DriveBlock;
import appeng.client.render.BakedModelUnwrapper;
import appeng.client.render.DelegateBakedModel;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.client.render.model.DriveBakedModel;
import appeng.core.definitions.AEBlocks;
import appeng.hooks.BuiltInModelHooks;
import appeng.init.InitVillager;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGACraftingUnitType;
import gripe._90.megacells.client.render.MEGACraftingUnitModelProvider;
import gripe._90.megacells.core.Addons;
import gripe._90.megacells.core.Loaders;
import gripe._90.megacells.core.Platform;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGACreativeTab;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import gripe._90.megacells.forge.MEGAConfig;
import gripe._90.megacells.integration.appmek.AppMekIntegration;
import gripe._90.megacells.integration.appmek.AppMekItems;
import gripe._90.megacells.integration.arseng.ArsEngIntegration;
import gripe._90.megacells.integration.arseng.ArsEngItems;
import gripe._90.megacells.misc.CompressionService;
import gripe._90.megacells.misc.LavaTransformLogic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ForgePlatform
implements Platform {
    private static final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();

    @Override
    public Loaders getLoader() {
        return Loaders.FORGE;
    }

    @Override
    public CreativeModeTab.Builder getCreativeTabBuilder() {
        return CreativeModeTab.builder();
    }

    @Override
    public boolean isAddonLoaded(Addons addon) {
        if (ModList.get() == null) {
            return LoadingModList.get().getMods().stream().map(ModInfo::getModId).anyMatch(addon.getModId()::equals);
        }
        return ModList.get().isLoaded(addon.getModId());
    }

    @Override
    public void initItems() {
        Platform.super.initItems();
        if (this.isAddonLoaded(Addons.APPMEK)) {
            AppMekItems.init();
        }
        if (this.isAddonLoaded(Addons.ARSENG)) {
            ArsEngItems.init();
        }
    }

    @Override
    public List<ItemLike> getAllCells() {
        List<ItemLike> cells = Platform.super.getAllCells();
        if (this.isAddonLoaded(Addons.APPMEK)) {
            cells.addAll(AppMekItems.getCells());
            cells.add((ItemLike)AppMekItems.RADIOACTIVE_CHEMICAL_CELL);
        }
        if (this.isAddonLoaded(Addons.ARSENG)) {
            cells.addAll(ArsEngItems.getCells());
        }
        return cells;
    }

    @Override
    public List<ItemLike> getAllPortables() {
        List<ItemLike> portables = Platform.super.getAllPortables();
        if (this.isAddonLoaded(Addons.APPMEK)) {
            portables.addAll(AppMekItems.getPortables());
        }
        if (this.isAddonLoaded(Addons.ARSENG)) {
            portables.addAll(ArsEngItems.getPortables());
        }
        return portables;
    }

    @Override
    public void register() {
        modEventBus.addListener(event -> {
            if (event.getRegistryKey().equals((Object)Registries.f_256747_)) {
                MEGABlocks.getBlocks().forEach(b -> {
                    ForgeRegistries.BLOCKS.register(b.id(), (Object)b.block());
                    ForgeRegistries.ITEMS.register(b.id(), (Object)b.m_5456_());
                });
            }
            if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
                MEGAItems.getItems().forEach(i -> ForgeRegistries.ITEMS.register(i.id(), (Object)i.m_5456_()));
            }
            if (event.getRegistryKey().equals((Object)Registries.f_279569_)) {
                Registry.m_122965_((Registry)BuiltInRegistries.f_279662_, (ResourceLocation)MEGACreativeTab.ID, (Object)MEGACreativeTab.TAB);
            }
            if (event.getRegistryKey().equals((Object)Registries.f_256922_)) {
                MEGABlockEntities.getBlockEntityTypes().forEach((arg_0, arg_1) -> ((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES).register(arg_0, arg_1));
            }
            if (event.getRegistryKey().equals((Object)Registries.f_256798_)) {
                MEGAMenus.getMenuTypes().forEach((arg_0, arg_1) -> ((IForgeRegistry)ForgeRegistries.MENU_TYPES).register(arg_0, arg_1));
            }
        });
    }

    @Override
    public void initUpgrades() {
        modEventBus.addListener(event -> {
            event.enqueueWork(() -> Platform.super.initUpgrades());
            if (this.isAddonLoaded(Addons.APPMEK)) {
                event.enqueueWork(AppMekIntegration::initUpgrades);
            }
            if (this.isAddonLoaded(Addons.ARSENG)) {
                event.enqueueWork(ArsEngIntegration::initUpgrades);
            }
        });
    }

    @Override
    public void initCompression() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            MinecraftServer server = event.getServer();
            CompressionService.INSTANCE.loadRecipes(server.m_129894_(), (RegistryAccess)server.m_206579_());
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() == null) {
                MinecraftServer server = event.getPlayerList().m_7873_();
                CompressionService.INSTANCE.loadRecipes(server.m_129894_(), (RegistryAccess)server.m_206579_());
            }
        });
    }

    @Override
    public void initLavaTransform() {
        MinecraftForge.EVENT_BUS.addListener(event -> LavaTransformLogic.clearCache());
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() == null) {
                LavaTransformLogic.clearCache();
            }
        });
    }

    @Override
    public void addVillagerTrade(ItemLike item, int cost, int quantity, int xp) {
        Int2ObjectMap offers = VillagerTrades.f_35627_.computeIfAbsent(InitVillager.PROFESSION, k -> new Int2ObjectOpenHashMap());
        Object[] masterEntries = (VillagerTrades.ItemListing[])offers.computeIfAbsent(5, k -> new VillagerTrades.ItemListing[0]);
        masterEntries = (VillagerTrades.ItemListing[])ArrayUtils.add((Object[])masterEntries, (i, j) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, cost), new ItemStack(item, quantity), 12, xp, 0.05f));
        offers.put(5, (Object)masterEntries);
    }

    @Override
    public void addIntegrationRecipe(Consumer<FinishedRecipe> writer, FinishedRecipe recipe, Addons addon, ResourceLocation id) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(addon.getModId())).addRecipe(recipe).build(writer, id);
    }

    @Override
    public void addIntegrationRecipe(Consumer<FinishedRecipe> writer, RecipeBuilder builder, Addons addon, ResourceLocation id) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(addon.getModId())).addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(writer, id);
    }

    public static class Client
    implements Platform.Client {
        @Override
        public void initScreens() {
            modEventBus.addListener(event -> this.screens());
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> (Screen)AutoConfig.getConfigScreen(MEGAConfig.class, (Screen)parent).get()));
        }

        @Override
        public void initEnergyCellProps() {
            modEventBus.addListener(event -> this.energyCellProps());
        }

        @Override
        public void initCraftingUnitModels() {
            for (MEGACraftingUnitType type : MEGACraftingUnitType.values()) {
                BuiltInModelHooks.addBuiltInModel((ResourceLocation)MEGACells.makeId("block/crafting/" + type.getAffix() + "_formed"), (UnbakedModel)new CraftingCubeModel((AbstractCraftingUnitModelProvider)new MEGACraftingUnitModelProvider(type)));
                modEventBus.addListener(event -> ItemBlockRenderTypes.setRenderLayer((Block)type.getDefinition().block(), (RenderType)RenderType.m_110463_()));
            }
        }

        @Override
        public void initItemColours(ItemColor color, List<ItemLike> items) {
            modEventBus.addListener(event -> event.register(color, items.toArray(new ItemLike[0])));
        }

        @Override
        public BakedModel createCellModel(Item cell, final BlockOrientation orientation) {
            DriveBakedModel driveModel = (DriveBakedModel)BakedModelUnwrapper.unwrap((BakedModel)Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(((DriveBlock)AEBlocks.DRIVE.block()).m_49966_()), DriveBakedModel.class);
            if (driveModel == null) {
                return null;
            }
            return new DelegateBakedModel(driveModel.getCellChassisModel(cell)){

                @NotNull
                public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderType) {
                    if (side != null) {
                        side = orientation.resultingRotate(side);
                    }
                    ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData, renderType));
                    for (int i = 0; i < quads.size(); ++i) {
                        BakedQuad quad = quads.get(i);
                        BakedQuad baked = new BakedQuad(quad.m_111303_(), quad.m_111305_(), orientation.rotate(quad.m_111306_()), quad.m_173410_(), quad.m_111307_());
                        quads.set(i, baked);
                    }
                    return quads;
                }
            };
        }
    }
}

