/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.integration.arseng;

import appeng.core.definitions.ItemDefinition;
import appeng.items.materials.MaterialItem;
import appeng.items.storage.StorageTier;
import appeng.items.tools.powered.AbstractPortableCell;
import gripe._90.arseng.item.PortableSourceCellItem;
import gripe._90.arseng.item.SourceCellItem;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGAItems;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class ArsEngItems {
    public static final ItemDefinition<MaterialItem> MEGA_SOURCE_CELL_HOUSING = MEGAItems.item("MEGA Source Cell Housing", "mega_source_cell_housing", MaterialItem::new);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_1M = ArsEngItems.cell(MEGAItems.TIER_1M);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_4M = ArsEngItems.cell(MEGAItems.TIER_4M);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_16M = ArsEngItems.cell(MEGAItems.TIER_16M);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_64M = ArsEngItems.cell(MEGAItems.TIER_64M);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_256M = ArsEngItems.cell(MEGAItems.TIER_256M);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL_1M = ArsEngItems.portable(MEGAItems.TIER_1M);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL_4M = ArsEngItems.portable(MEGAItems.TIER_4M);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL_16M = ArsEngItems.portable(MEGAItems.TIER_16M);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL_64M = ArsEngItems.portable(MEGAItems.TIER_64M);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL_256M = ArsEngItems.portable(MEGAItems.TIER_256M);

    public static void init() {
        MEGACells.LOGGER.info("Initialised Ars \u00c9nergistique integration.");
    }

    public static List<ItemDefinition<?>> getCells() {
        return List.of(SOURCE_CELL_1M, SOURCE_CELL_4M, SOURCE_CELL_16M, SOURCE_CELL_64M, SOURCE_CELL_256M);
    }

    public static List<ItemDefinition<? extends AbstractPortableCell>> getPortables() {
        return List.of(PORTABLE_SOURCE_CELL_1M, PORTABLE_SOURCE_CELL_4M, PORTABLE_SOURCE_CELL_16M, PORTABLE_SOURCE_CELL_64M, PORTABLE_SOURCE_CELL_256M);
    }

    private static ItemDefinition<SourceCellItem> cell(StorageTier tier) {
        return MEGAItems.item(tier.namePrefix().toUpperCase() + " MEGA Source Storage Cell", "source_storage_cell_" + tier.namePrefix(), p -> new SourceCellItem(p, tier, MEGA_SOURCE_CELL_HOUSING));
    }

    private static ItemDefinition<PortableSourceCellItem> portable(final StorageTier tier) {
        return MEGAItems.item(tier.namePrefix().toUpperCase() + " Portable Source Cell", "portable_source_cell_" + tier.namePrefix(), p -> new PortableSourceCellItem((Item.Properties)p, tier){

            @NotNull
            public ResourceLocation getRecipeId() {
                return MEGACells.makeId("cells/portable/portable_source_cell_" + tier.namePrefix());
            }
        });
    }
}

