/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.gadget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class MiningProperties {
    private static final String KEY_BEAM_RANGE = "beamRange";
    private static final String KEY_MAX_BEAM_RANGE = "maxBeamRange";
    private static final String KEY_WHITELIST = "isWhitelist";
    private static final String KEY_RANGE = "range";
    private static final String KEY_MAX_MINING_RANGE = "maxMiningRange";
    private static final String KEY_SIZE_MODE = "sizeMode";
    private static final String KEY_SPEED = "speed";
    private static final String BREAK_TYPE = "breakType";
    private static final String CAN_MINE = "canMine";
    private static final String PRECISION_MODE = "precisionMode";
    private static final String VOLUME = "volume";
    private static final String FREEZE_PARTICLE_DELAY = "freeze_particle_delay";
    private static final String KEY_BATTERY_TIER = "battery_tier";
    public static final String KEY_FILTERS = "filters";
    public static final String COLOR_RED = "colorRed";
    public static final String COLOR_GREEN = "colorGreen";
    public static final String COLOR_BLUE = "colorBlue";
    public static final String COLOR_RED_INNER = "colorRedInner";
    public static final String COLOR_GREEN_INNER = "colorGreenInner";
    public static final String COLOR_BLUE_INNER = "colorBlueInner";
    public static final int MIN_RANGE = 5;

    private MiningProperties() {
    }

    public static short getColor(ItemStack gadget, String color) {
        CompoundTag compound = gadget.m_41784_();
        if (color.equals(COLOR_RED) || color.contains("Inner")) {
            return !compound.m_128441_(color) ? MiningProperties.setColor(gadget, (short)255, color) : compound.m_128448_(color);
        }
        return !compound.m_128441_(color) ? MiningProperties.setColor(gadget, (short)0, color) : compound.m_128448_(color);
    }

    public static short setColor(ItemStack gadget, short colorValue, String color) {
        gadget.m_41784_().m_128376_(color, colorValue);
        return colorValue;
    }

    public static BreakTypes setBreakType(ItemStack gadget, BreakTypes breakType) {
        gadget.m_41784_().m_128344_(BREAK_TYPE, (byte)breakType.ordinal());
        return breakType;
    }

    public static void nextBreakType(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        if (compound.m_128441_(BREAK_TYPE)) {
            int type = MiningProperties.getBreakType(gadget).ordinal() == BreakTypes.values().length - 1 ? 0 : MiningProperties.getBreakType(gadget).ordinal() + 1;
            MiningProperties.setBreakType(gadget, BreakTypes.values()[type]);
        } else {
            MiningProperties.setBreakType(gadget, BreakTypes.FADE);
        }
    }

    public static BreakTypes getBreakType(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(BREAK_TYPE) ? MiningProperties.setBreakType(gadget, BreakTypes.SHRINK) : BreakTypes.values()[compound.m_128445_(BREAK_TYPE)];
    }

    public static int setSpeed(ItemStack gadget, int speed) {
        gadget.m_41784_().m_128405_(KEY_SPEED, speed);
        return speed;
    }

    public static int getSpeed(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(KEY_SPEED) ? MiningProperties.setSpeed(gadget, 1) : compound.m_128451_(KEY_SPEED);
    }

    public static int setRange(ItemStack gadget, int range) {
        gadget.m_41784_().m_128405_(KEY_RANGE, range);
        return range;
    }

    public static int getRange(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(KEY_RANGE) ? MiningProperties.setRange(gadget, 1) : compound.m_128451_(KEY_RANGE);
    }

    public static int setBeamRange(ItemStack gadget, int range) {
        gadget.m_41784_().m_128405_(KEY_BEAM_RANGE, range);
        return range;
    }

    public static int setBeamMaxRange(ItemStack gadget, int range) {
        gadget.m_41784_().m_128405_(KEY_MAX_BEAM_RANGE, range);
        return range;
    }

    public static int getBeamRange(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(KEY_BEAM_RANGE) ? MiningProperties.setBeamRange(gadget, 5) : compound.m_128451_(KEY_BEAM_RANGE);
    }

    public static int getBeamMaxRange(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(KEY_MAX_BEAM_RANGE) ? MiningProperties.setBeamMaxRange(gadget, 5) : compound.m_128451_(KEY_MAX_BEAM_RANGE);
    }

    public static int setMaxMiningRange(ItemStack gadget, int range) {
        gadget.m_41784_().m_128405_(KEY_MAX_MINING_RANGE, range);
        return range;
    }

    public static int getMaxMiningRange(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(KEY_MAX_MINING_RANGE) ? MiningProperties.setMaxMiningRange(gadget, 1) : compound.m_128451_(KEY_MAX_MINING_RANGE);
    }

    public static boolean setWhitelist(ItemStack gadget, boolean isWhitelist) {
        gadget.m_41784_().m_128379_(KEY_WHITELIST, isWhitelist);
        return isWhitelist;
    }

    public static boolean getWhiteList(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(KEY_WHITELIST) ? MiningProperties.setWhitelist(gadget, true) : compound.m_128471_(KEY_WHITELIST);
    }

    public static boolean setCanMine(ItemStack gadget, boolean canMine) {
        gadget.m_41784_().m_128379_(CAN_MINE, canMine);
        return canMine;
    }

    public static boolean getCanMine(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(CAN_MINE) ? MiningProperties.setCanMine(gadget, true) : compound.m_128471_(CAN_MINE);
    }

    public static boolean setPrecisionMode(ItemStack gadget, boolean precisionMode) {
        gadget.m_41784_().m_128379_(PRECISION_MODE, precisionMode);
        return precisionMode;
    }

    public static boolean getPrecisionMode(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(PRECISION_MODE) ? MiningProperties.setPrecisionMode(gadget, false) : compound.m_128471_(PRECISION_MODE);
    }

    public static SizeMode setSizeMode(ItemStack gadget, SizeMode sizeMode) {
        gadget.m_41784_().m_128344_(KEY_SIZE_MODE, (byte)sizeMode.ordinal());
        return sizeMode;
    }

    public static SizeMode nextSizeMode(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        if (compound.m_128441_(KEY_SIZE_MODE)) {
            int type = MiningProperties.getSizeMode(gadget).ordinal() == SizeMode.values().length - 1 ? 0 : MiningProperties.getSizeMode(gadget).ordinal() + 1;
            return MiningProperties.setSizeMode(gadget, SizeMode.values()[type]);
        }
        return MiningProperties.setSizeMode(gadget, SizeMode.NORMAL);
    }

    public static SizeMode getSizeMode(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(KEY_SIZE_MODE) ? MiningProperties.setSizeMode(gadget, SizeMode.NORMAL) : SizeMode.values()[compound.m_128445_(KEY_SIZE_MODE)];
    }

    public static float setVolume(ItemStack gadget, float volume) {
        gadget.m_41784_().m_128350_(VOLUME, Math.max(0.0f, Math.min(1.0f, volume)));
        return volume;
    }

    public static float getVolume(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(VOLUME) ? MiningProperties.setVolume(gadget, 1.0f) : compound.m_128457_(VOLUME);
    }

    public static int setFreezeDelay(ItemStack gadget, int volume) {
        gadget.m_41784_().m_128405_(FREEZE_PARTICLE_DELAY, Math.max(0, Math.min(10, volume)));
        return volume;
    }

    public static int getFreezeDelay(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(FREEZE_PARTICLE_DELAY) ? MiningProperties.setFreezeDelay(gadget, 0) : compound.m_128451_(FREEZE_PARTICLE_DELAY);
    }

    public static int setBatteryTier(ItemStack gadget, int tier) {
        gadget.m_41784_().m_128405_(KEY_BATTERY_TIER, tier);
        return tier;
    }

    public static int getBatteryTier(ItemStack gadget) {
        CompoundTag compound = gadget.m_41784_();
        return !compound.m_128441_(KEY_BATTERY_TIER) ? MiningProperties.setBatteryTier(gadget, 0) : compound.m_128451_(KEY_BATTERY_TIER);
    }

    public static List<ItemStack> getFiltersAsList(ItemStack gadget) {
        return MiningProperties.deserializeItemStackList(gadget.m_41698_(KEY_FILTERS));
    }

    public static List<ItemStack> deserializeItemStackList(CompoundTag nbt) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            stacks.add(ItemStack.m_41712_((CompoundTag)itemTags));
        }
        return stacks;
    }

    public static CompoundTag serializeItemStackList(List<ItemStack> stacks) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            stacks.get(i).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public static enum BreakTypes {
        SHRINK,
        FADE;

    }

    public static enum SizeMode {
        AUTO("auto"),
        NORMAL("normal"),
        PATHWAY("pathway");

        private final String baseName;

        private SizeMode(String baseName) {
            this.baseName = baseName;
        }

        public Component getTooltip() {
            return Component.m_237115_((String)("mininggadgets.tooltip.screen.sizemode." + this.baseName));
        }
    }
}

