/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncBookDataMessage
implements Message {
    public static final ResourceLocation ID = new ResourceLocation("modonomicon", "sync_book_data");
    public ConcurrentMap<ResourceLocation, Book> books = new ConcurrentHashMap<ResourceLocation, Book>();

    public SyncBookDataMessage(ConcurrentMap<ResourceLocation, Book> books) {
        this.books = books;
    }

    public SyncBookDataMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.books.size());
        for (Book book : this.books.values()) {
            buf.m_130085_(book.getId());
            book.toNetwork(buf);
            buf.m_130130_(book.getCategories().size());
            for (BookCategory category : book.getCategories().values()) {
                buf.m_130085_(category.getId());
                category.toNetwork(buf);
                buf.m_130130_(category.getEntries().size());
                for (BookEntry entry : category.getEntries().values()) {
                    buf.m_130085_(entry.getId());
                    entry.toNetwork(buf);
                }
            }
            buf.m_130130_(book.getCommands().size());
            for (BookCommand command : book.getCommands().values()) {
                buf.m_130085_(command.getId());
                command.toNetwork(buf);
            }
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        int bookCount = buf.m_130242_();
        for (int i = 0; i < bookCount; ++i) {
            ResourceLocation bookId = buf.m_130281_();
            Book book = Book.fromNetwork(bookId, buf);
            this.books.put(bookId, book);
            int categoryCount = buf.m_130242_();
            for (int j = 0; j < categoryCount; ++j) {
                ResourceLocation categoryId = buf.m_130281_();
                BookCategory category = BookCategory.fromNetwork(categoryId, buf);
                book.addCategory(category);
                int entryCount = buf.m_130242_();
                for (int k = 0; k < entryCount; ++k) {
                    ResourceLocation entryId = buf.m_130281_();
                    BookEntry bookEntry = BookEntry.fromNetwork(entryId, buf);
                    category.addEntry(bookEntry);
                }
            }
            int commandCount = buf.m_130242_();
            for (int j = 0; j < commandCount; ++j) {
                ResourceLocation commandId = buf.m_130281_();
                BookCommand command = BookCommand.fromNetwork(commandId, buf);
                book.addCommand(command);
            }
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        BookDataManager.get().onDatapackSyncPacket(this);
    }
}

