/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.AbstractModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.mojang.datafixers.util.Pair;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public abstract class EntryProvider {
    protected CategoryProvider parent;
    protected BookEntryModel entry;

    public EntryProvider(CategoryProvider parent) {
        this.parent = parent;
        this.entry = null;
    }

    protected ModonomiconLanguageProvider lang() {
        return this.parent.lang();
    }

    protected ModonomiconLanguageProvider lang(String locale) {
        return this.parent.lang();
    }

    protected ResourceLocation modLoc(String name) {
        return this.parent.modLoc(name);
    }

    protected BookContextHelper context() {
        return this.parent.context();
    }

    protected String macro(String input) {
        return this.parent.macro(input);
    }

    protected String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected String entryLink(String text, String category, String entry) {
        return this.parent.entryLink(text, category, entry);
    }

    protected String categoryLink(String text, String category) {
        return this.parent.categoryLink(text, category);
    }

    protected String itemLink(ItemLike item) {
        return this.parent.itemLink(item);
    }

    protected String itemLink(String text, ItemLike item) {
        return this.parent.itemLink(text, item);
    }

    protected String commandLink(String text, String commandId) {
        return this.parent.commandLink(text, commandId);
    }

    protected String entryLinkDummy(String text, String category, String entry) {
        return this.parent.entryLinkDummy(text, category, entry);
    }

    protected String categoryLinkDummy(String text, String category) {
        return this.parent.categoryLinkDummy(text, category);
    }

    protected void pageTitle(String title) {
        this.add(this.context().pageTitle(), title);
    }

    protected void pageText(String text) {
        this.add(this.context().pageText(), text);
    }

    protected void pageText(String text, Object ... args) {
        this.add(this.context().pageText(), text, args);
    }

    protected <T extends BookPageModel> T page(T model) {
        return this.add(model);
    }

    protected <T extends BookPageModel> T page(String page, Supplier<T> modelSupplier) {
        this.context().page(page);
        BookPageModel model = (BookPageModel)modelSupplier.get();
        return (T)this.add(model);
    }

    protected void add(String key, String value) {
        this.lang().add(key, this.macro(value));
    }

    protected void add(AbstractModonomiconLanguageProvider translation, String key, String value) {
        translation.add(key, this.macro(value));
    }

    protected void add(String key, String pattern, Object ... args) {
        this.add(key, this.format(pattern, args));
    }

    protected void add(AbstractModonomiconLanguageProvider translation, String key, String pattern, Object ... args) {
        this.add(translation, key, this.format(pattern, args));
    }

    protected <T extends BookPageModel> T add(T page) {
        this.entry.withPage(page);
        return page;
    }

    protected <T extends BookPageModel> List<T> add(List<T> pages) {
        this.entry.withPages(pages);
        return pages;
    }

    public BookEntryModel generate(char location) {
        this.context().entry(this.entryId());
        BookEntryModel entry = BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription());
        this.add(this.context().entryName(), this.entryName());
        this.add(this.context().entryDescription(), this.entryDescription());
        entry.withIcon(this.entryIcon());
        entry.withLocation(this.parent.entryMap().get(Character.valueOf(location)));
        entry.withEntryBackground(this.entryBackground());
        this.entry = this.additionalSetup(entry);
        this.generatePages();
        this.parent.add(this.entry);
        return this.entry;
    }

    protected abstract void generatePages();

    protected BookEntryModel additionalSetup(BookEntryModel entry) {
        return entry;
    }

    protected abstract String entryName();

    protected abstract String entryDescription();

    protected abstract Pair<Integer, Integer> entryBackground();

    protected abstract BookIconModel entryIcon();

    protected abstract String entryId();
}

