/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.NetworkLoader;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public abstract class BookCondition {
    protected Component tooltip;

    public BookCondition(Component tooltip) {
        this.tooltip = tooltip;
    }

    public static MutableComponent tooltipFromJson(JsonObject json) {
        if (json.has("tooltip")) {
            JsonElement tooltipElement = json.get("tooltip");
            if (tooltipElement.isJsonPrimitive()) {
                return Component.m_237115_((String)tooltipElement.getAsString());
            }
            return Component.Serializer.m_130691_((JsonElement)tooltipElement);
        }
        return null;
    }

    public static BookCondition fromJson(JsonObject json) {
        ResourceLocation type = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"type"));
        JsonLoader<? extends BookCondition> loader = LoaderRegistry.getConditionJsonLoader(type);
        return loader.fromJson(json);
    }

    public static BookCondition fromNetwork(FriendlyByteBuf buf) {
        ResourceLocation type = buf.m_130281_();
        NetworkLoader<? extends BookCondition> loader = LoaderRegistry.getConditionNetworkLoader(type);
        return loader.fromNetwork(buf);
    }

    public static void toNetwork(BookCondition condition, FriendlyByteBuf buf) {
        buf.m_130085_(condition.getType());
        condition.toNetwork(buf);
    }

    public abstract ResourceLocation getType();

    public abstract void toNetwork(FriendlyByteBuf var1);

    public abstract boolean test(BookConditionContext var1, Player var2);

    public boolean requiresMultiPassUnlockTest() {
        return false;
    }

    public List<Component> getTooltip(BookConditionContext context) {
        return this.tooltip != null ? List.of(this.tooltip) : List.of();
    }
}

