/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class BookModLoadedCondition
extends BookCondition {
    protected String modId;

    public BookModLoadedCondition(Component component, String modId) {
        super(component);
        this.modId = modId;
    }

    public static BookModLoadedCondition fromJson(JsonObject json) {
        String modId = GsonHelper.m_13906_((JsonObject)json, (String)"mod_id");
        MutableComponent tooltip = Component.m_237110_((String)"tooltip.modonomicon..condition.mod_loaded", (Object[])new Object[]{"mods." + modId + ".name"});
        if (json.has("tooltip")) {
            tooltip = BookModLoadedCondition.tooltipFromJson(json);
        }
        return new BookModLoadedCondition((Component)tooltip, modId);
    }

    public static BookModLoadedCondition fromNetwork(FriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? buffer.m_130238_() : null;
        String modId = buffer.m_130277_();
        return new BookModLoadedCondition(tooltip, modId);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Condition.MOD_LOADED;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buffer.m_130083_(this.tooltip);
        }
        buffer.m_130070_(this.modId);
    }

    @Override
    public boolean test(BookConditionContext context, Player player) {
        return Services.PLATFORM.isModLoaded(this.modId);
    }
}

