/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.conditions.BookAndCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryReadCondition;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.networking.Message;
import com.klikli_dev.modonomicon.networking.SyncBookDataMessage;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.platform.Services;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;

public class BookDataManager
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER = "modonomicon/books";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final BookDataManager instance = new BookDataManager();
    private ConcurrentMap<ResourceLocation, Book> books = new ConcurrentHashMap<ResourceLocation, Book>();
    private boolean loaded;
    private boolean booksBuilt;

    private BookDataManager() {
        super(GSON, FOLDER);
    }

    public static BookDataManager get() {
        return instance;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public ConcurrentMap<ResourceLocation, Book> getBooks() {
        return this.books;
    }

    public Book getBook(ResourceLocation id) {
        return (Book)this.books.get(id);
    }

    public Message getSyncMessage() {
        return new SyncBookDataMessage(new ConcurrentHashMap<ResourceLocation, Book>(this.books));
    }

    public boolean areBooksBuilt() {
        return this.booksBuilt;
    }

    public void onDatapackSyncPacket(SyncBookDataMessage message) {
        this.preLoad();
        this.books = message.books;
        this.onLoadingComplete();
    }

    public void onDatapackSync(ServerPlayer player) {
        this.tryBuildBooks(player.m_9236_());
        Message syncMessage = this.getSyncMessage();
        Services.NETWORK.sendToSplit(player, syncMessage);
    }

    public void onRecipesUpdated(Level level) {
        this.tryBuildBooks(level);
        this.prerenderMarkdown();
    }

    public void preLoad() {
        this.booksBuilt = false;
        this.loaded = false;
        this.books.clear();
        BookErrorManager.get().reset();
    }

    public void buildBooks(Level level) {
        for (Book book : this.books.values()) {
            BookErrorManager.get().getContextHelper().reset();
            BookErrorManager.get().setCurrentBookId(book.getId());
            try {
                book.build(level);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to build book '" + book.getId() + "'", e);
            }
            BookErrorManager.get().setCurrentBookId(null);
        }
    }

    public void prerenderMarkdown() {
        Modonomicon.LOG.info("Pre-rendering markdown ...");
        for (Book book : this.books.values()) {
            BookErrorManager.get().getContextHelper().reset();
            BookErrorManager.get().setCurrentBookId(book.getId());
            BookTextRenderer textRenderer = new BookTextRenderer(book);
            if (!BookErrorManager.get().hasErrors(book.getId())) {
                try {
                    book.prerenderMarkdown(textRenderer);
                }
                catch (Exception e) {
                    BookErrorManager.get().error("Failed to render markdown for book '" + book.getId() + "'", e);
                }
            } else {
                BookErrorManager.get().error("Cannot render markdown for book '" + book.getId() + " because of errors during book build'");
            }
            BookErrorManager.get().setCurrentBookId(null);
        }
        Modonomicon.LOG.info("Finished pre-rendering markdown.");
    }

    public void addReadConditions() {
        for (Book book : this.books.values()) {
            if (!book.autoAddReadConditions()) continue;
            for (BookEntry entry : book.getEntries().values()) {
                if (!entry.getCondition().getType().equals((Object)ModonomiconConstants.Data.Condition.NONE)) continue;
                if (entry.getParents().size() == 1) {
                    entry.setCondition(new BookEntryReadCondition(null, entry.getParents().get(0).getEntryId()));
                    continue;
                }
                if (entry.getParents().size() <= 1) continue;
                List<BookEntryReadCondition> conditions = entry.getParents().stream().map(parent -> new BookEntryReadCondition(null, parent.getEntryId())).toList();
                BookAndCondition andCondition = new BookAndCondition(null, conditions.toArray(new BookEntryReadCondition[0]));
                entry.setCondition(andCondition);
            }
        }
    }

    public boolean tryBuildBooks(Level level) {
        if (!this.booksBuilt) {
            Modonomicon.LOG.info("Building books ...");
            this.buildBooks(level);
            this.booksBuilt = true;
            Modonomicon.LOG.info("Books built.");
            Modonomicon.LOG.info("Adding read conditions ...");
            this.addReadConditions();
            Modonomicon.LOG.info("Read conditions added.");
            return true;
        }
        return false;
    }

    protected void onLoadingComplete() {
        this.loaded = true;
    }

    private Book loadBook(ResourceLocation key, JsonObject value) {
        return Book.fromJson(key, value);
    }

    private BookCategory loadCategory(ResourceLocation key, JsonObject value) {
        return BookCategory.fromJson(key, value);
    }

    private BookEntry loadEntry(ResourceLocation key, JsonObject value) {
        return BookEntry.fromJson(key, value);
    }

    private BookCommand loadCommand(ResourceLocation key, JsonObject value) {
        return BookCommand.fromJson(key, value);
    }

    private void categorizeContent(Map<ResourceLocation, JsonElement> content, HashMap<ResourceLocation, JsonObject> bookJsons, HashMap<ResourceLocation, JsonObject> categoryJsons, HashMap<ResourceLocation, JsonObject> entryJsons, HashMap<ResourceLocation, JsonObject> commandJsons) {
        block12: for (Map.Entry<ResourceLocation, JsonElement> entry : content.entrySet()) {
            String[] pathParts = entry.getKey().m_135815_().split("/");
            ResourceLocation bookId = new ResourceLocation(entry.getKey().m_135827_(), pathParts[0]);
            switch (pathParts[1]) {
                case "book": {
                    bookJsons.put(entry.getKey(), entry.getValue().getAsJsonObject());
                    continue block12;
                }
                case "entries": {
                    entryJsons.put(entry.getKey(), entry.getValue().getAsJsonObject());
                    continue block12;
                }
                case "categories": {
                    categoryJsons.put(entry.getKey(), entry.getValue().getAsJsonObject());
                    continue block12;
                }
                case "commands": {
                    commandJsons.put(entry.getKey(), entry.getValue().getAsJsonObject());
                    continue block12;
                }
            }
            Modonomicon.LOG.warn("Found unknown content for book '{}': '{}'. Should be one of: [File: book.json, Directory: entries/, Directory: categories/, Directory: commands/]", (Object)bookId, (Object)entry.getKey());
            BookErrorManager.get().error(bookId, "Found unknown content for book '" + bookId + "': '" + entry.getKey() + "'. Should be one of: [File: book.json, Directory: entries/, Directory: categories/, Directory: commands/]");
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> content, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        Book book;
        ResourceLocation bookId;
        String[] pathParts;
        this.preLoad();
        HashMap<ResourceLocation, JsonObject> bookJsons = new HashMap<ResourceLocation, JsonObject>();
        HashMap<ResourceLocation, JsonObject> categoryJsons = new HashMap<ResourceLocation, JsonObject>();
        HashMap<ResourceLocation, JsonObject> entryJsons = new HashMap<ResourceLocation, JsonObject>();
        HashMap<ResourceLocation, JsonObject> commandJsons = new HashMap<ResourceLocation, JsonObject>();
        this.categorizeContent(content, bookJsons, categoryJsons, entryJsons, commandJsons);
        BookErrorManager.get().setContext("", new Object[0]);
        for (Map.Entry<ResourceLocation, JsonObject> entry : bookJsons.entrySet()) {
            try {
                pathParts = entry.getKey().m_135815_().split("/");
                bookId = new ResourceLocation(entry.getKey().m_135827_(), pathParts[0]);
                BookErrorManager.get().setCurrentBookId(bookId);
                Book book2 = this.loadBook(bookId, entry.getValue());
                this.books.put(book2.getId(), book2);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to load book '" + entry.getKey() + "'", e);
            }
            BookErrorManager.get().setCurrentBookId(null);
        }
        for (Map.Entry<ResourceLocation, JsonObject> entry : categoryJsons.entrySet()) {
            try {
                pathParts = entry.getKey().m_135815_().split("/");
                bookId = new ResourceLocation(entry.getKey().m_135827_(), pathParts[0]);
                BookErrorManager.get().setCurrentBookId(bookId);
                ResourceLocation categoryId = new ResourceLocation(entry.getKey().m_135827_(), Arrays.stream(pathParts).skip(2L).collect(Collectors.joining("/")));
                BookCategory category = this.loadCategory(categoryId, entry.getValue());
                book = (Book)this.books.get(bookId);
                book.addCategory(category);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to load category '" + entry.getKey() + "'", e);
            }
            BookErrorManager.get().setCurrentBookId(null);
        }
        for (Map.Entry<ResourceLocation, JsonObject> entry : entryJsons.entrySet()) {
            try {
                pathParts = entry.getKey().m_135815_().split("/");
                bookId = new ResourceLocation(entry.getKey().m_135827_(), pathParts[0]);
                BookErrorManager.get().setCurrentBookId(bookId);
                ResourceLocation entryId = new ResourceLocation(entry.getKey().m_135827_(), Arrays.stream(pathParts).skip(2L).collect(Collectors.joining("/")));
                BookEntry bookEntry = this.loadEntry(entryId, entry.getValue());
                book = (Book)this.books.get(bookId);
                BookCategory category = book.getCategory(bookEntry.getCategoryId());
                category.addEntry(bookEntry);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to load entry '" + entry.getKey() + "'", e);
            }
            BookErrorManager.get().setCurrentBookId(null);
        }
        for (Map.Entry<ResourceLocation, JsonObject> entry : commandJsons.entrySet()) {
            try {
                pathParts = entry.getKey().m_135815_().split("/");
                bookId = new ResourceLocation(entry.getKey().m_135827_(), pathParts[0]);
                BookErrorManager.get().setCurrentBookId(bookId);
                ResourceLocation commandId = new ResourceLocation(entry.getKey().m_135827_(), Arrays.stream(pathParts).skip(2L).collect(Collectors.joining("/")));
                BookCommand command = this.loadCommand(commandId, entry.getValue());
                book = (Book)this.books.get(bookId);
                book.addCommand(command);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to load command '" + entry.getKey() + "'", e);
            }
            BookErrorManager.get().setCurrentBookId(null);
        }
        BookErrorManager.get().setContext(null, new Object[0]);
        this.onLoadingComplete();
    }

    public static class Client {
        private static final Client instance = new Client();
        private static ResourceLocation fallbackFont = new ResourceLocation("minecraft", "default");
        private boolean isFallbackLocale;
        private boolean isInitialized;

        public static Client get() {
            return instance;
        }

        public boolean useFallbackFont() {
            if (!this.isInitialized) {
                this.isInitialized = true;
                String locale = Minecraft.m_91087_().m_91102_().m_264236_();
                this.isFallbackLocale = ClientServices.CLIENT_CONFIG.fontFallbackLocales().stream().anyMatch(l -> l.equals(locale));
            }
            return this.isFallbackLocale;
        }

        public ResourceLocation safeFont(ResourceLocation requested) {
            return this.useFallbackFont() ? fallbackFont : requested;
        }
    }
}

