/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.network;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.network.MessageHandler;
import com.klikli_dev.modonomicon.networking.BookEntryReadMessage;
import com.klikli_dev.modonomicon.networking.ClickCommandLinkMessage;
import com.klikli_dev.modonomicon.networking.ClickReadAllButtonMessage;
import com.klikli_dev.modonomicon.networking.ReloadResourcesDoneMessage;
import com.klikli_dev.modonomicon.networking.ReloadResourcesOnClientMessage;
import com.klikli_dev.modonomicon.networking.RequestSyncBookStatesMessage;
import com.klikli_dev.modonomicon.networking.SaveBookStateMessage;
import com.klikli_dev.modonomicon.networking.SaveCategoryStateMessage;
import com.klikli_dev.modonomicon.networking.SaveEntryStateMessage;
import com.klikli_dev.modonomicon.networking.SendUnlockCodeToClientMessage;
import com.klikli_dev.modonomicon.networking.SendUnlockCodeToServerMessage;
import com.klikli_dev.modonomicon.networking.SyncBookDataMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.networking.SyncBookVisualStatesMessage;
import com.klikli_dev.modonomicon.networking.SyncMultiblockDataMessage;
import java.util.ArrayList;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.filters.VanillaPacketSplitter;
import net.minecraftforge.network.simple.SimpleChannel;

public class Networking {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("modonomicon", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int ID = 0;

    public static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE.registerMessage(Networking.nextID(), BookEntryReadMessage.class, BookEntryReadMessage::encode, BookEntryReadMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), ClickCommandLinkMessage.class, ClickCommandLinkMessage::encode, ClickCommandLinkMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), ClickReadAllButtonMessage.class, ClickReadAllButtonMessage::encode, ClickReadAllButtonMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SaveBookStateMessage.class, SaveBookStateMessage::encode, SaveBookStateMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SaveCategoryStateMessage.class, SaveCategoryStateMessage::encode, SaveCategoryStateMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SaveEntryStateMessage.class, SaveEntryStateMessage::encode, SaveEntryStateMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SendUnlockCodeToClientMessage.class, SendUnlockCodeToClientMessage::encode, SendUnlockCodeToClientMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SendUnlockCodeToServerMessage.class, SendUnlockCodeToServerMessage::encode, SendUnlockCodeToServerMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SyncBookDataMessage.class, SyncBookDataMessage::encode, SyncBookDataMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SyncBookUnlockStatesMessage.class, SyncBookUnlockStatesMessage::encode, SyncBookUnlockStatesMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SyncBookVisualStatesMessage.class, SyncBookVisualStatesMessage::encode, SyncBookVisualStatesMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), SyncMultiblockDataMessage.class, SyncMultiblockDataMessage::encode, SyncMultiblockDataMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), ReloadResourcesOnClientMessage.class, ReloadResourcesOnClientMessage::encode, ReloadResourcesOnClientMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), ReloadResourcesDoneMessage.class, ReloadResourcesDoneMessage::encode, ReloadResourcesDoneMessage::new, MessageHandler::handle);
        INSTANCE.registerMessage(Networking.nextID(), RequestSyncBookStatesMessage.class, RequestSyncBookStatesMessage::encode, RequestSyncBookStatesMessage::new, MessageHandler::handle);
    }

    public static <T> void sendToSplit(ServerPlayer player, T message) {
        Packet vanillaPacket = INSTANCE.toVanillaPacket(message, NetworkDirection.PLAY_TO_CLIENT);
        ArrayList<Packet> packets = new ArrayList<Packet>();
        VanillaPacketSplitter.appendPackets((ConnectionProtocol)ConnectionProtocol.PLAY, (PacketFlow)PacketFlow.CLIENTBOUND, (Packet)vanillaPacket, packets);
        packets.forEach(arg_0 -> ((ServerGamePacketListenerImpl)player.f_8906_).m_9829_(arg_0));
    }

    public static <T> void sendTo(ServerPlayer player, T message) {
        if (player.f_8906_ == null) {
            Modonomicon.LOG.warn("Tried to send message of type {} to player without connection. Id: {}, Name: {}.", new Object[]{player.m_20149_(), player.m_7755_().getString(), message.getClass().getName()});
            return;
        }
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <T> void sendToServer(T message) {
        INSTANCE.sendToServer(message);
    }
}

