/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.core;

import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.modularrouters.block.ModularRouterBlock;
import me.desht.modularrouters.block.TemplateFrameBlock;
import me.desht.modularrouters.core.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"modularrouters");
    public static final DeferredRegister<Item> ITEMS = ModItems.ITEMS;
    private static final BlockBehaviour.Properties ROUTER_PROPS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_();
    private static final BlockBehaviour.Properties TEMPLATE_FRAME_PROPS = BlockBehaviour.Properties.m_284310_().m_60922_((state, world, pos, entityType) -> false).m_60955_();
    public static final RegistryObject<ModularRouterBlock> MODULAR_ROUTER = ModBlocks.register("modular_router", () -> new ModularRouterBlock(ROUTER_PROPS));
    public static final RegistryObject<TemplateFrameBlock> TEMPLATE_FRAME = ModBlocks.registerNoItem("template_frame", () -> new TemplateFrameBlock(TEMPLATE_FRAME_PROPS));

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        return ModBlocks.register(name, sup, ModBlocks::itemDefault);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = ModBlocks.registerNoItem(name, sup);
        ITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> itemDefault(RegistryObject<? extends Block> block) {
        return ModBlocks.item(block);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties());
    }
}

