/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.markers;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MapBlockMarker<D extends CustomMapDecoration> {
    protected final MapDecorationType<D, ?> type;
    @Nullable
    private BlockPos pos;
    private int rot = 0;
    @Nullable
    private Component name;
    private boolean persistent;

    protected MapBlockMarker(MapDecorationType<D, ?> type) {
        this.type = type;
    }

    public void loadFromNBT(CompoundTag compound) {
        this.pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Pos"));
        this.name = compound.m_128441_("Name") ? Component.Serializer.m_130701_((String)compound.m_128461_("Name")) : null;
        this.persistent = compound.m_128471_("Persistent");
    }

    public CompoundTag saveToNBT() {
        CompoundTag compound = new CompoundTag();
        return this.saveToNBT(compound);
    }

    @Deprecated(forRemoval=true)
    public CompoundTag saveToNBT(CompoundTag compound) {
        if (this.pos != null) {
            compound.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        }
        if (this.name != null) {
            compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        }
        if (this.persistent) {
            compound.m_128379_("Persistent", true);
        }
        return compound;
    }

    public boolean shouldRefresh() {
        if (this.persistent) {
            return false;
        }
        return this.type.isFromWorld();
    }

    public boolean shouldSave() {
        return this.persistent || this.type.isFromWorld();
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBlockMarker that = (MapBlockMarker)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.pos, that.pos) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pos, this.name);
    }

    private String getPosSuffix() {
        return this.pos == null ? "" : this.pos.m_123341_() + "," + this.pos.m_123342_() + "," + this.pos.m_123343_();
    }

    public MapDecorationType<D, ?> getType() {
        return this.type;
    }

    public String getTypeId() {
        return Utils.getID(this.type).toString();
    }

    public String getMarkerId() {
        return this.getTypeId() + "-" + this.getPosSuffix();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void setRotation(int rot) {
        this.rot = rot;
    }

    public float getRotation() {
        return this.rot;
    }

    public Component getName() {
        return this.name;
    }

    public void setName(Component name) {
        this.name = name;
    }

    @NotNull
    protected abstract D doCreateDecoration(byte var1, byte var2, byte var3);

    @Nullable
    public D createDecorationFromMarker(MapItemSavedData data) {
        BlockPos pos = this.getPos();
        if (pos == null) {
            return null;
        }
        double worldX = pos.m_123341_();
        double worldZ = pos.m_123343_();
        double rotation = this.getRotation();
        int i = 1 << data.f_77890_;
        float f = (float)(worldX - (double)data.f_256718_) / (float)i;
        float f1 = (float)(worldZ - (double)data.f_256789_) / (float)i;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -64.0f && f1 >= -64.0f && f <= 64.0f && f1 <= 64.0f) {
            byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            return this.doCreateDecoration(mapX, mapY, rot);
        }
        return null;
    }
}

