/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.forge;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.forge.ConfigSpecWrapper;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.core.databuddy.ConfigHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ConfigBuilderImpl
extends ConfigBuilder {
    private final List<ForgeConfigSpec.ConfigValue<?>> requireGameRestart = new ArrayList();
    private boolean currentGameRestart;
    private ForgeConfigSpec.ConfigValue<?> currentValue;
    private final List<SpecialValue<?, ?>> specialValues = new ArrayList();
    private final ForgeConfigSpec.Builder builder;
    private Deque<String> cat = new ArrayDeque<String>();

    public static ConfigBuilder create(ResourceLocation name, ConfigType type) {
        return new ConfigBuilderImpl(name, type);
    }

    public ConfigBuilderImpl(ResourceLocation name, ConfigType type) {
        super(name, type);
        this.builder = new ForgeConfigSpec.Builder();
    }

    @Override
    public String currentCategory() {
        return this.cat.peekFirst();
    }

    @Override
    public ConfigSpecWrapper build() {
        return new ConfigSpecWrapper(this.getName(), this.builder.build(), this.type, this.synced, this.changeCallback, this.requireGameRestart, this.specialValues);
    }

    @Override
    public ConfigBuilderImpl push(String category) {
        this.builder.push(category);
        this.cat.push(category);
        return this;
    }

    @Override
    public ConfigBuilderImpl pop() {
        this.builder.pop();
        this.cat.pop();
        return this;
    }

    @Override
    public java.util.function.Supplier<Boolean> define(String name, boolean defaultValue) {
        ForgeConfigSpec.BooleanValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.define(name, defaultValue);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public java.util.function.Supplier<Double> define(String name, double defaultValue, double min, double max) {
        ForgeConfigSpec.DoubleValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineInRange(name, defaultValue, min, max);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public java.util.function.Supplier<Integer> define(String name, int defaultValue, int min, int max) {
        ForgeConfigSpec.IntValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineInRange(name, defaultValue, min, max);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public java.util.function.Supplier<Integer> defineColor(String name, int defaultValue) {
        ForgeConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        String def = ((JsonElement)ColorUtils.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)defaultValue).result().get()).getAsString();
        this.currentValue = value = this.builder.define(name, (Object)def, o -> {
            String s;
            return o instanceof String && ColorUtils.isValidString(s = (String)o);
        });
        this.maybeAddGameRestart();
        SpecialValue<Integer, String> wrapper = new SpecialValue<Integer, String>(value){

            @Override
            Integer map(String value) {
                return (Integer)((Pair)ColorUtils.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(value)).get().left().get()).getFirst();
            }
        };
        this.specialValues.add(wrapper);
        return wrapper;
    }

    @Override
    public java.util.function.Supplier<String> define(String name, String defaultValue, Predicate<Object> validator) {
        ForgeConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.define(name, (Object)defaultValue, validator);
        this.maybeAddGameRestart();
        return value;
    }

    public <T> java.util.function.Supplier<T> define(String name, java.util.function.Supplier<T> defaultValue, Predicate<Object> validator) {
        ForgeConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.define(name, defaultValue, validator);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public <T extends String> java.util.function.Supplier<List<String>> define(String name, List<? extends T> defaultValue, Predicate<Object> predicate) {
        ForgeConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineList(name, defaultValue, predicate);
        this.maybeAddGameRestart();
        return () -> (List)value.get();
    }

    @Override
    public <T> java.util.function.Supplier<T> defineObject(String name, Supplier<T> defaultSupplier, Codec<T> codec) {
        if (this.usesDataBuddy) {
            return ConfigHelper.defineObject(this.builder, name, codec, defaultSupplier);
        }
        return StringCodecConfigValue.define(this, name, defaultSupplier, codec);
    }

    @Override
    public <T> java.util.function.Supplier<List<T>> defineObjectList(String name, Supplier<List<T>> defaultSupplier, Codec<T> codec) {
        this.builder.comment("This is a list. Add more entries with syntax [[...]]");
        return super.defineObjectList(name, defaultSupplier, codec);
    }

    public StringJsonConfigValue defineJson(String path, JsonElement defaultValue) {
        return StringJsonConfigValue.define(this, path, defaultValue);
    }

    public StringJsonConfigValue defineJson(String path, java.util.function.Supplier<JsonElement> defaultValue) {
        return StringJsonConfigValue.define(this, path, defaultValue);
    }

    @Override
    public <V extends Enum<V>> java.util.function.Supplier<V> define(String name, V defaultValue) {
        ForgeConfigSpec.EnumValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineEnum(name, defaultValue);
        this.maybeAddGameRestart();
        return value;
    }

    private void maybeAddGameRestart() {
        if (this.currentGameRestart && this.currentValue != null) {
            this.requireGameRestart.add(this.currentValue);
            this.currentGameRestart = false;
            this.currentValue = null;
        }
    }

    @Override
    public ConfigBuilder gameRestart() {
        this.currentGameRestart = true;
        return this;
    }

    @Override
    public ConfigBuilder worldReload() {
        this.builder.worldRestart();
        return this;
    }

    @Override
    public ConfigBuilder comment(String comment) {
        this.builder.comment(comment);
        return super.comment(comment);
    }

    @Deprecated(forRemoval=true)
    private static class StringCodecConfigValue<T>
    implements java.util.function.Supplier<T> {
        private final StringJsonConfigValue inner;
        private final Codec<T> codec;
        private T cache;

        public static <T> StringCodecConfigValue<T> define(ConfigBuilderImpl cfg, String name, java.util.function.Supplier<T> defaultValueSupplier, Codec<T> codec) {
            java.util.function.Supplier<JsonElement> jsonSupplier = () -> {
                DataResult e = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, defaultValueSupplier.get());
                Optional json = e.resultOrPartial(s -> {
                    throw new RuntimeException("Invalid default value for config " + name + ": " + s);
                });
                if (json.isEmpty()) {
                    throw new RuntimeException("Invalid default value for config " + name);
                }
                return (JsonElement)json.get();
            };
            java.util.function.Supplier jsonConfig = cfg.defineJson(name, (java.util.function.Supplier)jsonSupplier);
            return new StringCodecConfigValue<T>((StringJsonConfigValue)jsonConfig, codec);
        }

        public StringCodecConfigValue(StringJsonConfigValue jsonConfig, Codec<T> codec) {
            this.inner = jsonConfig;
            this.codec = codec;
        }

        @Override
        public T get() {
            if (this.inner.hasBeenReset()) {
                this.cache = null;
            }
            if (this.cache == null) {
                JsonElement j = this.inner.get();
                DataResult d = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)j);
                Optional o = d.resultOrPartial(s -> {
                    throw new RuntimeException("Failed to decode config: " + s);
                });
                if (o.isEmpty()) {
                    throw new RuntimeException("Failed to parse decode with value" + j);
                }
                return (T)((Pair)o.get()).getFirst();
            }
            return null;
        }
    }

    private static class StringJsonConfigValue
    implements java.util.function.Supplier<JsonElement> {
        private static final Field cachedValue = ObfuscationReflectionHelper.findField(ForgeConfigSpec.ConfigValue.class, (String)"cachedValue");
        private final ForgeConfigSpec.ConfigValue<String> inner;
        private JsonElement cache = null;

        public static StringJsonConfigValue define(ConfigBuilderImpl cfg, String path, java.util.function.Supplier<JsonElement> defaultValueSupplier) {
            Supplier lazyDefaultValue = Suppliers.memoize(defaultValueSupplier::get);
            return new StringJsonConfigValue(cfg.define(path, () -> ((JsonElement)lazyDefaultValue.get()).toString().replace(" ", "").replace("\"", "'"), o -> o != null && ((JsonElement)lazyDefaultValue.get()).getClass().isAssignableFrom(o.getClass())));
        }

        public static StringJsonConfigValue define(ConfigBuilderImpl cfg, String path, JsonElement defaultValue) {
            return new StringJsonConfigValue(cfg.define(path, defaultValue.toString().replace(" ", "").replace("\"", "'")));
        }

        StringJsonConfigValue(java.util.function.Supplier<String> innerConfig) {
            this.inner = (ForgeConfigSpec.ConfigValue)innerConfig;
        }

        @Override
        public JsonElement get() {
            if (this.hasBeenReset()) {
                this.cache = null;
            }
            if (this.cache == null) {
                String s = ((String)this.inner.get()).replace("'", "\"");
                try {
                    this.cache = JsonParser.parseString((String)s);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse json config: ", e);
                }
            }
            return this.cache;
        }

        public boolean hasBeenReset() {
            try {
                return cachedValue.get(this.inner) == null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            cachedValue.setAccessible(true);
        }
    }

    abstract class SpecialValue<T, C>
    implements java.util.function.Supplier<T> {
        private final ForgeConfigSpec.ConfigValue<C> original;
        private T cachedValue = null;

        SpecialValue(ForgeConfigSpec.ConfigValue<C> original) {
            this.original = original;
        }

        abstract T map(C var1);

        public void clearCache() {
            this.cachedValue = null;
        }

        @Override
        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.map(this.original.get());
            }
            return this.cachedValue;
        }
    }
}

