/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IHoldingPlayerExtension;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapItemSavedData.HoldingPlayer.class})
public abstract class HoldingPlayerMixin
implements IHoldingPlayerExtension {
    @Unique
    private final ReentrantLock moonlight$concurrentLock = new ReentrantLock();
    @Unique
    private final Map<CustomMapData.Type<?>, CustomMapData.DirtyCounter> moonlight$customDataDirty = new IdentityHashMap();
    @Unique
    private boolean moonlight$customMarkersDirty = true;
    @Unique
    private int moonlight$dirtyDecorationTicks = 0;
    @Unique
    private int moonlight$volatileDecorationRefreshTicks = 0;
    @Final
    @Shadow
    MapItemSavedData f_77961_;
    @Shadow
    @Final
    public Player f_77959_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initializeDirty(MapItemSavedData mapItemSavedData, Player player, CallbackInfo ci) {
        this.moonlight$customMarkersDirty = true;
        for (CustomMapData<?> v : ((ExpandedMapData)mapItemSavedData).getCustomData().values()) {
            this.moonlight$customDataDirty.put(v.getType(), (CustomMapData.DirtyCounter)v.createDirtyCounter());
        }
    }

    @Inject(method={"nextUpdatePacket"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkLocked(int mapId, CallbackInfoReturnable<@Nullable Packet<?>> cir) {
        if (this.moonlight$concurrentLock.isLocked()) {
            cir.setReturnValue(null);
        }
    }

    @ModifyReturnValue(method={"nextUpdatePacket"}, at={@At(value="TAIL")})
    public Packet<?> addExtraPacketData(@Nullable Packet<?> packet, int mapId) {
        MapItemSavedData data = this.f_77961_;
        ExpandedMapData ed = (ExpandedMapData)data;
        boolean updateData = false;
        boolean updateDeco = false;
        ArrayList dirtyData = new ArrayList();
        for (Map.Entry<CustomMapData.Type<?>, CustomMapData.DirtyCounter> e : this.moonlight$customDataDirty.entrySet()) {
            CustomMapData.DirtyCounter dirtyCounter = e.getValue();
            if (!dirtyCounter.isDirty()) continue;
            dirtyData.add(e);
            updateData = true;
        }
        if (this.moonlight$customMarkersDirty && this.moonlight$dirtyDecorationTicks++ % 5 == 0) {
            this.moonlight$customMarkersDirty = false;
            updateDeco = true;
        }
        ArrayList extra = new ArrayList();
        if (this.moonlight$volatileDecorationRefreshTicks++ % 100 == 0 || updateDeco) {
            for (MapBlockMarker mapBlockMarker : MapDataInternal.getDynamicServer(this.f_77959_, mapId, data)) {
                Object d = mapBlockMarker.createDecorationFromMarker(data);
                if (d == null) continue;
                extra.add(d);
            }
            updateDeco = true;
        }
        if (updateData || updateDeco) {
            if (packet == null) {
                packet = new ClientboundMapItemDataPacket(mapId, this.f_77961_.f_77890_, this.f_77961_.f_77892_, null, null);
            }
            IMapDataPacketExtension ep = (IMapDataPacketExtension)packet;
            if (updateData) {
                CompoundTag compoundTag = new CompoundTag();
                for (Map.Entry entry : dirtyData) {
                    HoldingPlayerMixin.saveDataToUpdateTag(ed, compoundTag, entry);
                    ((CustomMapData.DirtyCounter)entry.getValue()).clearDirty();
                }
                ep.moonlight$sendCustomMapDataTag(compoundTag);
            }
            if (updateDeco) {
                ArrayList<CustomMapDecoration> arrayList = new ArrayList<CustomMapDecoration>(ed.getCustomDecorations().values());
                arrayList.addAll(extra);
                ep.moonlight$sendCustomDecorations(arrayList);
            }
        }
        return packet;
    }

    @Unique
    private static <C extends CustomMapData.DirtyCounter, D extends CustomMapData<C>> void saveDataToUpdateTag(ExpandedMapData ed, CompoundTag customDataTag, Map.Entry<CustomMapData.Type<?>, CustomMapData.DirtyCounter> e) {
        CustomMapData<?> d = ed.getCustomData().get(e.getKey().id());
        CustomMapData.DirtyCounter value = e.getValue();
        d.saveToUpdateTag(customDataTag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <H extends CustomMapData.DirtyCounter> void moonlight$setCustomDataDirty(CustomMapData.Type<?> type, Consumer<H> dirtySetter) {
        try {
            this.moonlight$concurrentLock.lock();
            CustomMapData.DirtyCounter t = this.moonlight$customDataDirty.get(type);
            dirtySetter.accept(t);
        }
        finally {
            this.moonlight$concurrentLock.unlock();
        }
    }

    @Override
    public void moonlight$setCustomMarkersDirty() {
        this.moonlight$customMarkersDirty = true;
    }

    @Inject(method={"markColorsDirty"}, at={@At(value="HEAD")})
    public void lockData(int x, int z, CallbackInfo ci) {
        this.moonlight$concurrentLock.lock();
    }

    @Inject(method={"markColorsDirty"}, at={@At(value="RETURN")})
    public void sanityCheck(int x, int z, CallbackInfo ci) {
        this.moonlight$concurrentLock.unlock();
    }
}

