/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.jetbrains.annotations.Nullable;

public class WoodTypeRegistry
extends BlockTypeRegistry<WoodType> {
    public static final WoodType OAK_TYPE = new WoodType(new ResourceLocation("oak"), Blocks.f_50705_, Blocks.f_49999_);
    public static final WoodTypeRegistry INSTANCE = new WoodTypeRegistry();
    Map<net.minecraft.world.level.block.state.properties.WoodType, WoodType> fromVanilla = new IdentityHashMap<net.minecraft.world.level.block.state.properties.WoodType, WoodType>();
    public static Set<String> IGNORED_MODS = new HashSet<String>(Set.of("chipped", "securitycraft", "absentbydesign"));
    private static final List<net.minecraft.world.level.block.state.properties.WoodType> VANILLA_ORDER = List.of(net.minecraft.world.level.block.state.properties.WoodType.f_61830_, net.minecraft.world.level.block.state.properties.WoodType.f_61831_, net.minecraft.world.level.block.state.properties.WoodType.f_61832_, net.minecraft.world.level.block.state.properties.WoodType.f_61834_, net.minecraft.world.level.block.state.properties.WoodType.f_61833_, net.minecraft.world.level.block.state.properties.WoodType.f_61835_, net.minecraft.world.level.block.state.properties.WoodType.f_223002_, net.minecraft.world.level.block.state.properties.WoodType.f_271224_, net.minecraft.world.level.block.state.properties.WoodType.f_244200_, net.minecraft.world.level.block.state.properties.WoodType.f_61836_, net.minecraft.world.level.block.state.properties.WoodType.f_61837_);

    public static Collection<WoodType> getTypes() {
        return INSTANCE.getValues();
    }

    @Nullable
    public static WoodType getValue(ResourceLocation name) {
        return (WoodType)INSTANCE.get(name);
    }

    public static WoodType fromNBT(String name) {
        return (WoodType)INSTANCE.getFromNBT(name);
    }

    public static WoodType fromVanilla(net.minecraft.world.level.block.state.properties.WoodType vanillaType) {
        return INSTANCE.getFromVanilla(vanillaType);
    }

    public WoodTypeRegistry() {
        super(WoodType.class, "wood_type");
        this.addFinder(() -> {
            WoodType b = new WoodType(new ResourceLocation("bamboo"), Blocks.f_244477_, Blocks.f_256831_);
            b.addChild("stripped_log", Blocks.f_256740_);
            return Optional.of(b);
        });
    }

    @Override
    public WoodType getDefaultType() {
        return OAK_TYPE;
    }

    @Override
    public Optional<WoodType> detectTypeFromBlock(Block baseBlock, ResourceLocation baseRes) {
        BlockState state;
        String name = null;
        String path = baseRes.m_135815_();
        if (baseRes.m_135827_().equals("tfc") || baseRes.m_135827_().equals("afc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(baseRes.m_135827_(), path.replace("planks", "log")))).isPresent()) {
                ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), path.replace("wood/planks/", ""));
                return Optional.of(new WoodType(id, baseBlock, (Block)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = baseRes.m_135827_();
        if (name != null && !IGNORED_MODS.contains(namespace) && (state = baseBlock.m_49966_()).m_61147_().size() <= 2 && !(baseBlock instanceof SlabBlock) && state.m_280603_() == NoteBlockInstrument.BASS) {
            name = name.replace("/", "_");
            ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), name);
            Block logBlock = WoodTypeRegistry.findLog(id);
            if (logBlock != null) {
                return Optional.of(new WoodType(id, baseBlock, logBlock));
            }
        }
        return Optional.empty();
    }

    @Nullable
    private static Block findLog(ResourceLocation id) {
        List<String> keywords = List.of("log", "stem", "stalk", "hyphae");
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        for (String keyword : keywords) {
            resources.add(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + keyword));
            resources.add(new ResourceLocation(id.m_135827_(), keyword + "_" + id.m_135815_()));
            resources.add(new ResourceLocation(id.m_135815_() + "_" + keyword));
            resources.add(new ResourceLocation(keyword + "_" + id.m_135815_()));
        }
        ResourceLocation[] test = resources.toArray(new ResourceLocation[0]);
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!BuiltInRegistries.f_256975_.m_7804_(r)) continue;
            temp = (Block)BuiltInRegistries.f_256975_.m_7745_(r);
            break;
        }
        return temp;
    }

    @Override
    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(w -> {
            if (language.isDefault()) {
                language.addEntry(w.getTranslationKey(), w.getReadableName());
            }
        });
    }

    @Nullable
    public WoodType getFromVanilla(net.minecraft.world.level.block.state.properties.WoodType woodType) {
        return this.fromVanilla.get(woodType);
    }

    void mapVanillaWood(WoodType woodType) {
        net.minecraft.world.level.block.state.properties.WoodType v = woodType.toVanilla();
        if (v != null) {
            this.fromVanilla.put(v, woodType);
        }
    }

    @Override
    protected void finalizeAndFreeze() {
        ArrayList temp = new ArrayList(this.builder);
        this.builder.clear();
        block0: for (net.minecraft.world.level.block.state.properties.WoodType v : VANILLA_ORDER) {
            for (WoodType t : temp) {
                if (t.toVanilla() != v) continue;
                this.builder.add(t);
                temp.remove(t);
                continue block0;
            }
        }
        this.builder.addAll(temp);
        super.finalizeAndFreeze();
    }
}

