/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.structure;

import dev.latvian.mods.kubejs.level.LevelEventJS;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.phys.AABB;

public class StructureAfterPlaceEventJS
extends LevelEventJS {
    private final Structure structure;
    private final WorldGenLevel worldGenLevel;
    private final StructureManager structureManager;
    private final ChunkGenerator chunkGenerator;
    private final RandomSource randomSource;
    private final BoundingBox boundingBox;
    private final ChunkPos chunkPos;
    private final PiecesContainer piecesContainer;
    private Map<StructurePiece, BoundingBox> intersectionMap;

    public StructureAfterPlaceEventJS(Structure structure, WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        this.structure = structure;
        this.worldGenLevel = worldGenLevel;
        this.structureManager = structureManager;
        this.chunkGenerator = chunkGenerator;
        this.randomSource = randomSource;
        this.boundingBox = boundingBox;
        this.chunkPos = chunkPos;
        this.piecesContainer = piecesContainer;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    public ChunkGenerator getChunkGenerator() {
        return this.chunkGenerator;
    }

    public RandomSource getRandomSource() {
        return this.randomSource;
    }

    public BoundingBox getChunkBoundingBox() {
        return this.boundingBox;
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public PiecesContainer getPiecesContainer() {
        return this.piecesContainer;
    }

    public BoundingBox getStructureBoundingBox() {
        return this.piecesContainer.m_192756_();
    }

    public ServerLevel getLevel() {
        return this.worldGenLevel.m_6018_();
    }

    public WorldGenLevel getWorldGenLevel() {
        return this.worldGenLevel;
    }

    public ResourceLocation getPieceType(StructurePieceType pieceType) {
        return Objects.requireNonNull(BuiltInRegistries.f_257014_.m_7981_((Object)pieceType));
    }

    public ResourceLocation getId() {
        return Objects.requireNonNull(this.structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7981_((Object)this.structure));
    }

    public String getGenStep() {
        return this.structure.m_226619_().m_224194_();
    }

    public Collection<BoundingBox> getIntersectionBoxes() {
        return this.getIntersectionMap().values();
    }

    public Collection<StructurePiece> getIntersectionPieces() {
        return this.getIntersectionMap().keySet();
    }

    public Map<StructurePiece, BoundingBox> getIntersectionMap() {
        if (this.intersectionMap == null) {
            HashMap<StructurePiece, BoundingBox> map = new HashMap<StructurePiece, BoundingBox>();
            for (StructurePiece sp : this.piecesContainer.f_192741_()) {
                if (!this.boundingBox.m_71049_(sp.m_73547_())) continue;
                AABB aabb = AABB.m_82321_((BoundingBox)this.boundingBox).m_82323_(AABB.m_82321_((BoundingBox)sp.m_73547_()));
                BoundingBox bb = new BoundingBox((int)aabb.f_82288_, (int)aabb.f_82289_, (int)aabb.f_82290_, (int)aabb.f_82291_ - 1, (int)aabb.f_82292_ - 1, (int)aabb.f_82293_ - 1);
                map.put(sp, bb);
            }
            this.intersectionMap = map;
        }
        return this.intersectionMap;
    }

    public ResourceLocation getType() {
        return Objects.requireNonNull(BuiltInRegistries.f_256763_.m_7981_((Object)this.structure.m_213658_()));
    }
}

