/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui.config;

import at.ridgo8.moreoverlays.gui.config.ConfigOptionList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class OptionValueEntry<V>
extends ConfigOptionList.OptionEntry {
    public static final int CONTROL_WIDTH_NOVALIDATOR = 44;
    public static final int CONTROL_WIDTH_VALIDATOR = 64;
    public static final int TITLE_WIDTH = 80;
    protected final ForgeConfigSpec.ConfigValue<V> value;
    protected final ForgeConfigSpec.ValueSpec spec;
    private final List<String> tooltip;
    protected Button btnReset;
    protected Button btnUndo;
    protected V defaultValue;
    protected V newValue;
    protected boolean showValidity = false;
    private String txtUndo = "";
    private String txtReset = "";
    private String name = "";
    private boolean valid = false;
    private boolean changes = false;

    public OptionValueEntry(ConfigOptionList list, ForgeConfigSpec.ConfigValue<V> confValue, ForgeConfigSpec.ValueSpec spec) {
        super(list);
        this.value = confValue;
        this.spec = spec;
        this.btnReset = new Button.Builder(Component.m_130674_((String)"\u2604"), btn -> this.reset()).m_252794_(list.m_5759_() - 20, 0).m_253046_(20, 20).m_253136_();
        this.btnUndo = new Button.Builder(Component.m_130674_((String)"\u21b6"), btn -> this.undo()).m_252794_(list.m_5759_() - 42, 0).m_253046_(20, 20).m_253136_();
        this.txtReset = I18n.m_118938_((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.m_118938_((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        Object defaultVal = this.spec.getDefault();
        if (defaultVal != null && spec.getClazz().isAssignableFrom(defaultVal.getClass())) {
            this.defaultValue = defaultVal;
        } else {
            this.btnReset.f_93623_ = false;
        }
        this.name = (String)this.value.getPath().get(this.value.getPath().size() - 1);
        String[] lines = null;
        if (this.spec.getComment() != null) {
            lines = this.spec.getComment().split("\\n");
            this.tooltip = new ArrayList<String>(lines.length + 1);
        } else {
            this.tooltip = new ArrayList<String>(1);
        }
        this.tooltip.add(ChatFormatting.RED + this.name);
        for (String line : lines) {
            this.tooltip.add(ChatFormatting.YELLOW + line);
        }
        this.updateValue(this.value.get());
    }

    @Override
    protected void renderControls(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, this.name, -20, 6, 0xFFFFFF);
        this.btnReset.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.btnUndo.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.showValidity) {
            if (this.valid) {
                guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, "\u2714", this.getConfigOptionList().m_5759_() - 53, 6, 65280);
            } else {
                guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, "\u2715", this.getConfigOptionList().m_5759_() - 53, 6, 0xFF0000);
            }
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY);
        ArrayList<Component> tooltipConverted = new ArrayList<Component>();
        for (String iTextComponent : this.tooltip) {
            tooltipConverted.add(Component.m_130674_((String)iTextComponent));
        }
        if (this.btnReset.m_198029_()) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, Component.m_130674_((String)this.txtReset), mouseX, mouseY);
        } else if (this.btnUndo.m_198029_()) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, Component.m_130674_((String)this.txtUndo), mouseX, mouseY);
        } else if (mouseX < 80 + rowLeft) {
            guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, tooltipConverted, mouseX, mouseY);
        }
        Lighting.m_84930_();
        GlStateManager._disableBlend();
    }

    protected abstract void overrideUnsaved(V var1);

    protected boolean isUndoable(V current) {
        return current == null || !current.equals(this.value.get()) || !this.valid;
    }

    protected void updateValue(@Nullable V value) {
        this.valid = value != null && this.spec.test(value);
        this.btnReset.f_93623_ = this.isResettable();
        this.btnUndo.f_93623_ = this.changes = this.isUndoable(value);
        this.newValue = value;
    }

    @Override
    public void undo() {
        this.overrideUnsaved(this.value.get());
        this.updateValue(this.value.get());
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            this.value.set(this.defaultValue);
            this.overrideUnsaved(this.defaultValue);
            this.updateValue(this.defaultValue);
        }
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return Arrays.asList(this.btnReset, this.btnUndo);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean hasChanges() {
        return this.changes;
    }

    @Override
    public boolean isResettable() {
        return this.defaultValue != null && (this.value.get() == null || !this.value.get().equals(this.defaultValue));
    }

    @Override
    public void save() {
        this.value.set(this.newValue);
        this.value.save();
    }
}

