/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.InputSide;
import commoble.morered.plate_blocks.InputState;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.plate_blocks.RedstonePlateBlock;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LatchBlock
extends RedstonePlateBlock {
    public static final DirectionProperty ATTACHMENT_DIRECTION = PlateBlockStateProperties.ATTACHMENT_DIRECTION;
    public static final IntegerProperty ROTATION = PlateBlockStateProperties.ROTATION;
    public static final BooleanProperty INPUT_A = PlateBlockStateProperties.INPUT_A;
    public static final BooleanProperty INPUT_C = PlateBlockStateProperties.INPUT_C;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final InputSide[] INPUT_SIDES = new InputSide[]{InputSide.A, InputSide.C};
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;

    public LatchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState baseState = this.m_49966_();
        this.m_49959_((BlockState)((BlockState)((BlockState)baseState.m_61124_((Property)INPUT_A, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INPUT_C, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{INPUT_A, INPUT_C, POWERED});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (((Boolean)state.m_61143_((Property)INPUT_C)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Deprecated
    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction sideOfAdjacentBlock) {
        if (((Boolean)state.m_61143_((Property)INPUT_A)).booleanValue() && ((Boolean)state.m_61143_((Property)INPUT_C)).booleanValue()) {
            return 0;
        }
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        Direction outputDirectionWhenPowered = PlateBlockStateProperties.getOutputDirection(state);
        return powered && sideOfAdjacentBlock == outputDirectionWhenPowered.m_122424_() || !powered && sideOfAdjacentBlock == outputDirectionWhenPowered ? 15 : 0;
    }

    public void m_213897_(BlockState oldBlockState, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockState stateWithNewInput = InputState.getUpdatedBlockState((Level)level, oldBlockState, pos);
        InputState newInputState = InputState.getWorldPowerState((Level)level, stateWithNewInput, pos);
        boolean wasPowered = (Boolean)oldBlockState.m_61143_((Property)POWERED);
        boolean isPowered = wasPowered && !newInputState.c || !wasPowered && newInputState.a;
        BlockState newBlockState = (BlockState)stateWithNewInput.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered));
        if (newBlockState != oldBlockState) {
            level.m_7731_(pos, newBlockState, 2);
        }
    }

    @Override
    public InputSide[] getInputSides() {
        return INPUT_SIDES;
    }

    @Override
    public EnumSet<Direction> getOutputSides(Level level, BlockPos pos, BlockState state) {
        Direction primaryDirection = PlateBlockStateProperties.getOutputDirection(state);
        Direction oppositeDirection = primaryDirection.m_122424_();
        return EnumSet.of(primaryDirection, oppositeDirection);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return super.canConnectRedstone(state, world, pos, side) || side != null && side == PlateBlockStateProperties.getOutputDirection(state);
    }
}

