/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import commoble.morered.wires.AbstractWireBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public enum Edge {
    DOWN_NORTH(Direction.DOWN, Direction.NORTH),
    DOWN_SOUTH(Direction.DOWN, Direction.SOUTH),
    DOWN_WEST(Direction.DOWN, Direction.WEST),
    DOWN_EAST(Direction.DOWN, Direction.EAST),
    UP_NORTH(Direction.UP, Direction.NORTH),
    UP_SOUTH(Direction.UP, Direction.SOUTH),
    UP_WEST(Direction.UP, Direction.WEST),
    UP_EAST(Direction.UP, Direction.EAST),
    NORTH_WEST(Direction.NORTH, Direction.WEST),
    NORTH_EAST(Direction.NORTH, Direction.EAST),
    SOUTH_WEST(Direction.SOUTH, Direction.WEST),
    SOUTH_EAST(Direction.SOUTH, Direction.EAST);

    public static final Edge[][] EDGES_BY_RELEVANT_DIRECTION;
    public final Direction sideA;
    public final Direction sideB;

    private Edge(Direction sideA, Direction sideB) {
        this.sideA = sideA;
        this.sideB = sideB;
    }

    public boolean shouldEdgeRender(BlockGetter world, BlockPos pos, AbstractWireBlock centerWireBlock) {
        BooleanProperty propB = AbstractWireBlock.INTERIOR_FACES[this.sideB.ordinal()];
        BlockState neighborStateA = world.m_8055_(pos.m_121945_(this.sideA));
        if (neighborStateA.m_60734_() == centerWireBlock && ((Boolean)neighborStateA.m_61143_((Property)propB)).booleanValue()) {
            BooleanProperty propA = AbstractWireBlock.INTERIOR_FACES[this.sideA.ordinal()];
            BlockState neighborStateB = world.m_8055_(pos.m_121945_(this.sideB));
            return neighborStateB.m_60734_() == centerWireBlock && (Boolean)neighborStateB.m_61143_((Property)propA) != false;
        }
        return false;
    }

    static {
        EDGES_BY_RELEVANT_DIRECTION = new Edge[][]{{DOWN_NORTH, DOWN_SOUTH, DOWN_WEST, DOWN_EAST}, {UP_NORTH, UP_SOUTH, UP_WEST, UP_EAST}, {DOWN_NORTH, UP_NORTH, NORTH_WEST, NORTH_EAST}, {DOWN_SOUTH, UP_SOUTH, SOUTH_WEST, SOUTH_EAST}, {DOWN_WEST, UP_WEST, NORTH_WEST, SOUTH_WEST}, {DOWN_EAST, UP_EAST, NORTH_EAST, SOUTH_EAST}};
    }
}

