/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Lizard;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class LizardModel
extends GeoModel<Lizard> {
    public static final ResourceLocation[] TEXTURE_LOCATIONS = new ResourceLocation[]{new ResourceLocation("naturalist", "textures/entity/lizard/green.png"), new ResourceLocation("naturalist", "textures/entity/lizard/brown.png"), new ResourceLocation("naturalist", "textures/entity/lizard/beardie.png"), new ResourceLocation("naturalist", "textures/entity/lizard/leopard_gecko.png")};

    public ResourceLocation getModelResource(Lizard lizard) {
        return new ResourceLocation("naturalist", "geo/lizard.geo.json");
    }

    public ResourceLocation getTextureResource(Lizard lizard) {
        return TEXTURE_LOCATIONS[Math.min(lizard.getVariant(), TEXTURE_LOCATIONS.length - 1)];
    }

    public ResourceLocation getAnimationResource(Lizard lizard) {
        return new ResourceLocation("naturalist", "animations/lizard.animation.json");
    }

    public void setCustomAnimations(Lizard animatable, long instanceId, AnimationState<Lizard> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone tail = this.getAnimationProcessor().getBone("tail");
        CoreGeoBone basiliskBody = this.getAnimationProcessor().getBone("basilisk_body");
        CoreGeoBone basiliskTail = this.getAnimationProcessor().getBone("basilisk_tail");
        CoreGeoBone beardieHead = this.getAnimationProcessor().getBone("beardie_head");
        CoreGeoBone beardieBody = this.getAnimationProcessor().getBone("beardie_body");
        CoreGeoBone gecko = this.getAnimationProcessor().getBone("gecko");
        head.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
        tail.setHidden(!animatable.hasTail());
    }
}

