/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.CthulhuFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;

public class BeaverFamiliarEntity
extends FamiliarEntity {
    private final WaterBoundPathNavigation waterNavigator;
    private final GroundPathNavigation groundNavigator;
    private BlockPos treeTarget;

    public BeaverFamiliarEntity(EntityType<? extends BeaverFamiliarEntity> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigator = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigator = new GroundPathNavigation((Mob)this, level);
        this.f_21342_ = new CthulhuFamiliarEntity.MoveController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.m_21552_().m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_20069_()) {
                this.f_21344_ = this.waterNavigator;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigator;
                this.m_20282_(false);
            }
        }
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasBigTail()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new ChopTreeGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new CthulhuFamiliarEntity.FollowOwnerWaterGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setBigTail(this.m_217043_().m_188500_() < 0.1);
        this.setEars(this.m_217043_().m_188499_());
        this.setWhiskers(this.m_217043_().m_188499_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean hasWhiskers() {
        return this.hasVariant(0);
    }

    private void setWhiskers(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasEars() {
        return this.hasVariant(1);
    }

    private void setEars(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasBigTail() {
        return this.hasVariant(2);
    }

    private void setBigTail(boolean b) {
        this.setVariant(2, b);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance((MobEffect)OccultismEffects.BEAVER_HARVEST.get(), 300));
    }

    public void setTreeTarget(BlockPos pos) {
        this.treeTarget = pos;
    }

    private static class ChopTreeGoal
    extends Goal {
        private final BeaverFamiliarEntity beaver;

        private ChopTreeGoal(BeaverFamiliarEntity beaver) {
            this.beaver = beaver;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.beaver.isSitting() && this.beaver.isEffectEnabled(this.beaver.getFamiliarOwner()) && this.beaver.treeTarget != null && this.beaver.m_9236_().m_8055_(this.beaver.treeTarget).m_204336_(BlockTags.f_13106_);
        }

        public void m_8056_() {
            if (this.beaver.treeTarget == null) {
                return;
            }
            this.beaver.m_21573_().m_26519_((double)this.beaver.treeTarget.m_123341_(), (double)this.beaver.treeTarget.m_123342_(), (double)this.beaver.treeTarget.m_123343_(), 1.0);
        }

        public void m_8037_() {
            if (this.beaver.treeTarget == null) {
                return;
            }
            if (this.beaver.m_20275_(this.beaver.treeTarget.m_123341_(), this.beaver.treeTarget.m_123342_(), this.beaver.treeTarget.m_123343_()) > 4.0) {
                this.beaver.m_21573_().m_26519_((double)this.beaver.treeTarget.m_123341_(), (double)this.beaver.treeTarget.m_123342_(), (double)this.beaver.treeTarget.m_123343_(), 1.0);
            } else {
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                HashSet<BlockPos> harvesting = new HashSet<BlockPos>();
                positions.add(this.beaver.treeTarget);
                while (!positions.isEmpty() && harvesting.size() < 15) {
                    BlockPos pos = (BlockPos)positions.pop();
                    harvesting.add(pos);
                    for (BlockPos p : BlockPos.m_121925_((BlockPos)pos, (int)1, (int)1, (int)1)) {
                        if (harvesting.contains(p) || !this.beaver.m_9236_().m_8055_(p).m_204336_(BlockTags.f_13106_)) continue;
                        positions.add(p.m_7949_());
                        harvesting.add(pos);
                    }
                }
                if (!positions.isEmpty()) {
                    this.beaver.treeTarget = null;
                    return;
                }
                for (BlockPos p : harvesting) {
                    this.beaver.m_9236_().m_46961_(p, true);
                }
                this.beaver.treeTarget = null;
                OccultismAdvancements.FAMILIAR.trigger(this.beaver.getFamiliarOwner(), FamiliarTrigger.Type.BEAVER_WOODCHOP);
            }
        }
    }
}

