/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.klikli_dev.occultism.crafting.recipe.TieredItemStackFakeInventory;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;

public class CrusherJob
extends SpiritJob {
    public static final String DROPPED_BY_CRUSHER = "occultism:dropped_by_crusher";
    protected int crushingTimer;
    protected Supplier<Float> crushingTimeMultiplier;
    protected Supplier<Float> outputMultiplier;
    protected Supplier<Integer> tier;
    protected Optional<CrushingRecipe> currentRecipe = Optional.empty();
    protected PickupItemsGoal pickupItemsGoal;
    protected List<Ingredient> itemsToPickUp = new ArrayList<Ingredient>();

    public CrusherJob(SpiritEntity entity, Supplier<Float> crushingTimeMultiplier, Supplier<Float> outputMultiplier, Supplier<Integer> tier) {
        super(entity);
        this.crushingTimeMultiplier = crushingTimeMultiplier;
        this.outputMultiplier = outputMultiplier;
        this.tier = tier;
    }

    @Override
    public void onInit() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.f_21346_.m_25352_(1, (Goal)this.pickupItemsGoal);
        this.itemsToPickUp = this.entity.m_9236_().m_7465_().m_44051_().stream().filter(recipe -> recipe.m_6671_() == OccultismRecipes.CRUSHING_TYPE.get() && ((CrushingRecipe)recipe).getMinTier() <= this.tier.get()).flatMap(recipe -> recipe.m_7527_().stream()).collect(Collectors.toList());
    }

    @Override
    public void cleanup() {
        this.entity.f_21346_.m_25363_((Goal)this.pickupItemsGoal);
    }

    @Override
    public void update() {
        ItemStack handHeld = this.entity.m_21120_(InteractionHand.MAIN_HAND);
        TieredItemStackFakeInventory fakeInventory = new TieredItemStackFakeInventory(handHeld, this.tier.get());
        if (!this.currentRecipe.isPresent() && !handHeld.m_41619_()) {
            this.currentRecipe = this.entity.m_9236_().m_7465_().m_44015_((RecipeType)OccultismRecipes.CRUSHING_TYPE.get(), (Container)fakeInventory, this.entity.m_9236_());
            this.crushingTimer = 0;
            if (this.currentRecipe.isPresent()) {
                this.entity.m_9236_().m_5594_(null, this.entity.m_20183_(), (SoundEvent)OccultismSounds.CRUNCHING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.m_217043_().m_188501_());
            } else {
                this.entity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                ItemEntity droppedItem = this.entity.m_19983_(handHeld);
                if (droppedItem != null) {
                    droppedItem.m_20049_(DROPPED_BY_CRUSHER);
                }
            }
        }
        if (this.currentRecipe.isPresent()) {
            if (handHeld.m_41619_() || !this.currentRecipe.get().matches(fakeInventory, this.entity.m_9236_())) {
                this.currentRecipe = Optional.empty();
            } else {
                ++this.crushingTimer;
                if (this.entity.m_9236_().m_46467_() % 10L == 0L) {
                    Vec3 pos = this.entity.m_20182_();
                    ((ServerLevel)this.entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_ + this.entity.m_9236_().f_46441_.m_188583_() / 3.0, pos.f_82480_ + 0.5, pos.f_82481_ + this.entity.m_9236_().f_46441_.m_188583_() / 3.0, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.crushingTimer % 40 == 0) {
                    this.entity.m_9236_().m_5594_(null, this.entity.m_20183_(), (SoundEvent)OccultismSounds.CRUNCHING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + 0.5f * this.entity.m_217043_().m_188501_());
                }
                if ((float)this.crushingTimer >= (float)this.currentRecipe.get().getCrushingTime() * this.crushingTimeMultiplier.get().floatValue()) {
                    this.crushingTimer = 0;
                    ItemStack result = this.currentRecipe.get().assemble(fakeInventory, this.entity.m_9236_().m_9598_());
                    float outputMultiplier = this.outputMultiplier.get().floatValue();
                    if (this.currentRecipe.get().getIgnoreCrushingMultiplier()) {
                        outputMultiplier = 1.0f;
                    }
                    result.m_41764_((int)((float)result.m_41613_() * outputMultiplier));
                    ItemStack inputCopy = handHeld.m_41777_();
                    inputCopy.m_41764_(1);
                    handHeld.m_41774_(1);
                    this.onCrush(inputCopy, result);
                    ItemEntity droppedItem = this.entity.m_19983_(result);
                    if (droppedItem != null) {
                        droppedItem.m_20049_(DROPPED_BY_CRUSHER);
                    }
                }
            }
        }
        super.update();
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound) {
        compound.m_128405_("conversionTimer", this.crushingTimer);
        return super.writeJobToNBT(compound);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound) {
        super.readJobFromNBT(compound);
        this.crushingTimer = compound.m_128451_("conversionTimer");
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        if (entity.m_19880_().contains(DROPPED_BY_CRUSHER) && entity.m_32059_() < (Integer)Occultism.SERVER_CONFIG.spiritJobs.crusherResultPickupDelay.get()) {
            return false;
        }
        ItemStack stack = entity.m_32055_();
        return !stack.m_41619_() && this.itemsToPickUp.stream().anyMatch(i -> i.test(stack));
    }

    @Override
    public List<Ingredient> getItemsToPickUp() {
        return this.itemsToPickUp;
    }

    public void onCrush(ItemStack input, ItemStack output) {
    }
}

