/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class MinerRecipeProvider
implements DataProvider {
    protected final PackOutput.PathProvider recipePathProvider;

    public MinerRecipeProvider(PackOutput packOutput) {
        this.recipePathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "recipes/miner");
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.buildRecipes(recipe -> {
            if (!set.add((ResourceLocation)recipe.getFirst())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.getFirst());
            }
            list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)((JsonElement)recipe.getSecond()), (Path)this.recipePathProvider.m_245731_((ResourceLocation)recipe.getFirst())));
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected ResourceLocation modLoc(String path) {
        return new ResourceLocation("occultism", path);
    }

    protected ResourceLocation loc(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    protected void buildRecipes(Consumer<Pair<ResourceLocation, JsonObject>> recipes) {
        this.buildForbiddenArcanusRecipes(recipes);
    }

    protected void buildForbiddenArcanusRecipes(Consumer<Pair<ResourceLocation, JsonObject>> recipes) {
        recipes.accept(this.buildMinerRecipe(this.modLoc("ores/runic_stone"), this.modLoc("miners/ores"), this.loc("forbidden_arcanus", "runic_stones"), 200));
        recipes.accept(this.buildMinerRecipe(this.modLoc("master/stella_arcanum"), this.modLoc("miners/master"), this.loc("forge", "ores/stella_arcanum"), 100));
        recipes.accept(this.buildMinerRecipe(this.modLoc("ores/arcane_crystal"), this.modLoc("miners/ores"), this.loc("forge", "ores/arcane_crystal"), 200));
        recipes.accept(this.buildMinerRecipe(this.modLoc("ores/xpetrified"), this.modLoc("miners/ores"), this.loc("forge", "ores/xpetrified_ore"), 200));
    }

    protected Pair<ResourceLocation, JsonObject> buildMinerRecipe(ResourceLocation name, ResourceLocation minerTag, ResourceLocation outputTag, int weight) {
        JsonObject recipe = this.buildMinerRecipeJson(minerTag.toString(), outputTag.toString(), weight);
        return new Pair((Object)name, (Object)recipe);
    }

    public JsonObject buildMinerRecipeJson(String minerTag, String outputTag, int weight) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "occultism:miner");
        JsonArray conditions = this.buildMinerRecipeConditionJson(outputTag);
        recipe.add("conditions", (JsonElement)conditions);
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("tag", minerTag);
        recipe.add("ingredient", (JsonElement)ingredient);
        JsonObject result = new JsonObject();
        result.addProperty("tag", outputTag);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("weight", (Number)weight);
        return recipe;
    }

    public JsonArray buildMinerRecipeConditionJson(String outputTag) {
        JsonArray conditions = new JsonArray();
        JsonObject condition = new JsonObject();
        condition.addProperty("type", "forge:not");
        JsonObject value = new JsonObject();
        value.addProperty("type", "forge:tag_empty");
        value.addProperty("tag", outputTag);
        condition.add("value", (JsonElement)value);
        conditions.add((JsonElement)condition);
        return conditions;
    }

    public String m_6055_() {
        return "Miner Recipes";
    }
}

