/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.features;

import java.util.List;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.minecraft.client.resources.language.I18n;
import org.apache.commons.lang3.text.WordUtils;

public enum FeatureFlags {
    SEPARATE_HARDWARE_SAMPLERS(() -> true, () -> true),
    HIGHER_SHADOWCOLOR(() -> true, () -> true),
    CUSTOM_IMAGES(() -> true, IrisRenderSystem::supportsImageLoadStore),
    PER_BUFFER_BLENDING(() -> true, IrisRenderSystem::supportsBufferBlending),
    COMPUTE_SHADERS(() -> true, IrisRenderSystem::supportsCompute),
    TESSELATION_SHADERS(() -> true, IrisRenderSystem::supportsTesselation),
    ENTITY_TRANSLUCENT(() -> true, () -> true),
    REVERSED_CULLING(() -> true, () -> true),
    SSBO(() -> true, IrisRenderSystem::supportsSSBO),
    UNKNOWN(() -> false, () -> false);

    private final BooleanSupplier irisRequirement;
    private final BooleanSupplier hardwareRequirement;

    private FeatureFlags(BooleanSupplier irisRequirement, BooleanSupplier hardwareRequirement) {
        this.irisRequirement = irisRequirement;
        this.hardwareRequirement = hardwareRequirement;
    }

    public static String getInvalidStatus(List<FeatureFlags> invalidFeatureFlags) {
        FeatureFlags[] flags;
        boolean unsupportedHardware = false;
        boolean unsupportedIris = false;
        for (FeatureFlags flag : flags = invalidFeatureFlags.toArray(new FeatureFlags[0])) {
            unsupportedIris |= !flag.irisRequirement.getAsBoolean();
            unsupportedHardware |= !flag.hardwareRequirement.getAsBoolean();
        }
        if (unsupportedIris) {
            if (unsupportedHardware) {
                return I18n.m_118938_((String)"iris.unsupported.irisorpc", (Object[])new Object[0]);
            }
            return I18n.m_118938_((String)"iris.unsupported.iris", (Object[])new Object[0]);
        }
        if (unsupportedHardware) {
            return I18n.m_118938_((String)"iris.unsupported.pc", (Object[])new Object[0]);
        }
        return null;
    }

    public String getHumanReadableName() {
        return WordUtils.capitalize((String)this.name().replace("_", " ").toLowerCase());
    }

    public boolean isUsable() {
        return this.irisRequirement.getAsBoolean() && this.hardwareRequirement.getAsBoolean();
    }

    public static boolean isInvalid(String name) {
        try {
            return !FeatureFlags.valueOf(name.toUpperCase(Locale.US)).isUsable();
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public static FeatureFlags getValue(String value) {
        try {
            return FeatureFlags.valueOf(value.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }
}

