/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.Function;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRoof;

public class BlockPlatformRoof
extends BlockPlatformType.Inclines {
    public static final PropertySubType SUBTYPE = PropertySubType.create("subtype", EnumSubType.getSimpleValues());
    public static final EnumProperty<ParticleToggle> PARTICLES = EnumProperty.m_61587_((String)"particles", ParticleToggle.class);

    public static BlockPlatformRoof Shingles() {
        return new BlockPlatformRoof(EnumPlatformType.SHINGLES);
    }

    public static BlockPlatformRoof Tiles() {
        return new BlockPlatformRoof(EnumPlatformType.TILES);
    }

    private BlockPlatformRoof(EnumPlatformType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PARTICLES, (Comparable)((Object)ParticleToggle.ENABLED)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PARTICLES});
    }

    @Override
    public PropertySubType getPropertySubType() {
        return SUBTYPE;
    }

    @Override
    protected VoxelShape buildShape(EnumSubType subType, Direction direction, EnumPlatformType railType, String linked, boolean collision) {
        if (!HITBOXES.isEmpty()) {
            VoxelShape[] parts = new VoxelShape[2];
            parts[0] = (VoxelShape)HITBOXES.get((Object)("roof_" + subType.getStyleName() + (collision ? "_collide" : "_select")), (Object)direction);
            if (railType != null) {
                parts[1] = (VoxelShape)HITBOXES.get((Object)(railType.m_7912_() + "_roof" + (collision ? "_collide" : "_select")), (Object)direction);
            }
            return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
        }
        return null;
    }

    @Override
    protected void updateBlock(TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos) {
        Direction newFacing;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int altSupport = this.getSupports(world, pos, facing);
        TileHelper.setAltSupport((BlockEntity)tile, altSupport);
        if (tile instanceof TileEntityPlatformRoof && (newFacing = ((TileEntityPlatformRoof)tile).updateEdgeType(((EnumSubType)((Object)state.m_61143_((Property)SUBTYPE))).getStyleType(), facing)) != null && facing != newFacing) {
            Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)newFacing)), (boolean)true);
        }
        Function.syncTile((BlockEntity)tile);
    }

    protected int getSupports(Level world, BlockPos pos, Direction facing) {
        int support;
        if (world.m_46859_(pos.m_7495_())) {
            support = 2;
        } else {
            BlockState stateDown = world.m_8055_(pos.m_7495_());
            Block blockDown = stateDown.m_60734_();
            if (blockDown instanceof FenceBlock || blockDown instanceof WallBlock || blockDown instanceof LanternBlock) {
                support = 1;
            } else if (blockDown instanceof CrossCollisionBlock) {
                support = 2;
                if (((Boolean)stateDown.m_61143_((Property)CrossCollisionBlock.f_52309_)).booleanValue() || ((Boolean)stateDown.m_61143_((Property)CrossCollisionBlock.f_52311_)).booleanValue()) {
                    support += facing.m_122434_() == Direction.Axis.X ? 1 : 2;
                }
                if (((Boolean)stateDown.m_61143_((Property)CrossCollisionBlock.f_52310_)).booleanValue() || ((Boolean)stateDown.m_61143_((Property)CrossCollisionBlock.f_52312_)).booleanValue()) {
                    support += facing.m_122434_() == Direction.Axis.Z ? 1 : 2;
                }
            } else {
                AABB aabbDown = this.getShapeBoundingBox(stateDown.m_60808_((BlockGetter)world, pos.m_7495_()));
                support = aabbDown != null && aabbDown.f_82292_ >= 1.0 ? (aabbDown.f_82288_ < 0.25 && aabbDown.f_82290_ < 0.25 && aabbDown.f_82291_ > 0.75 && aabbDown.f_82293_ > 0.75 ? 0 : (aabbDown.f_82288_ >= 0.25 && aabbDown.f_82290_ >= 0.25 && aabbDown.f_82291_ <= 0.75 && aabbDown.f_82293_ <= 0.75 ? 1 : 2)) : 2;
            }
        }
        return support;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.toggleParticles(state, world, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @Override
    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        this.toggleParticles(state, world, pos, player);
        super.m_6256_(state, world, pos, player);
    }

    private boolean toggleParticles(BlockState state, Level world, BlockPos pos, Player player) {
        if (player != null && player.m_21205_().m_41619_() && TileHelper.getRail(BlockPlatformRoof.getTile((BlockGetter)world, pos)) != null) {
            ParticleToggle toggle = ((ParticleToggle)((Object)state.m_61143_(PARTICLES))).next(player.m_6144_());
            Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(PARTICLES, (Comparable)((Object)toggle))), (boolean)true);
            player.m_5661_((Component)Component.m_237115_((String)("info.platforms.particle." + toggle.m_7912_())), true);
            return true;
        }
        return false;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        super.m_214162_(state, world, pos, rand);
        ParticleToggle toggle = (ParticleToggle)((Object)state.m_61143_(PARTICLES));
        if (toggle != ParticleToggle.DISABLED && world.m_46859_(pos.m_7494_())) {
            EnumPlatformType rail;
            boolean enabled;
            boolean bl = toggle == ParticleToggle.ENABLED || (world.m_276867_(pos) ? toggle == ParticleToggle.WITH_REDSTONE : toggle == ParticleToggle.WITHOUT_REDSTONE) ? true : (enabled = false);
            if (enabled && (rail = TileHelper.getRail(BlockPlatformRoof.getTile((BlockGetter)world, pos))) != null) {
                if (rail == EnumPlatformType.RAIL) {
                    if (rand.m_188503_(10) == 0) {
                        world.m_6485_((ParticleOptions)ParticleTypes.f_123770_, false, (double)pos.m_123341_() + 0.5 + rand.m_188500_() / 5.0 * (double)(rand.m_188499_() ? 1 : -1), (double)pos.m_123342_() + (double)0.8f + rand.m_188500_(), (double)pos.m_123343_() + 0.5 + rand.m_188500_() / 5.0 * (double)(rand.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
                    }
                } else if (rail == EnumPlatformType.RISE) {
                    world.m_6485_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pos.m_123341_() + 0.5 + rand.m_188500_() / 3.0 * (double)(rand.m_188499_() ? 1 : -1), (double)pos.m_123342_() + (double)1.15f + rand.m_188500_() + rand.m_188500_(), (double)pos.m_123343_() + 0.5 + rand.m_188500_() / 3.0 * (double)(rand.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
                }
            }
        }
    }

    static {
        BlockPlatformRoof.addHitBoxData("roof_right_select", new double[][]{{0.0, 0.0, 0.0, 12.0, 4.0, 18.0}, {0.0, 4.0, 0.0, 12.0, 8.0, 14.0}, {0.0, 8.0, 0.0, 12.0, 12.0, 10.0}, {0.0, 12.0, 0.0, 12.0, 16.0, 6.0}});
        BlockPlatformRoof.addHitBoxData("roof_right_collide", new double[][]{{0.0, 0.0, 0.0, 12.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 12.0, 8.0, 12.0}, {0.0, 8.0, 0.0, 12.0, 12.0, 8.0}, {0.0, 12.0, 0.0, 12.0, 16.0, 4.0}});
        BlockPlatformRoof.addHitBoxData("roof_left_select", new double[][]{{4.0, 0.0, 0.0, 16.0, 4.0, 18.0}, {4.0, 4.0, 0.0, 16.0, 8.0, 14.0}, {4.0, 8.0, 0.0, 16.0, 12.0, 10.0}, {4.0, 12.0, 0.0, 16.0, 16.0, 6.0}});
        BlockPlatformRoof.addHitBoxData("roof_left_collide", new double[][]{{4.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {4.0, 4.0, 0.0, 16.0, 8.0, 12.0}, {4.0, 8.0, 0.0, 16.0, 12.0, 8.0}, {4.0, 12.0, 0.0, 16.0, 16.0, 4.0}});
        BlockPlatformRoof.addHitBoxData("roof_edge_select", new double[][]{{-2.0, 0.0, -2.0, 18.0, 4.0, 18.0}, {2.0, 4.0, 2.0, 14.0, 8.0, 14.0}});
        BlockPlatformRoof.addHitBoxData("roof_edge_collide", new double[][]{{0.0, -3.0, 0.0, 16.0, 0.0, 16.0}, {0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {4.0, 4.0, 4.0, 12.0, 8.0, 12.0}});
        BlockPlatformRoof.addHitBoxData("roof_middle_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 18.0}, {0.0, 4.0, 0.0, 16.0, 8.0, 14.0}, {0.0, 8.0, 0.0, 16.0, 12.0, 10.0}, {0.0, 12.0, 0.0, 16.0, 16.0, 6.0}});
        BlockPlatformRoof.addHitBoxData("roof_middle_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 16.0, 8.0, 12.0}, {0.0, 8.0, 0.0, 16.0, 12.0, 8.0}, {0.0, 12.0, 0.0, 16.0, 16.0, 4.0}});
        BlockPlatformRoof.addHitBoxData("roof_inside_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 16.0, 8.0, 14.0}, {0.0, 8.0, 0.0, 16.0, 12.0, 10.0}, {0.0, 12.0, 0.0, 16.0, 16.0, 6.0}, {2.0, 4.0, 14.0, 16.0, 8.0, 16.0}, {6.0, 8.0, 10.0, 16.0, 12.0, 16.0}, {10.0, 12.0, 6.0, 16.0, 16.0, 16.0}});
        BlockPlatformRoof.addHitBoxData("roof_inside_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {0.0, 4.0, 0.0, 16.0, 8.0, 12.0}, {0.0, 8.0, 0.0, 16.0, 12.0, 8.0}, {0.0, 12.0, 0.0, 16.0, 16.0, 4.0}, {4.0, 4.0, 12.0, 16.0, 8.0, 16.0}, {8.0, 8.0, 8.0, 16.0, 12.0, 16.0}, {12.0, 12.0, 4.0, 16.0, 16.0, 16.0}});
        BlockPlatformRoof.addHitBoxData("roof_outside_select", new double[][]{{-2.0, 0.0, 0.0, 16.0, 4.0, 18.0}, {2.0, 4.0, 0.0, 16.0, 8.0, 14.0}, {6.0, 8.0, 0.0, 16.0, 12.0, 10.0}, {10.0, 12.0, 0.0, 16.0, 16.0, 6.0}});
        BlockPlatformRoof.addHitBoxData("roof_outside_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 4.0, 16.0}, {4.0, 4.0, 0.0, 16.0, 8.0, 12.0}, {8.0, 8.0, 0.0, 16.0, 12.0, 8.0}, {12.0, 12.0, 0.0, 16.0, 16.0, 4.0}});
        BlockPlatformRoof.addHitBoxData("rail_roof_select", new double[][]{{6.0, 0.0, 6.0, 10.0, 14.0, 10.0}, {5.0, 14.0, 5.0, 11.0, 16.0, 11.0}});
        BlockPlatformRoof.addHitBoxData("rail_roof_collide", new double[][]{{6.0, 0.0, 6.0, 10.0, 15.0, 10.0}, {5.0, 14.0, 5.0, 11.0, 16.0, 11.0}});
        BlockPlatformRoof.addHitBoxData("rise_roof_select", new double[][]{{3.98, 0.0, 3.98, 12.02, 21.0, 12.02}, {3.0, 21.0, 3.0, 13.0, 24.0, 13.0}});
        BlockPlatformRoof.addHitBoxData("rise_roof_collide", new double[][]{{4.0, 0.0, 4.0, 12.0, 21.0, 12.0}, {3.0, 21.0, 3.0, 13.0, 24.0, 13.0}});
    }

    static enum ParticleToggle implements StringRepresentable
    {
        ENABLED("enabled"),
        DISABLED("disabled"),
        WITH_REDSTONE("with_redstone"),
        WITHOUT_REDSTONE("without_redstone");

        private final String name;

        private ParticleToggle(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        ParticleToggle next(boolean back) {
            int index = this.ordinal() + (back ? -1 : 1);
            if (index < 0 || index >= ParticleToggle.values().length) {
                index = index < 0 ? ParticleToggle.values().length - 1 : 0;
            }
            return ParticleToggle.values()[index];
        }
    }
}

