/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Roster;

public enum EnumPlatformType implements StringRepresentable
{
    FLAT("flat"),
    FLOOR("floor"),
    FRAME("frame"),
    RAMP("ramp"),
    STAIRS("stairs"),
    STEPS("steps"),
    SHINGLES("shingles"),
    TILES("tiles"),
    RISE("rise"),
    RAIL("rail");

    public static final Map<String, EnumPlatformType> LOOKUP;
    private static final EnumPlatformType[] INCLINES;
    private static final EnumPlatformType[] ROOFS;
    private static final EnumPlatformType[] RAILINGS;
    private static final EnumPlatformType[] EMPTY;
    private final String name;

    private EnumPlatformType(String name) {
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isAddon() {
        return this == RISE || this == RAIL;
    }

    public boolean isIncline() {
        return this == RAMP || this == STAIRS || this == STEPS;
    }

    public boolean isRoof() {
        return this == SHINGLES || this == TILES;
    }

    public boolean isInclineOrRoof() {
        return this.isIncline() || this.isRoof();
    }

    public boolean hasAlternatives() {
        return this.isAddon() || this.isIncline() || this.isRoof();
    }

    public EnumPlatformType[] getAlternatives() {
        return this.isAddon() ? RAILINGS : (this.isIncline() ? INCLINES : (this.isRoof() ? ROOFS : EMPTY));
    }

    public int getCraftAmount() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FLAT -> (Integer)Configuration.CRAFTING.baseFlat.get();
            case FLOOR -> (Integer)Configuration.CRAFTING.baseFloor.get();
            case FRAME -> (Integer)Configuration.CRAFTING.baseFrame.get();
            case RAMP, STAIRS, STEPS -> (Integer)Configuration.CRAFTING.baseInclines.get();
            case SHINGLES, TILES -> (Integer)Configuration.CRAFTING.baseRoofs.get();
            case RISE, RAIL -> (Integer)Configuration.CRAFTING.baseRailings.get();
        };
    }

    public static EnumPlatformType byName(String name) {
        for (EnumPlatformType entry : EnumPlatformType.values()) {
            if (!entry.m_7912_().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return FLAT;
    }

    public static EnumPlatformType byIndex(int index) {
        EnumPlatformType[] values = EnumPlatformType.values();
        return index < 0 || index >= values.length ? FLAT : values[index];
    }

    public static Optional<EnumPlatformType> findOrFail(Item item) {
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            if (block == Roster.Blocks.FLAT.get()) {
                return Optional.of(FLAT);
            }
            if (block == Roster.Blocks.FLOOR.get()) {
                return Optional.of(FLOOR);
            }
            if (block == Roster.Blocks.FRAME.get()) {
                return Optional.of(FRAME);
            }
            if (block == Roster.Blocks.RAMP.get()) {
                return Optional.of(RAMP);
            }
            if (block == Roster.Blocks.STAIRS.get()) {
                return Optional.of(STAIRS);
            }
            if (block == Roster.Blocks.STEPS.get()) {
                return Optional.of(STEPS);
            }
            if (block == Roster.Blocks.SHINGLES.get()) {
                return Optional.of(SHINGLES);
            }
            if (block == Roster.Blocks.TILES.get()) {
                return Optional.of(TILES);
            }
            if (block == Roster.Blocks.RISE.get()) {
                return Optional.of(RISE);
            }
            if (block == Roster.Blocks.RAIL.get()) {
                return Optional.of(RAIL);
            }
        }
        return Optional.empty();
    }

    static {
        LOOKUP = Arrays.stream(EnumPlatformType.values()).collect(Collectors.toMap(EnumPlatformType::m_7912_, type -> type));
        INCLINES = new EnumPlatformType[]{RAMP, STAIRS, STEPS};
        ROOFS = new EnumPlatformType[]{SHINGLES, TILES};
        RAILINGS = new EnumPlatformType[]{RISE, RAIL};
        EMPTY = new EnumPlatformType[0];
    }
}

