/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;

public class WidgetColorSelector
extends WidgetButtonExtended
implements IDrawAfterRender {
    private boolean expanded = false;
    private DyeColor color = DyeColor.WHITE;
    private final Rect2i mainArea;
    private final Rect2i expandedArea;
    private final Consumer<WidgetColorSelector> callback;

    public WidgetColorSelector(int xIn, int yIn) {
        this(xIn, yIn, null);
    }

    public WidgetColorSelector(int xIn, int yIn, Consumer<WidgetColorSelector> callback) {
        super(xIn, yIn, 16, 16, (Component)Component.m_237119_());
        this.mainArea = new Rect2i(xIn, yIn, this.f_93618_, this.f_93619_);
        this.expandedArea = new Rect2i(xIn, yIn + this.f_93619_, this.f_93618_ * 4, this.f_93619_ * 4);
        this.callback = callback;
    }

    public WidgetColorSelector withInitialColor(DyeColor color) {
        this.color = color;
        return this;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
        int x = this.m_252754_();
        int y = this.m_252907_();
        graphics.m_280509_(x + 3, y + 3, x + this.f_93618_ - 4, y + this.f_93619_ - 4, 0xFF000000 | PneumaticCraftUtils.getDyeColorAsRGB(this.color));
        graphics.m_280656_(x + 3, x + this.f_93618_ - 3, y + this.f_93619_ - 4, -10461088);
        graphics.m_280315_(x + this.f_93618_ - 4, y + 3, y + this.f_93619_ - 3, -10461088);
    }

    @Override
    public void renderAfterEverythingElse(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.expanded) {
            int x = this.m_252754_();
            int y = this.m_252907_();
            graphics.m_280509_(x, y - 1 + this.f_93619_, x + this.f_93618_ * 4, y - 1 + this.f_93619_ * 5, -16777216);
            graphics.m_280509_(x + 1, y + this.f_93619_, x + this.f_93618_ * 4 - 1, y - 2 + this.f_93619_ * 5, -8355712);
            for (DyeColor color : DyeColor.values()) {
                int dx = x + color.m_41060_() % 4 * 16;
                int dy = y - 1 + this.f_93619_ + color.m_41060_() / 4 * 16;
                graphics.m_280509_(dx + 3, dy + 3, dx + 13, dy + 13, 0xFF000000 | PneumaticCraftUtils.getDyeColorAsRGB(color));
                graphics.m_280656_(dx + 3, dx + 13, dy + 13, -10461088);
                graphics.m_280315_(dx + 13, dy + 3, dy + 13, -10461088);
            }
        }
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return super.m_93680_(mouseX, mouseY) || this.expanded && this.expandedArea.m_110087_((int)mouseX, (int)mouseY);
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (this.mainArea.m_110087_((int)mouseX, (int)mouseY)) {
            this.expanded = !this.expanded;
        } else if (this.expandedArea.m_110087_((int)mouseX, (int)mouseY)) {
            int dx = (int)mouseX - this.expandedArea.m_110085_();
            int dy = (int)mouseY - this.expandedArea.m_110086_();
            int id = dx / 16 + dy / 16 * 4;
            this.color = DyeColor.m_41053_((int)id);
            boolean bl = this.expanded = !this.expanded;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }
}

