/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.VacuumTrapBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.PressurizedSpawnerMenu;
import me.desht.pneumaticcraft.common.item.SpawnerCoreItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;

public class PressurizedSpawnerBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<PressurizedSpawnerBlockEntity>,
MenuProvider,
IRangedTE {
    public static final int BASE_SPAWN_INTERVAL = 200;
    private static final int MAX_NEARBY_ENTITIES = 32;
    private final SpawnerCoreItem.SpawnerCoreItemHandler inventory = new SpawnerCoreItem.SpawnerCoreItemHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    public VacuumTrapBlockEntity.Problems problem = VacuumTrapBlockEntity.Problems.OK;
    @GuiSynced
    private final RedstoneController<PressurizedSpawnerBlockEntity> rsController = new RedstoneController<PressurizedSpawnerBlockEntity>(this);
    private int counter = -1;
    @DescSynced
    private boolean running;
    private final RangeManager rangeManager = new RangeManager(this, 0x60400040).withCustomExtents(this::buildCustomExtents);

    public PressurizedSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PRESSURIZED_SPAWNER.get(), pos, state, PressureTier.TIER_TWO, 5000, 4);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.rangeManager.setRange(2 + this.getUpgrades(ModUpgrades.RANGE.get()));
        if (this.counter < 0) {
            this.counter = this.getSpawnInterval();
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.running) {
            Level level = this.nonNullLevel();
            double x = (double)this.f_58858_.m_123341_() + level.f_46441_.m_188500_();
            double y = (double)this.f_58858_.m_123342_() + level.f_46441_.m_188500_();
            double z = (double)this.f_58858_.m_123343_() + level.f_46441_.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        ISpawnerCoreStats stats = this.inventory.getStats();
        this.running = false;
        this.problem = VacuumTrapBlockEntity.Problems.OK;
        if (stats == null) {
            this.problem = VacuumTrapBlockEntity.Problems.NO_CORE;
        } else if (this.getPressure() > this.getMinWorkingPressure() && this.rsController.shouldRun()) {
            this.running = true;
            if (--this.counter <= 0) {
                Level level;
                if (!this.trySpawnSomething(stats) && (level = this.f_58857_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)this.f_58858_.m_123341_() + 0.5, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5, 5, 0.0, 0.0, 0.0, 0.0);
                }
                this.addAir(-this.getAirUsage());
                this.counter = this.getSpawnInterval();
            }
        }
    }

    private AABB buildCustomExtents() {
        AABB aabb = new AABB(this.m_58899_(), this.m_58899_());
        return aabb.m_82377_((double)this.getRange(), 0.0, (double)this.getRange()).m_82363_(0.0, 2.0, 0.0).m_82363_(0.0, -1.0, 0.0);
    }

    private boolean trySpawnSomething(ISpawnerCoreStats stats) {
        Level level;
        EntityType<?> type = stats.pickEntity(true);
        if (type != null && (level = this.f_58857_) instanceof ServerLevel) {
            double z;
            double y;
            ServerLevel serverworld = (ServerLevel)level;
            int spawnRange = this.getRange();
            double x = (double)this.f_58858_.m_123341_() + (serverworld.f_46441_.m_188500_() - this.f_58857_.f_46441_.m_188500_()) * (double)spawnRange + 0.5;
            if (serverworld.m_45772_(type.m_20585_(x, y = (double)(this.f_58858_.m_123342_() + serverworld.f_46441_.m_188503_(3) - 1), z = (double)this.f_58858_.m_123343_() + (serverworld.f_46441_.m_188500_() - this.f_58857_.f_46441_.m_188500_()) * (double)spawnRange + 0.5))) {
                Entity entity = type.m_20615_((Level)serverworld);
                if (!(entity instanceof Mob)) {
                    return false;
                }
                Mob mobentity = (Mob)entity;
                int entityCount = serverworld.m_45976_(Mob.class, this.rangeManager.getExtents()).size();
                if (entityCount >= 32) {
                    return false;
                }
                entity.m_7678_(x, y, z, this.f_58857_.f_46441_.m_188501_() * 360.0f, 0.0f);
                ForgeEventFactory.onFinalizeSpawn((Mob)mobentity, (ServerLevelAccessor)serverworld, (DifficultyInstance)serverworld.m_6436_(this.getPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
                if (!serverworld.m_8860_(entity)) {
                    return false;
                }
                this.f_58857_.m_46796_(2004, this.f_58858_, 0);
                mobentity.m_21373_();
                mobentity.m_21530_();
                mobentity.getPersistentData().m_128379_("pneumaticcraft:pressurized_spawner", true);
                return true;
            }
        }
        return false;
    }

    public int getSpawnInterval() {
        return (int)(200.0f / this.getSpeedMultiplierFromUpgrades());
    }

    public int getAirUsage() {
        return 150 * (this.getUpgrades(ModUpgrades.SPEED.get()) + 1);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.invCap;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public RedstoneController<PressurizedSpawnerBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new PressurizedSpawnerMenu(windowId, inv, this.m_58899_());
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
    }

    public AABB getRenderBoundingBox() {
        return this.rangeManager.shouldShowRange() ? this.rangeManager.getExtents() : super.getRenderBoundingBox();
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }
}

