/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IHeatTinted;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.network.DescSynced;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class VortexTubeBlockEntity
extends AbstractAirHandlingBlockEntity
implements IHeatTinted,
IHeatExchangingTE {
    private final IHeatExchangerLogic hotHeatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> hotHeatCap = LazyOptional.of(() -> this.hotHeatExchanger);
    private final IHeatExchangerLogic coldHeatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> coldHeatCap = LazyOptional.of(() -> this.coldHeatExchanger);
    private final IHeatExchangerLogic connectingExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    @DescSynced
    private final SyncedTemperature syncHot = new SyncedTemperature(this.hotHeatExchanger);
    @DescSynced
    private final SyncedTemperature syncCold = new SyncedTemperature(this.coldHeatExchanger);

    public VortexTubeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.VORTEX_TUBE.get(), pos, state, PressureTier.TIER_TWO, 2000, 0);
        this.coldHeatExchanger.setThermalResistance(0.01);
        this.hotHeatExchanger.setThermalResistance(0.01);
        this.connectingExchanger.setThermalResistance(100.0);
        this.connectingExchanger.addConnectedExchanger(this.coldHeatExchanger);
        this.connectingExchanger.addConnectedExchanger(this.hotHeatExchanger);
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        if (side == null || side == this.getRotation().m_122424_()) {
            return this.hotHeatCap;
        }
        if (side == this.getRotation()) {
            return this.coldHeatCap;
        }
        return LazyOptional.empty();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != this.getRotation() && side != this.getRotation().m_122424_();
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("coldHeat", (Tag)this.coldHeatExchanger.serializeNBT());
        tag.m_128365_("connector", (Tag)this.connectingExchanger.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.coldHeatExchanger.deserializeNBT(tag.m_128469_("coldHeat"));
        this.connectingExchanger.deserializeNBT(tag.m_128469_("connector"));
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.connectingExchanger.tick();
        this.coldHeatExchanger.tick();
        int usedAir = (int)(this.getPressure() * 10.0f);
        if (usedAir > 0) {
            this.addAir(-usedAir);
            double generatedHeat = (double)usedAir / 10.0;
            this.coldHeatExchanger.addHeat(-generatedHeat);
            this.hotHeatExchanger.addHeat(generatedHeat);
        }
        this.syncHot.tick();
        this.syncCold.tick();
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public TintColor getColorForTintIndex(int tintIndex) {
        return switch (tintIndex) {
            case 1 -> HeatUtil.getColourForTemperature(this.syncHot.getSyncedTemp());
            case 2 -> HeatUtil.getColourForTemperature(this.syncCold.getSyncedTemp());
            default -> HeatUtil.getColourForTemperature(300);
        };
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        if (dir == null || dir == this.getRotation().m_122424_()) {
            return this.hotHeatExchanger;
        }
        if (dir == this.getRotation()) {
            return this.coldHeatExchanger;
        }
        return null;
    }

    @Override
    public void initHeatExchangersOnPlacement(Level world, BlockPos pos) {
        double temp = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)world, pos);
        this.hotHeatExchanger.setTemperature(temp);
        this.coldHeatExchanger.setTemperature(temp);
    }
}

