/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.advancements.CustomTrigger;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import org.apache.commons.lang3.Validate;

public class ModAdvancementProvider
extends ForgeAdvancementProvider {
    private static final ResourceLocation BACKGROUND_TEXTURE = PneumaticRegistry.RL("textures/gui/advancement_bg.png");

    public ModAdvancementProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(generatorIn.getPackOutput(), lookupProvider, existingFileHelper, List.of(new PNCAdvancements()));
    }

    private static class PNCAdvancements
    implements ForgeAdvancementProvider.AdvancementGenerator {
        private PNCAdvancements() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
            Advancement root = this.itemAdvancement("root", FrameType.TASK, (ItemLike)ModItems.COMPRESSED_IRON_INGOT.get()).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("root"));
            Advancement oilBucket = this.itemAdvancement("oil_bucket", FrameType.TASK, (ItemLike)ModItems.OIL_BUCKET.get()).m_138398_(root).m_138389_(saver, PNCAdvancements.id("oil_bucket"));
            Advancement refinery = this.itemAdvancement("refinery", FrameType.GOAL, (ItemLike)ModBlocks.REFINERY.get(), new ItemPredicate[]{this.itemPredicate((ItemLike)ModBlocks.REFINERY.get(), 1), this.itemPredicate((ItemLike)ModBlocks.REFINERY_OUTPUT.get(), 2)}).m_138398_(oilBucket).m_138354_(AdvancementRewards.Builder.m_10005_((int)20)).m_138389_(saver, PNCAdvancements.id("refinery"));
            this.itemAdvancement("liquid_compressor", FrameType.TASK, (ItemLike)ModBlocks.LIQUID_COMPRESSOR.get()).m_138398_(refinery).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("liquid_compressor"));
            Advancement vortexTube = this.itemAdvancement("vortex_tube", FrameType.TASK, (ItemLike)ModBlocks.VORTEX_TUBE.get()).m_138398_(refinery).m_138389_(saver, PNCAdvancements.id("vortex_tube"));
            Advancement lpgBucket = this.itemAdvancement("lpg_bucket", FrameType.TASK, (ItemLike)ModItems.LPG_BUCKET.get()).m_138398_(vortexTube).m_138354_(AdvancementRewards.Builder.m_10005_((int)20)).m_138389_(saver, PNCAdvancements.id("lpg_bucket"));
            Advancement tpp = this.itemAdvancement("tp_plant", FrameType.TASK, (ItemLike)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()).m_138398_(lpgBucket).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("tp_plant"));
            Advancement plastic = this.itemAdvancement("plastic", FrameType.GOAL, (ItemLike)ModItems.PLASTIC.get()).m_138398_(tpp).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("plastic"));
            Advancement jackhammer = this.itemAdvancement("jackhammer", FrameType.GOAL, (ItemLike)ModItems.JACKHAMMER.get()).m_138398_(plastic).m_138354_(AdvancementRewards.Builder.m_10005_((int)20)).m_138389_(saver, PNCAdvancements.id("jackhammer"));
            this.itemAdvancement("drill_bit_netherite", FrameType.CHALLENGE, (ItemLike)ModItems.NETHERITE_DRILL_BIT.get()).m_138398_(jackhammer).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).m_138389_(saver, PNCAdvancements.id("drill_bit_netherite"));
            Advancement amadronTablet = this.itemAdvancement("amadron_tablet", FrameType.TASK, (ItemLike)ModItems.AMADRON_TABLET.get()).m_138398_(plastic).m_138389_(saver, PNCAdvancements.id("amadron_tablet"));
            Advancement pcbBlueprint = this.itemAdvancement("pcb_blueprint", FrameType.TASK, (ItemLike)ModItems.PCB_BLUEPRINT.get()).m_138398_(amadronTablet).m_138354_(AdvancementRewards.Builder.m_10005_((int)20)).m_138389_(saver, PNCAdvancements.id("pcb_blueprint"));
            this.itemAdvancement("uv_light_box", FrameType.TASK, (ItemLike)ModBlocks.UV_LIGHT_BOX.get()).m_138398_(pcbBlueprint).m_138389_(saver, PNCAdvancements.id("uv_light_box"));
            Advancement lubricant = this.itemAdvancement("lubricant_bucket", FrameType.TASK, (ItemLike)ModItems.LUBRICANT_BUCKET.get()).m_138398_(tpp).m_138389_(saver, PNCAdvancements.id("lubricant_bucket"));
            this.itemAdvancement("speed_upgrade", FrameType.TASK, new ItemLike[]{ModUpgrades.SPEED.get().getItem()}).m_138398_(lubricant).m_138354_(AdvancementRewards.Builder.m_10005_((int)15)).m_138389_(saver, PNCAdvancements.id("speed_upgrade"));
            Advancement yeast = this.itemAdvancement("yeast_culture", FrameType.TASK, (ItemLike)ModItems.YEAST_CULTURE_BUCKET.get()).m_138398_(tpp).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("yeast_culture"));
            Advancement ethanol = this.itemAdvancement("ethanol", FrameType.TASK, (ItemLike)ModItems.ETHANOL_BUCKET.get()).m_138398_(yeast).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("ethanol"));
            this.itemAdvancement("biodiesel", FrameType.GOAL, (ItemLike)ModItems.BIODIESEL_BUCKET.get()).m_138398_(ethanol).m_138354_(AdvancementRewards.Builder.m_10005_((int)25)).m_138389_(saver, PNCAdvancements.id("biodiesel"));
            Advancement pressureTube = this.itemAdvancement("pressure_tube", FrameType.TASK, (ItemLike)ModBlocks.PRESSURE_TUBE.get()).m_138398_(root).m_138389_(saver, PNCAdvancements.id("pressure_tube"));
            this.itemAdvancement("air_compressor", FrameType.TASK, (ItemLike)ModBlocks.AIR_COMPRESSOR.get()).m_138398_(pressureTube).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("air_compressor"));
            this.itemAdvancement("minigun", FrameType.TASK, (ItemLike)ModItems.MINIGUN.get()).m_138398_(pressureTube).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("minigun"));
            Advancement wrench = this.itemAdvancement("pneumatic_wrench", FrameType.TASK, (ItemLike)ModItems.PNEUMATIC_WRENCH.get(), new ItemPredicate[]{this.itemPredicateNoNBT((ItemLike)ModItems.PNEUMATIC_WRENCH.get(), 1)}).m_138398_(pressureTube).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("pneumatic_wrench"));
            this.customAdvancement(AdvancementTriggers.CHARGED_WRENCH, "pneumatic_wrench_charged", FrameType.TASK, (ItemLike)ModItems.PNEUMATIC_WRENCH.get()).m_138398_(wrench).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("pneumatic_wrench_charged"));
            this.customAdvancement(AdvancementTriggers.MACHINE_VANDAL, "machine_vandal", FrameType.TASK, (ItemLike)Items.f_42385_).m_138398_(wrench).m_138389_(saver, PNCAdvancements.id("machine_vandal"));
            Advancement frames = this.itemAdvancement("logistics_frame", FrameType.TASK, (ItemLike)ModItems.LOGISTICS_FRAME_PASSIVE_PROVIDER.get(), new ItemPredicate[]{this.itemPredicate((ItemLike)ModItems.LOGISTICS_FRAME_PASSIVE_PROVIDER.get(), 1), this.itemPredicate((ItemLike)ModItems.LOGISTICS_FRAME_REQUESTER.get(), 1)}).m_138398_(root).m_138354_(AdvancementRewards.Builder.m_10005_((int)20)).m_138389_(saver, PNCAdvancements.id("logistics_frame"));
            Advancement configurator = this.itemAdvancement("logistics_configurator", FrameType.TASK, (ItemLike)ModItems.LOGISTICS_CONFIGURATOR.get()).m_138398_(frames).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("logistics_configurator"));
            this.customAdvancement(AdvancementTriggers.LOGISTICS_DRONE_DEPLOYED, "logistics_drone", FrameType.GOAL, (ItemLike)ModItems.LOGISTICS_DRONE.get()).m_138398_(configurator).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("logistics_drone"));
            Advancement pressureChamber = this.customAdvancement(AdvancementTriggers.PRESSURE_CHAMBER, "pressure_chamber", FrameType.GOAL, (ItemLike)ModBlocks.PRESSURE_CHAMBER_WALL.get()).m_138398_(root).m_138354_(AdvancementRewards.Builder.m_10005_((int)20)).m_138389_(saver, PNCAdvancements.id("pressure_chamber"));
            Advancement etchingAcid = this.itemAdvancement("etchacid_bucket", FrameType.TASK, (ItemLike)ModItems.ETCHING_ACID_BUCKET.get()).m_138398_(pressureChamber).m_138389_(saver, PNCAdvancements.id("etchacid_bucket"));
            Advancement emptyPCB = this.itemAdvancement("empty_pcb", FrameType.TASK, (ItemLike)ModItems.EMPTY_PCB.get()).m_138398_(etchingAcid).m_138389_(saver, PNCAdvancements.id("empty_pcb"));
            Advancement unassembledPCB = this.itemAdvancement("unassembled_pcb", FrameType.TASK, (ItemLike)ModItems.UNASSEMBLED_PCB.get()).m_138398_(emptyPCB).m_138389_(saver, PNCAdvancements.id("unassembled_pcb"));
            Advancement pcb = this.itemAdvancement("printed_circuit_board", FrameType.GOAL, (ItemLike)ModItems.PRINTED_CIRCUIT_BOARD.get()).m_138398_(unassembledPCB).m_138354_(AdvancementRewards.Builder.m_10005_((int)20)).m_138389_(saver, PNCAdvancements.id("printed_circuit_board"));
            Advancement armor = this.customAdvancement(AdvancementTriggers.PNEUMATIC_ARMOR, "pneumatic_armor", FrameType.TASK, (ItemLike)ModItems.PNEUMATIC_HELMET.get()).m_138398_(pcb).m_138354_(AdvancementRewards.Builder.m_10005_((int)20)).m_138389_(saver, PNCAdvancements.id("pneumatic_armor"));
            Advancement jetBoots = this.customAdvancement(AdvancementTriggers.FLIGHT, "flight", FrameType.CHALLENGE, (ItemLike)ModUpgrades.JET_BOOTS.get().getItem()).m_138398_(armor).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).m_138389_(saver, PNCAdvancements.id("flight"));
            this.customAdvancement(AdvancementTriggers.FLY_INTO_WALL, "fly_into_wall", FrameType.TASK, (ItemLike)Blocks.f_50076_).m_138398_(jetBoots).m_138389_(saver, PNCAdvancements.id("fly_into_wall"));
            this.customAdvancement(AdvancementTriggers.BLOCK_HACK, "block_hack", FrameType.TASK, (ItemLike)ModUpgrades.BLOCK_TRACKER.get().getItem()).m_138398_(armor).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("block_hack"));
            this.customAdvancement(AdvancementTriggers.ENTITY_HACK, "entity_hack", FrameType.TASK, (ItemLike)ModUpgrades.ENTITY_TRACKER.get().getItem()).m_138398_(armor).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("entity_hack"));
            Advancement assembly = this.itemAdvancement("assembly_controller", FrameType.GOAL, (ItemLike)ModBlocks.ASSEMBLY_CONTROLLER.get()).m_138398_(pcb).m_138354_(AdvancementRewards.Builder.m_10005_((int)30)).m_138389_(saver, PNCAdvancements.id("assembly_controller"));
            Advancement advancedTube = this.itemAdvancement("advanced_pressure_tube", FrameType.TASK, (ItemLike)ModBlocks.ADVANCED_PRESSURE_TUBE.get()).m_138398_(assembly).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("advanced_pressure_tube"));
            this.itemAdvancement("aerial_interface", FrameType.TASK, (ItemLike)ModBlocks.AERIAL_INTERFACE.get()).m_138398_(advancedTube).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("aerial_interface"));
            this.itemAdvancement("programmable_controller", FrameType.TASK, (ItemLike)ModBlocks.PROGRAMMABLE_CONTROLLER.get()).m_138398_(advancedTube).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("programmable_controller"));
            this.itemAdvancement("flux_compressor", FrameType.TASK, (ItemLike)ModBlocks.FLUX_COMPRESSOR.get()).m_138398_(advancedTube).m_138354_(AdvancementRewards.Builder.m_10005_((int)10)).m_138389_(saver, PNCAdvancements.id("flux_compressor"));
            this.itemAdvancement("aphorism_tile", FrameType.TASK, (ItemLike)ModBlocks.APHORISM_TILE.get()).m_138398_(assembly).m_138389_(saver, PNCAdvancements.id("aphorism_tile"));
            Advancement programmer = this.itemAdvancement("programmer", FrameType.TASK, (ItemLike)ModBlocks.PROGRAMMER.get()).m_138398_(pcb).m_138389_(saver, PNCAdvancements.id("programmer"));
            Advancement puzzle = this.itemAdvancement("programming_puzzle", FrameType.TASK, (ItemLike)ModItems.PROGRAMMING_PUZZLE.get()).m_138398_(programmer).m_138389_(saver, PNCAdvancements.id("programming_puzzle"));
            this.customAdvancement(AdvancementTriggers.PROGRAM_DRONE, "program_drone", FrameType.CHALLENGE, (ItemLike)ModItems.DRONE.get()).m_138398_(puzzle).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).m_138389_(saver, PNCAdvancements.id("program_drone"));
        }

        private static String id(String s) {
            return "pneumaticcraft:" + s;
        }

        private Advancement.Builder customAdvancement(CustomTrigger trigger, String name, FrameType type, ItemLike itemDisp) {
            return Advancement.Builder.m_138353_().m_138371_(itemDisp, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name, new Object[0]), (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).m_138386_("0", (CriterionTriggerInstance)trigger.getInstance());
        }

        private Advancement.Builder itemAdvancement(String name, FrameType type, ItemLike ... items) {
            Validate.isTrue((items.length > 0 ? 1 : 0) != 0);
            return Advancement.Builder.m_138353_().m_138371_(items[0], (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name, new Object[0]), (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).m_138386_("0", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items));
        }

        private Advancement.Builder itemAdvancement(String name, FrameType type, ItemLike item, ItemPredicate[] predicates) {
            return Advancement.Builder.m_138353_().m_138371_(item, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name, new Object[0]), (Component)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).m_138386_("0", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])predicates));
        }

        private ItemPredicate itemPredicate(ItemLike item, int minCount) {
            return new ItemPredicate(null, Collections.singleton(item.m_5456_()), MinMaxBounds.Ints.m_55386_((int)minCount), MinMaxBounds.Ints.f_55364_, new EnchantmentPredicate[0], new EnchantmentPredicate[0], null, NbtPredicate.f_57471_);
        }

        private ItemPredicate itemPredicateNoNBT(ItemLike item, int minCount) {
            return new ItemPredicate(null, Collections.singleton(item.m_5456_()), MinMaxBounds.Ints.m_55386_((int)minCount), MinMaxBounds.Ints.f_55364_, new EnchantmentPredicate[0], new EnchantmentPredicate[0], null, new NbtPredicate(null));
        }
    }
}

