/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import me.desht.pneumaticcraft.client.gui.GPSToolScreen;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetAreaToolScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GPSAreaToolScreen
extends GPSToolScreen {
    private static final int CHANGE_AREA_BUTTON_WIDTH = 138;
    private static final int P1P2_BUTTON_WIDTH = 30;
    private final BlockPos[] p1p2Pos = new BlockPos[2];
    private final String[] vars = new String[2];
    private final boolean[] playerGlobals = new boolean[2];
    private int index;

    private GPSAreaToolScreen(ItemStack stack, InteractionHand hand, int index) {
        super(stack.m_41786_(), hand, GPSAreaToolItem.getGPSLocation((Player)Minecraft.m_91087_().f_91074_, stack, index).orElse(ClientUtils.getClientPlayer().m_20183_()), GPSAreaToolItem.getVariable((Player)Minecraft.m_91087_().f_91074_, stack, index));
        this.index = index;
        for (int i = 0; i <= 1; ++i) {
            this.p1p2Pos[i] = GPSAreaToolItem.getGPSLocation((Player)Minecraft.m_91087_().f_91074_, stack, i).orElse(ClientUtils.getClientPlayer().m_20183_());
            this.vars[i] = GPSAreaToolItem.getVariable((Player)Minecraft.m_91087_().f_91074_, stack, i);
            this.playerGlobals[i] = !this.vars[i].startsWith("%");
            this.vars[i] = GlobalVariableHelper.stripVarPrefix(this.vars[i]);
        }
    }

    public static void showGUI(ItemStack stack, InteractionHand hand, int index) {
        Minecraft.m_91087_().m_91152_((Screen)new GPSAreaToolScreen(stack, hand, index));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int xMiddle = this.f_96543_ / 2;
        int yMiddle = this.f_96544_ / 2;
        int x = xMiddle - 69;
        int y = yMiddle + 100;
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(x, y, 138, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.gps_area_tool.changeAreaType", new Object[0]), b -> {
            ItemStack stack = ClientUtils.getClientPlayer().m_21120_(this.hand);
            ProgWidgetArea area = GPSAreaToolItem.getArea(ClientUtils.getClientPlayer(), stack);
            this.f_96541_.m_91152_((Screen)new ProgWidgetAreaToolScreen(area, this.hand, () -> this.f_96541_.m_91152_((Screen)new GPSAreaToolScreen(stack, this.hand, this.index))));
        }));
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(xMiddle - 15, yMiddle - 45, 30, 20, this.getToggleLabel(), this::toggleP1P2));
    }

    @Override
    protected int getIndex() {
        return this.index;
    }

    @Override
    protected void syncToServer() {
        this.p1p2Pos[this.index] = new BlockPos(this.textFields[0].getIntValue(), this.textFields[1].getIntValue(), this.textFields[2].getIntValue());
        this.vars[this.index] = this.variableField.m_94155_();
        for (int i = 0; i <= 1; ++i) {
            if (!this.changed(i)) continue;
            String varName = GlobalVariableHelper.getPrefixedVar(this.vars[i], this.playerGlobals[i]);
            NetworkHandler.sendToServer(new PacketChangeGPSToolCoordinate(this.p1p2Pos[i], this.hand, varName, i));
        }
    }

    private boolean changed(int index) {
        ItemStack stack = ClientUtils.getClientPlayer().m_21120_(this.hand);
        BlockPos p = GPSAreaToolItem.getGPSLocation(ClientUtils.getClientPlayer(), stack, index).orElse(PneumaticCraftUtils.invalidPos());
        String var = GPSAreaToolItem.getVariable(ClientUtils.getClientPlayer(), stack, index);
        String var2 = GlobalVariableHelper.getPrefixedVar(this.vars[index], this.playerGlobals[index]);
        return !p.equals((Object)this.p1p2Pos[index]) || !var.equals(var2);
    }

    @Override
    protected void toggleVarType() {
        this.playerGlobals[this.index] = !this.playerGlobals[this.index];
        this.varTypeButton.m_93666_((Component)Component.m_237113_((String)GlobalVariableHelper.getVarPrefix(this.playerGlobals[this.index])));
    }

    private void toggleP1P2(Button b) {
        ItemStack stack = ClientUtils.getClientPlayer().m_21120_(this.hand);
        if (stack.m_41720_() instanceof GPSAreaToolItem) {
            this.p1p2Pos[this.index] = new BlockPos(this.textFields[0].getIntValue(), this.textFields[1].getIntValue(), this.textFields[2].getIntValue());
            this.vars[this.index] = this.variableField.m_94155_();
            this.index = 1 - this.index;
            b.m_93666_(this.getToggleLabel());
            this.textFields[0].setValue(this.p1p2Pos[this.index].m_123341_());
            this.textFields[1].setValue(this.p1p2Pos[this.index].m_123342_());
            this.textFields[2].setValue(this.p1p2Pos[this.index].m_123343_());
            this.variableField.m_94144_(this.vars[this.index]);
            this.varTypeButton.m_93666_((Component)Component.m_237113_((String)GlobalVariableHelper.getVarPrefix(this.playerGlobals[this.index])));
            if (this.teleportButton != null) {
                BlockPos pos = this.getBlockPos();
                this.teleportButton.setTooltipText((Component)Component.m_237113_((String)String.format("/tp %d %d %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    private Component getToggleLabel() {
        ChatFormatting color = this.index == 0 ? ChatFormatting.RED : ChatFormatting.GREEN;
        return Component.m_237113_((String)("P" + (this.index + 1))).m_130940_(color);
    }
}

