/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.block.ReinforcedChestBlock;
import me.desht.pneumaticcraft.common.block.SmartChestBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.SmartChestMenu;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class SmartChestBlockEntity
extends AbstractTickingBlockEntity
implements MenuProvider,
IRedstoneControl<SmartChestBlockEntity>,
IComparatorSupport {
    public static final int CHEST_SIZE = 72;
    private static final String NBT_ITEMS = "Items";
    private final SmartChestItemHandler inventory = new SmartChestItemHandler(this, 72);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    private final RedstoneController<SmartChestBlockEntity> rsController = new RedstoneController<SmartChestBlockEntity>(this);
    @GuiSynced
    private int pushPullModes = 0;
    @GuiSynced
    private int cooldown = 0;
    private final EnumMap<Direction, Integer> pullSlots = new EnumMap(Direction.class);
    private final EnumMap<Direction, Integer> pushSlots = new EnumMap(Direction.class);

    public SmartChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.SMART_CHEST.get()), pos, state, 4);
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.getUpgrades(ModUpgrades.MAGNET.get()) == 0) {
            AreaRenderManager.getInstance().removeHandlers(this);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.rsController.shouldRun() && this.nonNullLevel().m_46467_() % (long)Math.max(this.getTickRate(), this.cooldown) == 0L) {
            boolean didWork = false;
            block4: for (SideConfigurator.RelativeFace face : SideConfigurator.RelativeFace.values()) {
                switch (this.getPushPullMode(face)) {
                    case PUSH: {
                        didWork |= this.tryPush(this.getAbsoluteFacing(face, this.getRotation()));
                        continue block4;
                    }
                    case PULL: {
                        didWork |= this.tryPull(this.getAbsoluteFacing(face, this.getRotation()));
                    }
                }
            }
            this.cooldown = didWork ? 0 : Math.min(this.cooldown + 4, 20);
        }
    }

    private boolean tryPush(Direction dir) {
        BlockEntity te = this.getCachedNeighbor(dir);
        if (te == null) {
            return this.tryDispense(dir);
        }
        return IOHelper.getInventoryForTE(te, dir.m_122424_()).map(dstHandler -> {
            this.validateCachedSlot((Map<Direction, Integer>)this.pushSlots, dir, (IItemHandler)dstHandler);
            ItemStack toPush = this.findNextItem((IItemHandler)this.inventory, this.pushSlots, dir);
            if (toPush.m_41619_()) {
                return false;
            }
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)dstHandler, (ItemStack)toPush, (boolean)false);
            int transferred = toPush.m_41613_() - excess.m_41613_();
            if (transferred > 0) {
                this.inventory.extractItem(this.pushSlots.getOrDefault(dir, 0), transferred, false);
                return true;
            }
            this.pushSlots.put(dir, this.scanForward((IItemHandler)this.inventory, this.pushSlots.getOrDefault(dir, 0)));
            return false;
        }).orElse(false);
    }

    private boolean tryDispense(Direction dir) {
        ItemStack toPush;
        if (this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0 && !Block.m_49863_((LevelReader)this.nonNullLevel(), (BlockPos)this.f_58858_, (Direction)dir.m_122424_()) && !(toPush = this.findNextItem((IItemHandler)this.inventory, this.pushSlots, dir)).m_41619_()) {
            ItemStack pushed = this.inventory.extractItem(this.pushSlots.getOrDefault(dir, 0), toPush.m_41613_(), false);
            BlockPos dropPos = this.f_58858_.m_121945_(dir);
            PneumaticCraftUtils.dropItemOnGroundPrecisely(pushed, this.f_58857_, (double)dropPos.m_123341_() + 0.5, (double)dropPos.m_123342_() + 0.5, (double)dropPos.m_123343_() + 0.5);
            return true;
        }
        return false;
    }

    private boolean tryPull(Direction dir) {
        BlockEntity te = this.getCachedNeighbor(dir);
        if (te == null) {
            return this.tryMagnet(dir);
        }
        return IOHelper.getInventoryForTE(this.getCachedNeighbor(dir), dir.m_122424_()).map(srcHandler -> {
            this.validateCachedSlot((Map<Direction, Integer>)this.pullSlots, dir, (IItemHandler)srcHandler);
            ItemStack toPull = this.findNextItem((IItemHandler)srcHandler, this.pullSlots, dir);
            if (toPull.m_41619_()) {
                return false;
            }
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)toPull, (boolean)false);
            int transferred = toPull.m_41613_() - excess.m_41613_();
            if (transferred > 0) {
                srcHandler.extractItem(this.pullSlots.getOrDefault(dir, 0).intValue(), transferred, false);
                return true;
            }
            this.pullSlots.put(dir, this.scanForward((IItemHandler)this.inventory, this.pullSlots.getOrDefault(dir, 0)));
            return false;
        }).orElse(false);
    }

    private boolean tryMagnet(Direction dir) {
        if (this.getUpgrades(ModUpgrades.MAGNET.get()) > 0) {
            int range = this.getUpgrades(ModUpgrades.RANGE.get());
            BlockPos centrePos = this.f_58858_.m_5484_(dir, range + 2);
            AABB aabb = new AABB(centrePos).m_82400_((double)(range + 1));
            List items = this.nonNullLevel().m_6443_(ItemEntity.class, aabb, item -> item != null && item.m_6084_() && !item.m_32063_() && !ItemRegistry.getInstance().shouldSuppressMagnet((Entity)item));
            boolean didWork = false;
            for (ItemEntity item2 : items) {
                ItemStack stack = item2.m_32055_();
                ItemStack excess = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)stack, (boolean)false);
                if (excess.m_41619_()) {
                    item2.m_146870_();
                } else {
                    item2.m_32045_(excess);
                }
                if (excess.m_41613_() >= stack.m_41613_()) continue;
                NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle(AirParticleData.DENSE, item2.m_20185_(), item2.m_20186_() + 0.5, item2.m_20189_(), 0.0, 0.0, 0.0, 5, 0.5, 0.5, 0.5), this);
                didWork = true;
            }
            return didWork;
        }
        return false;
    }

    private void validateCachedSlot(Map<Direction, Integer> slotMap, Direction dir, IItemHandler handler) {
        if (slotMap.getOrDefault(dir, 0) >= handler.getSlots()) {
            slotMap.remove(dir);
        }
    }

    private ItemStack findNextItem(IItemHandler handler, EnumMap<Direction, Integer> slotMap, Direction dir) {
        if (handler.getSlots() <= 0) {
            return ItemStack.f_41583_;
        }
        if (handler.getStackInSlot(slotMap.getOrDefault(dir, 0).intValue()).m_41619_()) {
            slotMap.put(dir, this.scanForward(handler, slotMap.getOrDefault(dir, 0)));
        }
        return handler.extractItem(slotMap.getOrDefault(dir, 0).intValue(), this.getMaxItems(), true);
    }

    private int scanForward(IItemHandler handler, int slot) {
        int limit = handler.getSlots();
        for (int i = 0; i < limit; ++i) {
            if (++slot >= limit) {
                slot = 0;
            }
            if (!handler.getStackInSlot(slot).m_41619_()) break;
        }
        return slot;
    }

    public int getTickRate() {
        return 8 >> Math.min(3, this.getUpgrades(ModUpgrades.SPEED.get()));
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(ModUpgrades.SPEED.get());
        return upgrades > 3 ? Math.min(1 << upgrades - 3, 256) : 1;
    }

    public Direction getAbsoluteFacing(SideConfigurator.RelativeFace face, Direction dir) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case SideConfigurator.RelativeFace.TOP -> Direction.UP;
            case SideConfigurator.RelativeFace.BOTTOM -> Direction.DOWN;
            case SideConfigurator.RelativeFace.FRONT -> dir;
            case SideConfigurator.RelativeFace.RIGHT -> dir.m_122428_();
            case SideConfigurator.RelativeFace.LEFT -> dir.m_122427_();
            case SideConfigurator.RelativeFace.BACK -> dir.m_122424_();
        };
    }

    public PushPullMode getPushPullMode(SideConfigurator.RelativeFace face) {
        int idx = face.ordinal();
        int mask = 3 << idx * 2;
        int n = (this.pushPullModes & mask) >> idx * 2;
        return PushPullMode.values()[n];
    }

    private void setPushPullMode(SideConfigurator.RelativeFace face, PushPullMode mode) {
        int idx = face.ordinal();
        int mask = 3 << idx * 2;
        this.pushPullModes &= ~mask;
        this.pushPullModes |= mode.ordinal() << idx * 2;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.inventoryCap;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHandler.sendToPlayer(new PacketSyncSmartChest(this), (ServerPlayer)player);
        }
        return new SmartChestMenu(windowId, inv, this.m_58899_());
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(NBT_ITEMS, (Tag)this.inventory.serializeNBT());
        tag.m_128405_("pushPull", this.pushPullModes);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_(NBT_ITEMS));
        this.pushPullModes = tag.m_128451_("pushPull");
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        boolean shouldSave;
        super.serializeExtraItemData(blockEntityTag, preserveState);
        boolean bl = shouldSave = this.inventory.lastSlot < 72 || this.rsController.getCurrentMode() != 0;
        if (!shouldSave) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).m_41619_() && this.inventory.filter[i].m_41619_()) continue;
                shouldSave = true;
            }
        }
        if (shouldSave) {
            blockEntityTag.m_128365_(NBT_ITEMS, (Tag)this.inventory.serializeNBT());
            blockEntityTag.m_128405_("redstoneMode", this.rsController.getCurrentMode());
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        String[] s;
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.startsWith("push_pull:") && (s = tag.split(":")).length == 2) {
            try {
                SideConfigurator.RelativeFace face = SideConfigurator.RelativeFace.valueOf(s[1]);
                this.cycleMode(face, shiftHeld);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void cycleMode(SideConfigurator.RelativeFace face, boolean shiftHeld) {
        this.setPushPullMode(face, this.getPushPullMode(face).cycle(shiftHeld));
    }

    public int getLastSlot() {
        return this.inventory.getLastSlot();
    }

    public void setLastSlot(int lastSlot) {
        this.inventory.setLastSlot(lastSlot);
    }

    public List<Pair<Integer, ItemStack>> getFilter() {
        ArrayList<Pair<Integer, ItemStack>> res = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.filter[i].m_41619_()) continue;
            res.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)this.inventory.filter[i].m_41777_()));
        }
        return res;
    }

    public void setFilter(List<Pair<Integer, ItemStack>> l) {
        Arrays.fill(this.inventory.filter, ItemStack.f_41583_);
        for (Pair<Integer, ItemStack> p : l) {
            this.inventory.setFilter((Integer)p.getLeft(), (ItemStack)p.getRight());
        }
    }

    public ItemStack getFilter(int slotId) {
        return this.inventory.filter[slotId];
    }

    public void setFilter(int slotId, ItemStack stack) {
        this.inventory.filter[slotId] = stack.m_41777_();
    }

    @Override
    public RedstoneController<SmartChestBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getComparatorValue();
    }

    public static IItemHandler deserializeSmartChest(CompoundTag tag) {
        SmartChestItemHandler res = new SmartChestItemHandler(null, 72);
        res.deserializeNBT(tag);
        return res;
    }

    public static class SmartChestItemHandler
    extends ComparatorItemStackHandler {
        private final ItemStack[] filter = new ItemStack[72];
        private int lastSlot = 72;

        SmartChestItemHandler(BlockEntity te, int size) {
            super(te, size);
            Arrays.fill(this.filter, ItemStack.f_41583_);
        }

        public int getSlots() {
            return Math.min(72, this.lastSlot);
        }

        public int getSlotLimit(int slot) {
            return this.filter[slot].m_41619_() ? super.getSlotLimit(slot) : this.filter[slot].m_41613_();
        }

        int getLastSlot() {
            return this.lastSlot;
        }

        void setLastSlot(int lastSlot) {
            for (int i = lastSlot; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).m_41619_()) continue;
                return;
            }
            this.lastSlot = lastSlot;
        }

        public void setFilter(int slot, ItemStack stack) {
            this.filter[slot] = stack;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < this.lastSlot && (this.filter[slot].m_41619_() || this.filter[slot].m_41720_() == stack.m_41720_()) && stack.m_41720_() != ((ReinforcedChestBlock)ModBlocks.REINFORCED_CHEST.get()).m_5456_() && stack.m_41720_() != ((SmartChestBlock)ModBlocks.SMART_CHEST.get()).m_5456_() && super.isItemValid(slot, stack);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128405_("LastSlot", this.lastSlot);
            ListTag l = new ListTag();
            for (int i = 0; i < 72; ++i) {
                if (this.filter[i].m_41619_()) continue;
                CompoundTag subTag = new CompoundTag();
                subTag.m_128405_("Slot", i);
                this.filter[i].m_41739_(subTag);
                l.add((Object)subTag);
            }
            tag.m_128365_("Filter", (Tag)l);
            tag.m_128379_("V2", true);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.lastSlot = nbt.m_128451_("LastSlot");
            ListTag l = nbt.m_128437_("Filter", 10);
            boolean isV2 = nbt.m_128471_("V2");
            for (int i = 0; i < l.size(); ++i) {
                CompoundTag tag = l.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tag);
                if (!isV2 && stack.m_41613_() == 1) {
                    stack.m_41764_(stack.m_41741_());
                }
                this.filter[tag.m_128451_((String)"Slot")] = stack;
            }
        }
    }

    public static enum PushPullMode implements ITranslatableEnum
    {
        NONE("none"),
        PUSH("push"),
        PULL("pull");

        private final String key;

        private PushPullMode(String key) {
            this.key = key;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tooltip.smartChest.mode." + this.key;
        }

        public PushPullMode cycle(boolean backward) {
            int n = this.ordinal() + (backward ? -1 : 1);
            if (n < 0) {
                n = PushPullMode.values().length - 1;
            } else if (n >= PushPullMode.values().length) {
                n = 0;
            }
            return PushPullMode.values()[n];
        }
    }
}

