/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.logistics;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.inventory.LogisticsMenu;
import me.desht.pneumaticcraft.common.semiblock.SemiblockItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractLogisticsFrameItem
extends SemiblockItem {
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand handIn) {
        final ItemStack stack = player.m_21120_(handIn);
        if (!world.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return stack.m_41786_();
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    return new LogisticsMenu(AbstractLogisticsFrameItem.this.getContainerType(), i, playerInventory, -1);
                }
            }, buffer -> buffer.m_130130_(-1));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    protected abstract MenuType<?> getContainerType();

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> curInfo, TooltipFlag extraInfo) {
        super.m_7373_(stack, worldIn, curInfo, extraInfo);
        AbstractLogisticsFrameItem.addLogisticsTooltip(stack, worldIn, curInfo, ClientUtils.hasShiftDown());
    }

    public static List<Component> addLogisticsTooltip(ItemStack stack, Level world, List<Component> curInfo, boolean sneaking) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("EntityTag") && stack.m_41720_() instanceof SemiblockItem) {
            if (sneaking) {
                boolean whitelist;
                CompoundTag tag = stack.m_41783_().m_128469_("EntityTag");
                if (tag.m_128471_("invisible")) {
                    curInfo.add((Component)Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.invisible", new Object[0])).m_130940_(ChatFormatting.YELLOW));
                }
                if (tag.m_128471_("matchDurability")) {
                    curInfo.add((Component)Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchDurability", new Object[0])).m_130940_(ChatFormatting.YELLOW));
                }
                if (tag.m_128471_("matchNBT")) {
                    curInfo.add((Component)Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchNBT", new Object[0])).m_130940_(ChatFormatting.YELLOW));
                }
                if (tag.m_128471_("matchModID")) {
                    curInfo.add((Component)Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchModId", new Object[0])).m_130940_(ChatFormatting.YELLOW));
                }
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame." + ((whitelist = tag.m_128471_("whitelist")) ? "itemWhitelist" : "itemBlacklist"), new Object[0]).m_130946_(":").m_130940_(ChatFormatting.YELLOW));
                ItemStackHandler handler = new ItemStackHandler();
                handler.deserializeNBT(tag.m_128469_("filters"));
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (handler.getStackInSlot(i).m_41619_()) continue;
                    stacks.add(handler.getStackInSlot(i));
                }
                int tooltipSize = curInfo.size();
                PneumaticCraftUtils.summariseItemStacks(curInfo, stacks, Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.GOLD));
                if (curInfo.size() == tooltipSize) {
                    curInfo.add((Component)Symbols.bullet().m_130940_(ChatFormatting.GOLD).m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.no_items", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC})));
                }
                tooltipSize = curInfo.size();
                whitelist = tag.m_128471_("fluidWhitelist");
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame." + (whitelist ? "fluidWhitelist" : "fluidBlacklist"), new Object[0]).m_130946_(":").m_130940_(ChatFormatting.YELLOW));
                AbstractLogisticsFrameEntity.FluidFilter fluidFilter = new AbstractLogisticsFrameEntity.FluidFilter();
                fluidFilter.deserializeNBT(tag.m_128469_("fluidFilters"));
                for (int i = 0; i < fluidFilter.size(); ++i) {
                    FluidStack fluid = fluidFilter.get(i);
                    if (fluid.isEmpty()) continue;
                    curInfo.add((Component)Symbols.bullet().m_130946_(fluid.getAmount() + "mB ").m_7220_(fluid.getDisplayName()).m_130940_(ChatFormatting.GOLD));
                }
                if (curInfo.size() == tooltipSize) {
                    curInfo.add((Component)Symbols.bullet().m_130940_(ChatFormatting.GOLD).m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.no_fluids", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC})));
                }
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.hasFilters", new Object[0]));
            }
        }
        return curInfo;
    }
}

