/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketHackingEntityStart {
    private final int entityId;

    public PacketHackingEntityStart(Entity entity) {
        this.entityId = entity.m_19879_();
    }

    public PacketHackingEntityStart(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ArmorUpgradeRegistry r = ArmorUpgradeRegistry.getInstance();
            if (player == null) {
                Player cPlayer = ClientUtils.getClientPlayer();
                Entity entity = cPlayer.m_9236_().m_6815_(this.entityId);
                if (entity != null) {
                    CommonArmorHandler.getHandlerForPlayer(cPlayer).getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedEntity(entity);
                    ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).getTargetsStream().filter(target -> target.entity == entity).findFirst().ifPresent(RenderEntityTarget::onHackConfirmServer);
                }
            } else {
                Entity entity;
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)player);
                if (handler.upgradeUsable(CommonUpgradeHandlers.entityTrackerHandler, true) && (entity = player.m_9236_().m_6815_(this.entityId)) != null) {
                    handler.getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedEntity(entity);
                    NetworkHandler.sendToPlayer(this, player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

