/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import java.util.List;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MagnetHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.MAGNET;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{ModUpgrades.MAGNET.get()};
    }

    @Override
    public int getMaxInstallableUpgrades(PNCUpgrade upgrade) {
        return 6;
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        if (player.m_9236_().f_46443_ || !enabled || (player.m_9236_().m_46467_() & 3L) != 0L || !commonArmorHandler.hasMinPressure(EquipmentSlot.CHEST)) {
            return;
        }
        int magnetRadius = 4 + Math.min(commonArmorHandler.getUpgradeCount(EquipmentSlot.CHEST, ModUpgrades.MAGNET.get()), 6);
        int magnetRadiusSq = magnetRadius * magnetRadius;
        AABB box = new AABB(player.m_20183_()).m_82400_((double)magnetRadius);
        List itemList = player.m_20193_().m_6443_(Entity.class, box, e -> (e instanceof ExperienceOrb || e instanceof ItemEntity) && e.m_6084_());
        Vec3 playerVec = player.m_20182_();
        for (Entity item : itemList) {
            if (item instanceof ItemEntity && ((ItemEntity)item).m_32063_() || !(item.m_20182_().m_82557_(playerVec) <= (double)magnetRadiusSq) || ItemRegistry.getInstance().shouldSuppressMagnet(item) || item.getPersistentData().m_128471_("PreventRemoteMovement")) continue;
            if (!commonArmorHandler.hasMinPressure(EquipmentSlot.CHEST)) break;
            item.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            if (item instanceof ItemEntity) {
                ((ItemEntity)item).m_32010_(0);
            }
            commonArmorHandler.addAir(EquipmentSlot.CHEST, -((Integer)ConfigHelper.common().armor.magnetAirUsage.get()).intValue());
        }
    }
}

